/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.springframework.util.ClassUtils;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class DefaultPropertiesPersister
implements PropertiesPersister {
    private static final boolean loadFromReaderAvailable = ClassUtils.hasMethod(Properties.class, "load", new Class[]{Reader.class});
    private static final boolean storeToWriterAvailable = ClassUtils.hasMethod(Properties.class, "store", new Class[]{Writer.class, String.class});

    public void load(Properties props, InputStream is) throws IOException {
        props.load(is);
    }

    public void load(Properties props, Reader reader2) throws IOException {
        if (loadFromReaderAvailable) {
            props.load(reader2);
        } else {
            this.doLoad(props, reader2);
        }
    }

    protected void doLoad(Properties props, Reader reader2) throws IOException {
        BufferedReader in = new BufferedReader(reader2);
        String line;
        while ((line = in.readLine()) != null) {
            char firstChar;
            if ((line = StringUtils.trimLeadingWhitespace(line)).length() <= 0 || (firstChar = line.charAt(0)) == '#' || firstChar == '!') continue;
            while (this.endsWithContinuationMarker(line)) {
                String nextLine = in.readLine();
                line = line.substring(0, line.length() - 1);
                if (nextLine == null) continue;
                line = line + StringUtils.trimLeadingWhitespace(nextLine);
            }
            int separatorIndex = line.indexOf("=");
            if (separatorIndex == -1) {
                separatorIndex = line.indexOf(":");
            }
            String key = separatorIndex != -1 ? line.substring(0, separatorIndex) : line;
            String value2 = separatorIndex != -1 ? line.substring(separatorIndex + 1) : "";
            key = StringUtils.trimTrailingWhitespace(key);
            value2 = StringUtils.trimLeadingWhitespace(value2);
            props.put(this.unescape(key), this.unescape(value2));
        }
        return;
    }

    protected boolean endsWithContinuationMarker(String line) {
        boolean evenSlashCount = true;
        for (int index2 = line.length() - 1; index2 >= 0 && line.charAt(index2) == '\\'; --index2) {
            evenSlashCount = !evenSlashCount;
        }
        return !evenSlashCount;
    }

    protected String unescape(String str) {
        StringBuffer outBuffer = new StringBuffer(str.length());
        int index2 = 0;
        while (index2 < str.length()) {
            int c;
            if ((c = str.charAt(index2++)) == 92) {
                if ((c = str.charAt(index2++)) == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
            }
            outBuffer.append((char)c);
        }
        return outBuffer.toString();
    }

    public void store(Properties props, OutputStream os, String header) throws IOException {
        props.store(os, header);
    }

    public void store(Properties props, Writer writer2, String header) throws IOException {
        if (storeToWriterAvailable) {
            props.store(writer2, header);
        } else {
            this.doStore(props, writer2, header);
        }
    }

    protected void doStore(Properties props, Writer writer2, String header) throws IOException {
        BufferedWriter out = new BufferedWriter(writer2);
        if (header != null) {
            out.write("#" + header);
            out.newLine();
        }
        out.write("#" + new Date());
        out.newLine();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = props.getProperty(key);
            out.write(this.escape(key, true) + "=" + this.escape(val, false));
            out.newLine();
        }
        out.flush();
    }

    protected String escape(String str, boolean isKey) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int index2 = 0; index2 < len; ++index2) {
            char c = str.charAt(index2);
            switch (c) {
                case ' ': {
                    if (index2 == 0 || isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append("\\\\");
                    continue block8;
                }
                case '\t': {
                    outBuffer.append("\\t");
                    continue block8;
                }
                case '\n': {
                    outBuffer.append("\\n");
                    continue block8;
                }
                case '\r': {
                    outBuffer.append("\\r");
                    continue block8;
                }
                case '\f': {
                    outBuffer.append("\\f");
                    continue block8;
                }
                default: {
                    if ("=: \t\r\n\f#!".indexOf(c) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(c);
                }
            }
        }
        return outBuffer.toString();
    }

    public void loadFromXml(Properties props, InputStream is) throws IOException {
        try {
            props.loadFromXML(is);
        }
        catch (NoSuchMethodError err2) {
            throw new IOException("Cannot load properties XML file - not running on JDK 1.5+: " + err2.getMessage());
        }
    }

    public void storeToXml(Properties props, OutputStream os, String header) throws IOException {
        try {
            props.storeToXML(os, header);
        }
        catch (NoSuchMethodError err2) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err2.getMessage());
        }
    }

    public void storeToXml(Properties props, OutputStream os, String header, String encoding) throws IOException {
        try {
            props.storeToXML(os, header, encoding);
        }
        catch (NoSuchMethodError err2) {
            throw new IOException("Cannot store properties XML file - not running on JDK 1.5+: " + err2.getMessage());
        }
    }
}

