/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.util.Assert;

public class CachingMapDecorator
implements Map,
Serializable {
    protected static Object NULL_VALUE = new Object();
    private final Map targetMap;
    private final boolean synchronize;
    private final boolean weak;

    public CachingMapDecorator() {
        this(false);
    }

    public CachingMapDecorator(boolean weak) {
        AbstractMap internalMap = weak ? new WeakHashMap() : new HashMap();
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public CachingMapDecorator(boolean weak, int size2) {
        AbstractMap internalMap = weak ? new WeakHashMap(size2) : new HashMap(size2);
        this.targetMap = Collections.synchronizedMap(internalMap);
        this.synchronize = true;
        this.weak = weak;
    }

    public CachingMapDecorator(Map targetMap) {
        this(targetMap, false, false);
    }

    public CachingMapDecorator(Map targetMap, boolean synchronize, boolean weak) {
        Assert.notNull(targetMap, "Target Map is required");
        this.targetMap = synchronize ? Collections.synchronizedMap(targetMap) : targetMap;
        this.synchronize = synchronize;
        this.weak = weak;
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value2) {
        Object valueToCheck = value2;
        if (valueToCheck == null) {
            valueToCheck = NULL_VALUE;
        }
        if (this.synchronize) {
            Map map2 = this.targetMap;
            synchronized (map2) {
                return this.containsValueOrReference(valueToCheck);
            }
        }
        return this.containsValueOrReference(valueToCheck);
    }

    private boolean containsValueOrReference(Object value2) {
        if (this.targetMap.containsValue(value2)) {
            return true;
        }
        Iterator it = this.targetMap.values().iterator();
        while (it.hasNext()) {
            Object mapVal = it.next();
            if (!(mapVal instanceof Reference) || !value2.equals(((Reference)mapVal).get())) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object key) {
        return this.targetMap.remove(key);
    }

    public void putAll(Map map2) {
        this.targetMap.putAll(map2);
    }

    public void clear() {
        this.targetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        if (this.synchronize) {
            Map map2 = this.targetMap;
            synchronized (map2) {
                return new LinkedHashSet(this.targetMap.keySet());
            }
        }
        return new LinkedHashSet(this.targetMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        if (this.synchronize) {
            Map map2 = this.targetMap;
            synchronized (map2) {
                return this.valuesCopy();
            }
        }
        return this.valuesCopy();
    }

    private Collection valuesCopy() {
        LinkedList values = new LinkedList();
        Iterator it = this.targetMap.values().iterator();
        while (it.hasNext()) {
            Object value2 = it.next();
            values.add(value2 instanceof Reference ? ((Reference)value2).get() : value2);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.synchronize) {
            Map map2 = this.targetMap;
            synchronized (map2) {
                return new LinkedHashSet(this.targetMap.entrySet());
            }
        }
        return new LinkedHashSet(this.targetMap.entrySet());
    }

    public Object put(Object key, Object value2) {
        WeakReference<Object> newValue = value2;
        if (newValue == null) {
            newValue = NULL_VALUE;
        }
        if (this.useWeakValue(key, newValue)) {
            newValue = new WeakReference<Object>(newValue);
        }
        return this.targetMap.put(key, newValue);
    }

    protected boolean useWeakValue(Object key, Object value2) {
        return this.weak;
    }

    public Object get(Object key) {
        Object value2 = this.targetMap.get(key);
        if (value2 instanceof Reference) {
            value2 = ((Reference)value2).get();
        }
        if (value2 == null && (value2 = this.create(key)) != null) {
            this.put(key, value2);
        }
        return value2 == NULL_VALUE ? null : value2;
    }

    protected Object create(Object key) {
        return null;
    }

    public String toString() {
        return "CachingMapDecorator [" + this.getClass().getName() + "]:" + this.targetMap;
    }
}

