/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;

public abstract class VelocityEngineUtils {
    private static final Log logger = LogFactory.getLog(VelocityEngineUtils.class);

    public static void mergeTemplate(VelocityEngine velocityEngine, String templateLocation, Map model, Writer writer2) throws VelocityException {
        try {
            VelocityContext velocityContext = new VelocityContext(model);
            velocityEngine.mergeTemplate(templateLocation, (Context)velocityContext, writer2);
        }
        catch (VelocityException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("Why does VelocityEngine throw a generic checked exception, after all?", ex);
            throw new VelocityException(ex.toString());
        }
    }

    public static void mergeTemplate(VelocityEngine velocityEngine, String templateLocation, String encoding, Map model, Writer writer2) throws VelocityException {
        try {
            VelocityContext velocityContext = new VelocityContext(model);
            velocityEngine.mergeTemplate(templateLocation, encoding, (Context)velocityContext, writer2);
        }
        catch (VelocityException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error("Why does VelocityEngine throw a generic checked exception, after all?", ex);
            throw new VelocityException(ex.toString());
        }
    }

    public static String mergeTemplateIntoString(VelocityEngine velocityEngine, String templateLocation, Map model) throws VelocityException {
        StringWriter result2 = new StringWriter();
        VelocityEngineUtils.mergeTemplate(velocityEngine, templateLocation, model, result2);
        return result2.toString();
    }

    public static String mergeTemplateIntoString(VelocityEngine velocityEngine, String templateLocation, String encoding, Map model) throws VelocityException {
        StringWriter result2 = new StringWriter();
        VelocityEngineUtils.mergeTemplate(velocityEngine, templateLocation, encoding, model, result2);
        return result2.toString();
    }
}

