/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.JdoCallback;
import org.springframework.orm.jdo.JdoOperations;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdoTemplate
extends JdoAccessor
implements JdoOperations {
    private boolean allowCreate = true;
    private boolean exposeNativePersistenceManager = false;

    public JdoTemplate() {
    }

    public JdoTemplate(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
        this.afterPropertiesSet();
    }

    public JdoTemplate(PersistenceManagerFactory pmf, boolean allowCreate) {
        this.setPersistenceManagerFactory(pmf);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setExposeNativePersistenceManager(boolean exposeNativePersistenceManager) {
        this.exposeNativePersistenceManager = exposeNativePersistenceManager;
    }

    public boolean isExposeNativePersistenceManager() {
        return this.exposeNativePersistenceManager;
    }

    public Object execute(JdoCallback action) throws DataAccessException {
        return this.execute(action, this.isExposeNativePersistenceManager());
    }

    public Collection executeFind(JdoCallback action) throws DataAccessException {
        Object result2 = this.execute(action, this.isExposeNativePersistenceManager());
        if (result2 != null && !(result2 instanceof Collection)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from JdoCallback isn't a Collection: [" + result2 + "]");
        }
        return (Collection)result2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(JdoCallback action, boolean exposeNativePersistenceManager) throws DataAccessException {
        Object object;
        Assert.notNull(action, "Callback object must not be null");
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), this.isAllowCreate());
        boolean existingTransaction = TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory());
        try {
            try {
                PersistenceManager pmToExpose = exposeNativePersistenceManager ? pm : this.createPersistenceManagerProxy(pm);
                Object result2 = action.doInJdo(pmToExpose);
                this.flushIfNecessary(pm, existingTransaction);
                object = this.postProcessResult(result2, pm, existingTransaction);
                Object var9_10 = null;
            }
            catch (JDOException ex) {
                throw this.convertJdoAccessException(ex);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
            throw throwable;
        }
        PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
        return object;
    }

    protected PersistenceManager createPersistenceManagerProxy(PersistenceManager pm) {
        Class[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), this.getClass().getClassLoader());
        return (PersistenceManager)Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(pm));
    }

    protected Object postProcessResult(Object result2, PersistenceManager pm, boolean existingTransaction) {
        return result2;
    }

    public Object getObjectById(final Object objectId) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.getObjectById(objectId, true);
            }
        }, true);
    }

    public Object getObjectById(final Class entityClass, final Object idValue) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.getObjectById(entityClass, idValue);
            }
        }, true);
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evict(entity);
                return null;
            }
        }, true);
    }

    public void evictAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evictAll(entities);
                return null;
            }
        }, true);
    }

    public void evictAll() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evictAll();
                return null;
            }
        }, true);
    }

    public void refresh(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refresh(entity);
                return null;
            }
        }, true);
    }

    public void refreshAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refreshAll(entities);
                return null;
            }
        }, true);
    }

    public void refreshAll() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refreshAll();
                return null;
            }
        }, true);
    }

    public Object makePersistent(final Object entity) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.makePersistent(entity);
            }
        }, true);
    }

    public Collection makePersistentAll(final Collection entities) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.makePersistentAll(entities);
            }
        }, true);
    }

    public void deletePersistent(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistent(entity);
                return null;
            }
        }, true);
    }

    public void deletePersistentAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistentAll(entities);
                return null;
            }
        }, true);
    }

    public Object detachCopy(final Object entity) {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.detachCopy(entity);
            }
        }, true);
    }

    public Collection detachCopyAll(final Collection entities) {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.detachCopyAll(entities);
            }
        }, true);
    }

    public Object attachCopy(Object detachedEntity) {
        return this.makePersistent(detachedEntity);
    }

    public Collection attachCopyAll(Collection detachedEntities) {
        return this.makePersistentAll(detachedEntities);
    }

    public void flush() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                JdoTemplate.this.getJdoDialect().flush(pm);
                return null;
            }
        }, true);
    }

    public Collection find(Class entityClass) throws DataAccessException {
        return this.find(entityClass, null, null);
    }

    public Collection find(Class entityClass, String filter2) throws DataAccessException {
        return this.find(entityClass, filter2, null);
    }

    public Collection find(final Class entityClass, final String filter2, final String ordering) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = filter2 != null ? pm.newQuery(entityClass, filter2) : pm.newQuery(entityClass);
                JdoTemplate.this.prepareQuery(query2);
                if (ordering != null) {
                    query2.setOrdering(ordering);
                }
                return query2.execute();
            }
        }, true);
    }

    public Collection find(Class entityClass, String filter2, String parameters, Object[] values) throws DataAccessException {
        return this.find(entityClass, filter2, parameters, values, null);
    }

    public Collection find(final Class entityClass, final String filter2, final String parameters, final Object[] values, final String ordering) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newQuery(entityClass, filter2);
                JdoTemplate.this.prepareQuery(query2);
                query2.declareParameters(parameters);
                if (ordering != null) {
                    query2.setOrdering(ordering);
                }
                return query2.executeWithArray(values);
            }
        }, true);
    }

    public Collection find(Class entityClass, String filter2, String parameters, Map values) throws DataAccessException {
        return this.find(entityClass, filter2, parameters, values, null);
    }

    public Collection find(final Class entityClass, final String filter2, final String parameters, final Map values, final String ordering) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newQuery(entityClass, filter2);
                JdoTemplate.this.prepareQuery(query2);
                query2.declareParameters(parameters);
                if (ordering != null) {
                    query2.setOrdering(ordering);
                }
                return query2.executeWithMap(values);
            }
        }, true);
    }

    public Collection find(final String language2, final Object queryObject) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newQuery(language2, queryObject);
                JdoTemplate.this.prepareQuery(query2);
                return query2.execute();
            }
        }, true);
    }

    public Collection find(final String queryString) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newQuery(queryString);
                JdoTemplate.this.prepareQuery(query2);
                return query2.execute();
            }
        }, true);
    }

    public Collection find(final String queryString, final Object[] values) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newQuery(queryString);
                JdoTemplate.this.prepareQuery(query2);
                return query2.executeWithArray(values);
            }
        }, true);
    }

    public Collection find(final String queryString, final Map values) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newQuery(queryString);
                JdoTemplate.this.prepareQuery(query2);
                return query2.executeWithMap(values);
            }
        }, true);
    }

    public Collection findByNamedQuery(final Class entityClass, final String queryName) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newNamedQuery(entityClass, queryName);
                JdoTemplate.this.prepareQuery(query2);
                return query2.execute();
            }
        }, true);
    }

    public Collection findByNamedQuery(final Class entityClass, final String queryName, final Object[] values) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newNamedQuery(entityClass, queryName);
                JdoTemplate.this.prepareQuery(query2);
                return query2.executeWithArray(values);
            }
        }, true);
    }

    public Collection findByNamedQuery(final Class entityClass, final String queryName, final Map values) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query2 = pm.newNamedQuery(entityClass, queryName);
                JdoTemplate.this.prepareQuery(query2);
                return query2.executeWithMap(values);
            }
        }, true);
    }

    public void prepareQuery(Query query2) throws JDOException {
        PersistenceManagerFactoryUtils.applyTransactionTimeout(query2, this.getPersistenceManagerFactory(), this.getJdoDialect());
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final PersistenceManager target;

        public CloseSuppressingInvocationHandler(PersistenceManager target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    JdoTemplate.this.prepareQuery((Query)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

