/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jndi;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jndi.JndiCallback;
import org.springframework.jndi.TypeMismatchNamingException;
import org.springframework.util.CollectionUtils;

public class JndiTemplate {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties environment;

    public JndiTemplate() {
    }

    public JndiTemplate(Properties environment) {
        this.environment = environment;
    }

    public void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JndiCallback contextCallback) throws NamingException {
        Context ctx = this.getContext();
        try {
            Object object = contextCallback.doInContext(ctx);
            return object;
        }
        finally {
            this.releaseContext(ctx);
        }
    }

    public Context getContext() throws NamingException {
        return this.createInitialContext();
    }

    public void releaseContext(Context ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException ex) {
                this.logger.debug("Could not close JNDI InitialContext", ex);
            }
        }
    }

    protected Context createInitialContext() throws NamingException {
        Hashtable icEnv = null;
        Properties env = this.getEnvironment();
        if (env != null) {
            icEnv = new Hashtable(env.size());
            CollectionUtils.mergePropertiesIntoMap(env, icEnv);
        }
        return new InitialContext(icEnv);
    }

    public Object lookup(final String name2) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking up JNDI object with name [" + name2 + "]");
        }
        return this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                Object located = ctx.lookup(name2);
                if (located == null) {
                    throw new NameNotFoundException("JNDI object with [" + name2 + "] not found: JNDI implementation returned null");
                }
                return located;
            }
        });
    }

    public Object lookup(String name2, Class requiredType) throws NamingException {
        Object jndiObject = this.lookup(name2);
        if (requiredType != null && !requiredType.isInstance(jndiObject)) {
            throw new TypeMismatchNamingException(name2, requiredType, jndiObject != null ? jndiObject.getClass() : null);
        }
        return jndiObject;
    }

    public void bind(final String name2, final Object object) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Binding JNDI object with name [" + name2 + "]");
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.bind(name2, object);
                return null;
            }
        });
    }

    public void rebind(final String name2, final Object object) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rebinding JNDI object with name [" + name2 + "]");
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.rebind(name2, object);
                return null;
            }
        });
    }

    public void unbind(final String name2) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unbinding JNDI object with name [" + name2 + "]");
        }
        this.execute(new JndiCallback(){

            public Object doInContext(Context ctx) throws NamingException {
                ctx.unbind(name2);
                return null;
            }
        });
    }
}

