/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.util.ClassUtils;

public class ObjectNameManager {
    private static final boolean getInstanceAvailable = ClassUtils.hasMethod(ObjectName.class, "getInstance", new Class[]{String.class});

    public static ObjectName getInstance(Object objectName) throws MalformedObjectNameException {
        if (objectName instanceof ObjectName) {
            return (ObjectName)objectName;
        }
        if (!(objectName instanceof String)) {
            throw new MalformedObjectNameException("Invalid ObjectName value type [" + objectName.getClass().getName() + "]: only ObjectName and String supported.");
        }
        return ObjectNameManager.getInstance((String)objectName);
    }

    public static ObjectName getInstance(String objectName) throws MalformedObjectNameException {
        if (getInstanceAvailable) {
            return ObjectName.getInstance(objectName);
        }
        return new ObjectName(objectName);
    }

    public static ObjectName getInstance(String domainName, String key, String value2) throws MalformedObjectNameException {
        if (getInstanceAvailable) {
            return ObjectName.getInstance(domainName, key, value2);
        }
        return new ObjectName(domainName, key, value2);
    }

    public static ObjectName getInstance(String domainName, Hashtable properties) throws MalformedObjectNameException {
        if (getInstanceAvailable) {
            return ObjectName.getInstance(domainName, properties);
        }
        return new ObjectName(domainName, properties);
    }
}

