/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.JmxMetadataUtils;
import org.springframework.jmx.export.metadata.ManagedNotification;
import org.springframework.util.StringUtils;

public abstract class AbstractConfigurableMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler {
    private ModelMBeanNotificationInfo[] notificationInfos;
    private final Map notificationInfoMappings = new HashMap();

    public void setNotificationInfos(ManagedNotification[] notificationInfos) {
        ModelMBeanNotificationInfo[] infos = new ModelMBeanNotificationInfo[notificationInfos.length];
        for (int i = 0; i < notificationInfos.length; ++i) {
            ManagedNotification notificationInfo = notificationInfos[i];
            infos[i] = JmxMetadataUtils.convertToModelMBeanNotificationInfo(notificationInfo);
        }
        this.notificationInfos = infos;
    }

    public void setNotificationInfoMappings(Map notificationInfoMappings) {
        Iterator entries = notificationInfoMappings.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Property [notificationInfoMappings] only accepts Strings for Map keys");
            }
            this.notificationInfoMappings.put(entry.getKey(), this.extractNotificationMetadata(entry.getValue()));
        }
    }

    protected ModelMBeanNotificationInfo[] getNotificationInfo(Object managedBean, String beanKey) {
        ModelMBeanNotificationInfo[] result2 = null;
        if (StringUtils.hasText(beanKey)) {
            result2 = (ModelMBeanNotificationInfo[])this.notificationInfoMappings.get(beanKey);
        }
        if (result2 == null) {
            result2 = this.notificationInfos;
        }
        return result2 == null ? new ModelMBeanNotificationInfo[]{} : result2;
    }

    private ModelMBeanNotificationInfo[] extractNotificationMetadata(Object mapValue) {
        if (mapValue instanceof ManagedNotification) {
            ManagedNotification mn = (ManagedNotification)mapValue;
            return new ModelMBeanNotificationInfo[]{JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn)};
        }
        if (mapValue instanceof Collection) {
            Collection col = (Collection)mapValue;
            ArrayList<ModelMBeanNotificationInfo> result2 = new ArrayList<ModelMBeanNotificationInfo>();
            Iterator iterator2 = col.iterator();
            while (iterator2.hasNext()) {
                Object colValue = iterator2.next();
                if (!(colValue instanceof ManagedNotification)) {
                    throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
                }
                ManagedNotification mn = (ManagedNotification)colValue;
                result2.add(JmxMetadataUtils.convertToModelMBeanNotificationInfo(mn));
            }
            return result2.toArray(new ModelMBeanNotificationInfo[result2.size()]);
        }
        throw new IllegalArgumentException("Property 'notificationInfoMappings' only accepts ManagedNotifications for Map values");
    }
}

