/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.listener.SubscriptionNameProvider;
import org.springframework.jms.listener.adapter.ListenerExecutionFailedException;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;

public class MessageListenerAdapter
implements MessageListener,
SessionAwareMessageListener,
SubscriptionNameProvider {
    public static final String ORIGINAL_DEFAULT_LISTENER_METHOD = "handleMessage";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Object delegate;
    private String defaultListenerMethod = "handleMessage";
    private Object defaultResponseDestination;
    private DestinationResolver destinationResolver = new DynamicDestinationResolver();
    private MessageConverter messageConverter;

    public MessageListenerAdapter() {
        this.initDefaultStrategies();
        this.delegate = this;
    }

    public MessageListenerAdapter(Object delegate) {
        this.initDefaultStrategies();
        this.setDelegate(delegate);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
    }

    protected Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    public void setDefaultResponseDestination(Destination destination) {
        this.defaultResponseDestination = destination;
    }

    public void setDefaultResponseQueueName(String destinationName) {
        this.defaultResponseDestination = new DestinationNameHolder(destinationName, false);
    }

    public void setDefaultResponseTopicName(String destinationName) {
        this.defaultResponseDestination = new DestinationNameHolder(destinationName, true);
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        Assert.notNull(destinationResolver, "DestinationResolver must not be null");
        this.destinationResolver = destinationResolver;
    }

    protected DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    protected MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void onMessage(Message message) {
        try {
            this.onMessage(message, null);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    public void onMessage(Message message, Session session) throws JMSException {
        Object convertedMessage;
        String methodName;
        Object delegate = this.getDelegate();
        if (delegate != this) {
            if (delegate instanceof SessionAwareMessageListener) {
                if (session != null) {
                    ((SessionAwareMessageListener)delegate).onMessage(message, session);
                    return;
                }
                if (!(delegate instanceof MessageListener)) {
                    throw new IllegalStateException("MessageListenerAdapter cannot handle a SessionAwareMessageListener delegate if it hasn't been invoked with a Session itself");
                }
            }
            if (delegate instanceof MessageListener) {
                ((MessageListener)delegate).onMessage(message);
                return;
            }
        }
        if ((methodName = this.getListenerMethodName(message, convertedMessage = this.extractMessage(message))) == null) {
            throw new IllegalStateException("No default listener method specified: Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
        }
        Object[] listenerArguments = this.buildListenerArguments(convertedMessage);
        Object result2 = this.invokeListenerMethod(methodName, listenerArguments);
        if (result2 != null) {
            this.handleResult(result2, message, session);
        } else {
            this.logger.trace("No result object given - no result to handle");
        }
    }

    public String getSubscriptionName() {
        if (this.delegate instanceof SubscriptionNameProvider) {
            return ((SubscriptionNameProvider)this.delegate).getSubscriptionName();
        }
        return this.delegate.getClass().getName();
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter(new SimpleMessageConverter());
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error("Listener execution failed", ex);
    }

    protected Object extractMessage(Message message) throws JMSException {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.fromMessage(message);
        }
        return message;
    }

    protected String getListenerMethodName(Message originalMessage, Object extractedMessage) throws JMSException {
        return this.getDefaultListenerMethod();
    }

    protected Object[] buildListenerArguments(Object extractedMessage) {
        return new Object[]{extractedMessage};
    }

    protected Object invokeListenerMethod(String methodName, Object[] arguments) throws JMSException {
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(this.getDelegate());
            methodInvoker.setTargetMethod(methodName);
            methodInvoker.setArguments(arguments);
            methodInvoker.prepare();
            return methodInvoker.invoke();
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof JMSException) {
                throw (JMSException)targetEx;
            }
            throw new ListenerExecutionFailedException("Listener method '" + methodName + "' threw exception", targetEx);
        }
        catch (Throwable ex) {
            throw new ListenerExecutionFailedException("Failed to invoke target method '" + methodName + "' with arguments " + ObjectUtils.nullSafeToString(arguments), ex);
        }
    }

    protected void handleResult(Object result2, Message request, Session session) throws JMSException {
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Listener method returned result [" + result2 + "] - generating response message for it");
            }
            Message response = this.buildMessage(session, result2);
            this.postProcessResponse(request, response);
            Destination destination = this.getResponseDestination(request, response, session);
            this.sendResponse(session, destination, response);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Listener method returned result [" + result2 + "]: not generating response message for it because of no JMS Session given");
        }
    }

    protected Message buildMessage(Session session, Object result2) throws JMSException {
        MessageConverter converter = this.getMessageConverter();
        if (converter != null) {
            return converter.toMessage(result2, session);
        }
        if (!(result2 instanceof Message)) {
            throw new MessageConversionException("No MessageConverter specified - cannot handle message [" + result2 + "]");
        }
        return (Message)result2;
    }

    protected void postProcessResponse(Message request, Message response) throws JMSException {
        String correlation = request.getJMSCorrelationID();
        if (correlation == null) {
            correlation = request.getJMSMessageID();
        }
        response.setJMSCorrelationID(correlation);
    }

    protected Destination getResponseDestination(Message request, Message response, Session session) throws JMSException {
        Destination replyTo = request.getJMSReplyTo();
        if (replyTo == null && (replyTo = this.resolveDefaultResponseDestination(session)) == null) {
            throw new InvalidDestinationException("Cannot determine response destination: Request message does not contain reply-to destination, and no default response destination set.");
        }
        return replyTo;
    }

    protected Destination resolveDefaultResponseDestination(Session session) throws JMSException {
        if (this.defaultResponseDestination instanceof Destination) {
            return (Destination)this.defaultResponseDestination;
        }
        if (this.defaultResponseDestination instanceof DestinationNameHolder) {
            DestinationNameHolder nameHolder = (DestinationNameHolder)this.defaultResponseDestination;
            return this.getDestinationResolver().resolveDestinationName(session, nameHolder.name, nameHolder.isTopic);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Session session, Destination destination, Message response) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        try {
            this.postProcessProducer(producer, response);
            producer.send(response);
        }
        finally {
            JmsUtils.closeMessageProducer(producer);
        }
    }

    protected void postProcessProducer(MessageProducer producer, Message response) throws JMSException {
    }

    private static class DestinationNameHolder {
        public final String name;
        public final boolean isTopic;

        public DestinationNameHolder(String name2, boolean isTopic) {
            this.name = name2;
            this.isTopic = isTopic;
        }
    }
}

