/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.incrementer;

import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.util.Assert;

public abstract class AbstractDataFieldMaxValueIncrementer
implements DataFieldMaxValueIncrementer,
InitializingBean {
    private DataSource dataSource;
    private String incrementerName;
    protected int paddingLength = 0;

    public AbstractDataFieldMaxValueIncrementer() {
    }

    public AbstractDataFieldMaxValueIncrementer(DataSource dataSource, String incrementerName) {
        Assert.notNull(dataSource, "DataSource must not be null");
        Assert.notNull(incrementerName, "Incrementer name must not be null");
        this.dataSource = dataSource;
        this.incrementerName = incrementerName;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setIncrementerName(String incrementerName) {
        this.incrementerName = incrementerName;
    }

    public String getIncrementerName() {
        return this.incrementerName;
    }

    public void setPaddingLength(int paddingLength) {
        this.paddingLength = paddingLength;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public void afterPropertiesSet() {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
        if (this.incrementerName == null) {
            throw new IllegalArgumentException("Property 'incrementerName' is required");
        }
    }

    public int nextIntValue() throws DataAccessException {
        return (int)this.getNextKey();
    }

    public long nextLongValue() throws DataAccessException {
        return this.getNextKey();
    }

    public String nextStringValue() throws DataAccessException {
        String s2 = Long.toString(this.getNextKey());
        int len = s2.length();
        if (len < this.paddingLength) {
            StringBuffer buf = new StringBuffer(this.paddingLength);
            for (int i = 0; i < this.paddingLength - len; ++i) {
                buf.append('0');
            }
            buf.append(s2);
            s2 = buf.toString();
        }
        return s2;
    }

    protected abstract long getNextKey();
}

