/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.MetaDataAccessException;

public abstract class JdbcUtils {
    public static final int TYPE_UNKNOWN = Integer.MIN_VALUE;
    private static final Log logger = LogFactory.getLog(JdbcUtils.class);
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug("Could not close JDBC Connection", ex);
            }
            catch (Throwable ex) {
                logger.debug("Unexpected exception on closing JDBC Connection", ex);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                logger.trace("Could not close JDBC Statement", ex);
            }
            catch (Throwable ex) {
                logger.trace("Unexpected exception on closing JDBC Statement", ex);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.trace("Could not close JDBC ResultSet", ex);
            }
            catch (Throwable ex) {
                logger.trace("Unexpected exception on closing JDBC ResultSet", ex);
            }
        }
    }

    public static Object getResultSetValue(ResultSet rs, int index2, Class requiredType) throws SQLException {
        if (requiredType == null) {
            return JdbcUtils.getResultSetValue(rs, index2);
        }
        Object value2 = null;
        boolean wasNullCheck = false;
        if (String.class.equals(requiredType)) {
            value2 = rs.getString(index2);
        } else if (Boolean.TYPE.equals(requiredType) || Boolean.class.equals(requiredType)) {
            value2 = rs.getBoolean(index2);
            wasNullCheck = true;
        } else if (Byte.TYPE.equals(requiredType) || Byte.class.equals(requiredType)) {
            value2 = new Byte(rs.getByte(index2));
            wasNullCheck = true;
        } else if (Short.TYPE.equals(requiredType) || Short.class.equals(requiredType)) {
            value2 = new Short(rs.getShort(index2));
            wasNullCheck = true;
        } else if (Integer.TYPE.equals(requiredType) || Integer.class.equals(requiredType)) {
            value2 = new Integer(rs.getInt(index2));
            wasNullCheck = true;
        } else if (Long.TYPE.equals(requiredType) || Long.class.equals(requiredType)) {
            value2 = new Long(rs.getLong(index2));
            wasNullCheck = true;
        } else if (Float.TYPE.equals(requiredType) || Float.class.equals(requiredType)) {
            value2 = new Float(rs.getFloat(index2));
            wasNullCheck = true;
        } else if (Double.TYPE.equals(requiredType) || Double.class.equals(requiredType) || Number.class.equals(requiredType)) {
            value2 = new Double(rs.getDouble(index2));
            wasNullCheck = true;
        } else {
            value2 = [B.class.equals(requiredType) ? (Object)rs.getBytes(index2) : (Date.class.equals(requiredType) ? rs.getDate(index2) : (Time.class.equals(requiredType) ? rs.getTime(index2) : (Timestamp.class.equals(requiredType) || java.util.Date.class.equals(requiredType) ? rs.getTimestamp(index2) : (BigDecimal.class.equals(requiredType) ? rs.getBigDecimal(index2) : (Blob.class.equals(requiredType) ? rs.getBlob(index2) : (Clob.class.equals(requiredType) ? rs.getClob(index2) : JdbcUtils.getResultSetValue(rs, index2)))))));
        }
        if (wasNullCheck && value2 != null && rs.wasNull()) {
            value2 = null;
        }
        return value2;
    }

    public static Object getResultSetValue(ResultSet rs, int index2) throws SQLException {
        Object obj = rs.getObject(index2);
        String className = null;
        if (obj != null) {
            className = obj.getClass().getName();
        }
        if (obj instanceof Blob) {
            obj = rs.getBytes(index2);
        } else if (obj instanceof Clob) {
            obj = rs.getString(index2);
        } else if (className != null && ("oracle.sql.TIMESTAMP".equals(className) || "oracle.sql.TIMESTAMPTZ".equals(className))) {
            obj = rs.getTimestamp(index2);
        } else if (className != null && className.startsWith("oracle.sql.DATE")) {
            String metaDataClassName = rs.getMetaData().getColumnClassName(index2);
            obj = "java.sql.Timestamp".equals(metaDataClassName) || "oracle.sql.TIMESTAMP".equals(metaDataClassName) ? rs.getTimestamp(index2) : rs.getDate(index2);
        } else if (obj != null && obj instanceof Date && "java.sql.Timestamp".equals(rs.getMetaData().getColumnClassName(index2))) {
            obj = rs.getTimestamp(index2);
        }
        return obj;
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, DatabaseMetaDataCallback action) throws MetaDataAccessException {
        Connection con = null;
        try {
            con = DataSourceUtils.getConnection(dataSource);
            if (con == null) {
                throw new MetaDataAccessException("Connection returned by DataSource [" + dataSource + "] was null");
            }
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData == null) {
                throw new MetaDataAccessException("DatabaseMetaData returned by Connection [" + con + "] was null");
            }
            Object object = action.processMetaData(metaData);
            return object;
        }
        catch (CannotGetJdbcConnectionException ex) {
            throw new MetaDataAccessException("Could not get Connection for extracting meta data", ex);
        }
        catch (SQLException ex) {
            throw new MetaDataAccessException("Error while extracting DatabaseMetaData", ex);
        }
        catch (AbstractMethodError err2) {
            throw new MetaDataAccessException("JDBC DatabaseMetaData method not implemented by JDBC driver - upgrade your driver", err2);
        }
        finally {
            DataSourceUtils.releaseConnection(con, dataSource);
        }
    }

    public static Object extractDatabaseMetaData(DataSource dataSource, final String metaDataMethodName) throws MetaDataAccessException {
        return JdbcUtils.extractDatabaseMetaData(dataSource, new DatabaseMetaDataCallback(){

            public Object processMetaData(DatabaseMetaData dbmd) throws SQLException, MetaDataAccessException {
                try {
                    Method method = (class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = JdbcUtils.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData).getMethod(metaDataMethodName, null);
                    return method.invoke((Object)dbmd, (Object[])null);
                }
                catch (NoSuchMethodException ex) {
                    throw new MetaDataAccessException("No method named '" + metaDataMethodName + "' found on DatabaseMetaData instance [" + dbmd + "]", ex);
                }
                catch (IllegalAccessException ex) {
                    throw new MetaDataAccessException("Could not access DatabaseMetaData method '" + metaDataMethodName + "'", ex);
                }
                catch (InvocationTargetException ex) {
                    if (ex.getTargetException() instanceof SQLException) {
                        throw (SQLException)ex.getTargetException();
                    }
                    throw new MetaDataAccessException("Invocation of DatabaseMetaData method '" + metaDataMethodName + "' failed", ex);
                }
            }
        });
    }

    public static boolean supportsBatchUpdates(Connection con) {
        try {
            DatabaseMetaData dbmd = con.getMetaData();
            if (dbmd != null) {
                if (dbmd.supportsBatchUpdates()) {
                    logger.debug("JDBC driver supports batch updates");
                    return true;
                }
                logger.debug("JDBC driver does not support batch updates");
            }
        }
        catch (SQLException ex) {
            logger.debug("JDBC driver 'supportsBatchUpdates' method threw exception", ex);
        }
        catch (AbstractMethodError err2) {
            logger.debug("JDBC driver does not support JDBC 2.0 'supportsBatchUpdates' method", err2);
        }
        return false;
    }

    public static String commonDatabaseName(String source) {
        String name2 = source;
        if (source != null && source.startsWith("DB2")) {
            name2 = "DB2";
        } else if ("Sybase SQL Server".equals(source) || "Adaptive Server Enterprise".equals(source) || "sql server".equals(source)) {
            name2 = "Sybase";
        }
        return name2;
    }

    public static boolean isNumeric(int sqlType) {
        return -7 == sqlType || -5 == sqlType || 3 == sqlType || 8 == sqlType || 6 == sqlType || 4 == sqlType || 2 == sqlType || 7 == sqlType || 5 == sqlType || -6 == sqlType;
    }

    public static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name2 = resultSetMetaData.getColumnLabel(columnIndex);
        if (name2 == null || name2.length() < 1) {
            name2 = resultSetMetaData.getColumnName(columnIndex);
        }
        return name2;
    }

    public static String convertUnderscoreNameToPropertyName(String name2) {
        StringBuffer result2 = new StringBuffer();
        boolean nextIsUpper = false;
        if (name2 != null && name2.length() > 0) {
            if (name2.length() > 1 && name2.substring(1, 2).equals("_")) {
                result2.append(name2.substring(0, 1).toUpperCase());
            } else {
                result2.append(name2.substring(0, 1).toLowerCase());
            }
            for (int i = 1; i < name2.length(); ++i) {
                String s2 = name2.substring(i, i + 1);
                if (s2.equals("_")) {
                    nextIsUpper = true;
                    continue;
                }
                if (nextIsUpper) {
                    result2.append(s2.toUpperCase());
                    nextIsUpper = false;
                    continue;
                }
                result2.append(s2.toLowerCase());
            }
        }
        return result2.toString();
    }
}

