/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper
implements RowMapper {
    private Class requiredType;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class requiredType) {
        this.requiredType = requiredType;
    }

    public void setRequiredType(Class requiredType) {
        this.requiredType = requiredType;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException(1, nrOfColumns);
        }
        Object result2 = this.getColumnValue(rs, 1, this.requiredType);
        if (result2 != null && this.requiredType != null && !this.requiredType.isInstance(result2)) {
            try {
                return this.convertValueToRequiredType(result2, this.requiredType);
            }
            catch (IllegalArgumentException ex) {
                throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + rowNum + " and column type '" + rsmd.getColumnTypeName(1) + "': " + ex.getMessage());
            }
        }
        return result2;
    }

    protected Object getColumnValue(ResultSet rs, int index2, Class requiredType) throws SQLException {
        if (requiredType != null) {
            return JdbcUtils.getResultSetValue(rs, index2, requiredType);
        }
        return this.getColumnValue(rs, index2);
    }

    protected Object getColumnValue(ResultSet rs, int index2) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index2);
    }

    protected Object convertValueToRequiredType(Object value2, Class requiredType) {
        if (String.class.equals(requiredType)) {
            return value2.toString();
        }
        if (Number.class.isAssignableFrom(requiredType)) {
            if (value2 instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)value2, requiredType);
            }
            return NumberUtils.parseNumber(value2.toString(), requiredType);
        }
        throw new IllegalArgumentException("Value [" + value2 + "] is of type [" + value2.getClass().getName() + "] and cannot be converted to required type [" + requiredType.getName() + "]");
    }
}

