/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractMessageSource
implements BeanClassLoaderAware {
    private String[] basenames = new String[0];
    private ClassLoader bundleClassLoader;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Map cachedResourceBundles = new HashMap();
    private final Map cachedBundleMessageFormats = new HashMap();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        if (basenames != null) {
            this.basenames = new String[basenames.length];
            for (int i = 0; i < basenames.length; ++i) {
                String basename = basenames[i];
                Assert.hasText(basename, "Basename must not be empty");
                this.basenames[i] = basename.trim();
            }
        } else {
            this.basenames = new String[0];
        }
    }

    public void setBundleClassLoader(ClassLoader classLoader) {
        this.bundleClassLoader = classLoader;
    }

    protected ClassLoader getBundleClassLoader() {
        return this.bundleClassLoader != null ? this.bundleClassLoader : this.beanClassLoader;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        String result2 = null;
        for (int i = 0; result2 == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            result2 = this.getStringOrNull(bundle, code);
        }
        return result2;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            ResourceBundle bundle = this.getResourceBundle(this.basenames[i], locale);
            if (bundle == null) continue;
            messageFormat = this.getMessageFormat(bundle, code, locale);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        Map map2 = this.cachedResourceBundles;
        synchronized (map2) {
            ResourceBundle bundle;
            HashMap<Locale, ResourceBundle> localeMap = (HashMap<Locale, ResourceBundle>)this.cachedResourceBundles.get(basename);
            if (localeMap != null && (bundle = (ResourceBundle)localeMap.get(locale)) != null) {
                return bundle;
            }
            try {
                bundle = this.doGetBundle(basename, locale);
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, ResourceBundle>();
                    this.cachedResourceBundles.put(basename, localeMap);
                }
                localeMap.put(locale, bundle);
                return bundle;
            }
            catch (MissingResourceException ex) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage());
                }
                return null;
            }
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageFormat getMessageFormat(ResourceBundle bundle, String code, Locale locale) throws MissingResourceException {
        Map map2 = this.cachedBundleMessageFormats;
        synchronized (map2) {
            MessageFormat result2;
            HashMap codeMap = (HashMap)this.cachedBundleMessageFormats.get(bundle);
            HashMap<Locale, MessageFormat> localeMap = null;
            if (codeMap != null && (localeMap = (HashMap<Locale, MessageFormat>)codeMap.get(code)) != null && (result2 = (MessageFormat)localeMap.get(locale)) != null) {
                return result2;
            }
            String msg = this.getStringOrNull(bundle, code);
            if (msg != null) {
                if (codeMap == null) {
                    codeMap = new HashMap();
                    this.cachedBundleMessageFormats.put(bundle, codeMap);
                }
                if (localeMap == null) {
                    localeMap = new HashMap<Locale, MessageFormat>();
                    codeMap.put(code, localeMap);
                }
                MessageFormat result3 = this.createMessageFormat(msg, locale);
                localeMap.put(locale, result3);
                return result3;
            }
            return null;
        }
    }

    private String getStringOrNull(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            return null;
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }
}

