/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.Serializable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    private final String[] codes;
    private final Object[] arguments;
    private final String defaultMessage;

    public DefaultMessageSourceResolvable(String code) {
        this(new String[]{code}, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes2) {
        this(codes2, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes2, String defaultMessage) {
        this(codes2, null, defaultMessage);
    }

    public DefaultMessageSourceResolvable(String[] codes2, Object[] arguments) {
        this(codes2, arguments, null);
    }

    public DefaultMessageSourceResolvable(String[] codes2, Object[] arguments, String defaultMessage) {
        this.codes = codes2;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected final String resolvableToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("codes [").append(StringUtils.arrayToDelimitedString(this.codes, ","));
        buf.append("]; arguments [" + StringUtils.arrayToDelimitedString(this.arguments, ","));
        buf.append("]; default message [").append(this.defaultMessage).append(']');
        return buf.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.resolvableToString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MessageSourceResolvable)) {
            return false;
        }
        MessageSourceResolvable otherResolvable = (MessageSourceResolvable)other;
        return ObjectUtils.nullSafeEquals(this.getCodes(), otherResolvable.getCodes()) && ObjectUtils.nullSafeEquals(this.getArguments(), otherResolvable.getArguments()) && ObjectUtils.nullSafeEquals(this.getDefaultMessage(), otherResolvable.getDefaultMessage());
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode(this.getCodes());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode(this.getArguments());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode(this.getDefaultMessage());
        return hashCode;
    }
}

