/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceSupport;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMessageSource
extends MessageSourceSupport
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;
    private boolean useCodeAsDefaultMessage = false;

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    protected boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    public final String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        String fallback;
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (defaultMessage == null && (fallback = this.getDefaultMessage(code)) != null) {
            return fallback;
        }
        return this.renderDefaultMessage(defaultMessage, args, locale);
    }

    public final String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        String fallback = this.getDefaultMessage(code);
        if (fallback != null) {
            return fallback;
        }
        throw new NoSuchMessageException(code, locale);
    }

    public final String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        String fallback;
        String[] codes2 = resolvable.getCodes();
        if (codes2 == null) {
            codes2 = new String[]{};
        }
        for (int i = 0; i < codes2.length; ++i) {
            String msg = this.getMessageInternal(codes2[i], resolvable.getArguments(), locale);
            if (msg == null) continue;
            return msg;
        }
        if (resolvable.getDefaultMessage() != null) {
            return this.renderDefaultMessage(resolvable.getDefaultMessage(), resolvable.getArguments(), locale);
        }
        if (codes2.length > 0 && (fallback = this.getDefaultMessage(codes2[0])) != null) {
            return fallback;
        }
        throw new NoSuchMessageException(codes2.length > 0 ? codes2[codes2.length - 1] : null, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getMessageInternal(String code, Object[] args, Locale locale) {
        if (code == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Object[] argsToUse = args;
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty(args)) {
            String message = this.resolveCodeWithoutArguments(code, locale);
            if (message != null) {
                return message;
            }
        } else {
            argsToUse = this.resolveArguments(args, locale);
            MessageFormat messageFormat = this.resolveCode(code, locale);
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return messageFormat.format(argsToUse);
                }
            }
        }
        return this.getMessageFromParent(code, argsToUse, locale);
    }

    protected String getMessageFromParent(String code, Object[] args, Locale locale) {
        MessageSource parent = this.getParentMessageSource();
        if (parent != null) {
            if (parent instanceof AbstractMessageSource) {
                return ((AbstractMessageSource)parent).getMessageInternal(code, args, locale);
            }
            return parent.getMessage(code, args, null, locale);
        }
        return null;
    }

    protected String getDefaultMessage(String code) {
        if (this.isUseCodeAsDefaultMessage()) {
            return code;
        }
        return null;
    }

    protected String renderDefaultMessage(String defaultMessage, Object[] args, Locale locale) {
        return this.formatMessage(defaultMessage, args, locale);
    }

    protected Object[] resolveArguments(Object[] args, Locale locale) {
        if (args == null) {
            return new Object[0];
        }
        ArrayList<Object> resolvedArgs = new ArrayList<Object>(args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof MessageSourceResolvable) {
                resolvedArgs.add(this.getMessage((MessageSourceResolvable)args[i], locale));
                continue;
            }
            resolvedArgs.add(args[i]);
        }
        return resolvedArgs.toArray(new Object[resolvedArgs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        MessageFormat messageFormat = this.resolveCode(code, locale);
        if (messageFormat != null) {
            MessageFormat messageFormat2 = messageFormat;
            synchronized (messageFormat2) {
                return messageFormat.format(new Object[0]);
            }
        }
        return null;
    }

    protected abstract MessageFormat resolveCode(String var1, Locale var2);
}

