/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.config.SpringConfiguredBeanDefinitionParser;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

class LoadTimeWeaverBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String WEAVER_CLASS_ATTRIBUTE = "weaver-class";
    private static final String ASPECTJ_WEAVING_ATTRIBUTE = "aspectj-weaving";
    private static final String ASPECTJ_AOP_XML_RESOURCE = "META-INF/aop.xml";
    private static final String DEFAULT_LOAD_TIME_WEAVER_CLASS_NAME = "org.springframework.context.weaving.DefaultContextLoadTimeWeaver";
    private static final String ASPECTJ_WEAVING_ENABLER_CLASS_NAME = "org.springframework.context.weaving.AspectJWeavingEnabler";

    LoadTimeWeaverBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element2) {
        if (element2.hasAttribute(WEAVER_CLASS_ATTRIBUTE)) {
            return element2.getAttribute(WEAVER_CLASS_ATTRIBUTE);
        }
        return DEFAULT_LOAD_TIME_WEAVER_CLASS_NAME;
    }

    protected String resolveId(Element element2, AbstractBeanDefinition definition, ParserContext parserContext) {
        return "loadTimeWeaver";
    }

    protected void doParse(Element element2, ParserContext parserContext, BeanDefinitionBuilder builder) {
        builder.setRole(2);
        if (this.isAspectJWeavingEnabled(element2.getAttribute(ASPECTJ_WEAVING_ATTRIBUTE), parserContext)) {
            RootBeanDefinition weavingEnablerDef = new RootBeanDefinition();
            weavingEnablerDef.setBeanClassName(ASPECTJ_WEAVING_ENABLER_CLASS_NAME);
            parserContext.getReaderContext().registerWithGeneratedName(weavingEnablerDef);
            if (this.isBeanConfigurerAspectEnabled(parserContext.getReaderContext().getBeanClassLoader())) {
                new SpringConfiguredBeanDefinitionParser().parse(element2, parserContext);
            }
        }
    }

    protected boolean isAspectJWeavingEnabled(String value2, ParserContext parserContext) {
        if ("on".equals(value2)) {
            return true;
        }
        if ("off".equals(value2)) {
            return false;
        }
        ClassLoader cl = parserContext.getReaderContext().getResourceLoader().getClassLoader();
        return cl.getResource(ASPECTJ_AOP_XML_RESOURCE) != null;
    }

    protected boolean isBeanConfigurerAspectEnabled(ClassLoader beanClassLoader) {
        return ClassUtils.isPresent("org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect", beanClassLoader);
    }
}

