/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.beans.support.SortDefinition;
import org.springframework.util.Assert;

public class PagedListHolder
implements Serializable {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_MAX_LINKED_PAGES = 10;
    private List source;
    private Date refreshDate;
    private SortDefinition sort;
    private SortDefinition sortUsed;
    private int pageSize = 10;
    private int page = 0;
    private boolean newPageSet;
    private int maxLinkedPages = 10;

    public PagedListHolder() {
        this(new ArrayList(0));
    }

    public PagedListHolder(List source) {
        this(source, new MutableSortDefinition(true));
    }

    public PagedListHolder(List source, SortDefinition sort2) {
        this.setSource(source);
        this.setSort(sort2);
    }

    public void setSource(List source) {
        Assert.notNull(source, "Source List must not be null");
        this.source = source;
        this.refreshDate = new Date();
        this.sortUsed = null;
    }

    public List getSource() {
        return this.source;
    }

    public Date getRefreshDate() {
        return this.refreshDate;
    }

    public void setSort(SortDefinition sort2) {
        this.sort = sort2;
    }

    public SortDefinition getSort() {
        return this.sort;
    }

    public void setPageSize(int pageSize) {
        if (pageSize != this.pageSize) {
            this.pageSize = pageSize;
            if (!this.newPageSet) {
                this.page = 0;
            }
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPage(int page) {
        this.page = page;
        this.newPageSet = true;
    }

    public int getPage() {
        this.newPageSet = false;
        if (this.page >= this.getPageCount()) {
            this.page = this.getPageCount() - 1;
        }
        return this.page;
    }

    public void setMaxLinkedPages(int maxLinkedPages) {
        this.maxLinkedPages = maxLinkedPages;
    }

    public int getMaxLinkedPages() {
        return this.maxLinkedPages;
    }

    public int getPageCount() {
        float nrOfPages = (float)this.getNrOfElements() / (float)this.getPageSize();
        return (int)(nrOfPages > (float)((int)nrOfPages) || (double)nrOfPages == 0.0 ? nrOfPages + 1.0f : nrOfPages);
    }

    public boolean isFirstPage() {
        return this.getPage() == 0;
    }

    public boolean isLastPage() {
        return this.getPage() == this.getPageCount() - 1;
    }

    public void previousPage() {
        if (!this.isFirstPage()) {
            --this.page;
        }
    }

    public void nextPage() {
        if (!this.isLastPage()) {
            ++this.page;
        }
    }

    public int getNrOfElements() {
        return this.getSource().size();
    }

    public int getFirstElementOnPage() {
        return this.getPageSize() * this.getPage();
    }

    public int getLastElementOnPage() {
        int size2;
        int endIndex = this.getPageSize() * (this.getPage() + 1);
        return (endIndex > (size2 = this.getNrOfElements()) ? size2 : endIndex) - 1;
    }

    public List getPageList() {
        return this.getSource().subList(this.getFirstElementOnPage(), this.getLastElementOnPage() + 1);
    }

    public int getFirstLinkedPage() {
        return Math.max(0, this.getPage() - this.getMaxLinkedPages() / 2);
    }

    public int getLastLinkedPage() {
        return Math.min(this.getFirstLinkedPage() + this.getMaxLinkedPages() - 1, this.getPageCount() - 1);
    }

    public void resort() {
        SortDefinition sort2 = this.getSort();
        if (sort2 != null && !sort2.equals(this.sortUsed)) {
            this.sortUsed = this.copySortDefinition(sort2);
            this.doSort(this.getSource(), sort2);
            this.setPage(0);
        }
    }

    protected SortDefinition copySortDefinition(SortDefinition sort2) {
        return new MutableSortDefinition(sort2);
    }

    protected void doSort(List source, SortDefinition sort2) {
        PropertyComparator.sort(source, sort2);
    }
}

