/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map beans = new HashMap();

    public void addBean(String name2, Object bean) {
        this.beans.put(name2, bean);
    }

    public Object getBean(String name2) throws BeansException {
        String beanName = BeanFactoryUtils.transformedBeanName(name2);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(name2) && !(bean instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(beanName, bean.getClass());
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
            try {
                return ((FactoryBean)bean).getObject();
            }
            catch (Exception ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        return bean;
    }

    public Object getBean(String name2, Class requiredType) throws BeansException {
        Object bean = this.getBean(name2);
        if (requiredType != null && !requiredType.isAssignableFrom(bean.getClass())) {
            throw new BeanNotOfRequiredTypeException(name2, requiredType, bean.getClass());
        }
        return bean;
    }

    public Object getBean(String name2, Object[] args) throws BeansException {
        if (args != null) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments)");
        }
        return this.getBean(name2);
    }

    public boolean containsBean(String name2) {
        return this.beans.containsKey(name2);
    }

    public boolean isSingleton(String name2) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name2);
        return bean instanceof FactoryBean && ((FactoryBean)bean).isSingleton();
    }

    public boolean isPrototype(String name2) throws NoSuchBeanDefinitionException {
        Object bean = this.getBean(name2);
        return bean instanceof SmartFactoryBean && ((SmartFactoryBean)bean).isPrototype() || bean instanceof FactoryBean && !((FactoryBean)bean).isSingleton();
    }

    public boolean isTypeMatch(String name2, Class targetType) throws NoSuchBeanDefinitionException {
        Class type = this.getType(name2);
        return targetType == null || type != null && targetType.isAssignableFrom(type);
    }

    public Class getType(String name2) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name2);
        Object bean = this.beans.get(beanName);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (bean instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(name2)) {
            return ((FactoryBean)bean).getObjectType();
        }
        return bean.getClass();
    }

    public String[] getAliases(String name2) {
        return new String[0];
    }

    public boolean containsBeanDefinition(String name2) {
        return this.beans.containsKey(name2);
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    public String[] getBeanNamesForType(Class type) {
        return this.getBeanNamesForType(type, true, true);
    }

    public String[] getBeanNamesForType(Class type, boolean includeNonSingletons, boolean includeFactoryBeans) {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        ArrayList<String> matches = new ArrayList<String>();
        Set keys = this.beans.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String name2 = (String)it.next();
            Object beanInstance = this.beans.get(name2);
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                Class objectType;
                if (!includeFactoryBeans || (objectType = ((FactoryBean)beanInstance).getObjectType()) == null || !type.isAssignableFrom(objectType)) continue;
                matches.add(name2);
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            matches.add(name2);
        }
        return StringUtils.toStringArray(matches);
    }

    public Map getBeansOfType(Class type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    public Map getBeansOfType(Class type, boolean includeNonSingletons, boolean includeFactoryBeans) throws BeansException {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        HashMap<String, Object> matches = new HashMap<String, Object>();
        Iterator it = this.beans.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String beanName = (String)entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean && !isFactoryType) {
                if (!includeFactoryBeans) continue;
                FactoryBean factory = (FactoryBean)beanInstance;
                Class objectType = factory.getObjectType();
                if (!includeNonSingletons && !factory.isSingleton() || objectType == null || !type.isAssignableFrom(objectType)) continue;
                matches.put(beanName, this.getBean(beanName));
                continue;
            }
            if (!type.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }
}

