/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.SimpleAutowireCandidateResolver;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

abstract class AutowireUtils {
    private static final String QUALIFIED_ANNOTATION_AUTOWIRE_CANDIDATE_RESOLVER_CLASS_NAME = "org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver";

    AutowireUtils() {
    }

    public static void sortConstructors(Constructor[] constructors) {
        Arrays.sort(constructors, new Comparator(){

            public int compare(Object o1, Object o2) {
                boolean p2;
                Constructor c1 = (Constructor)o1;
                Constructor c2 = (Constructor)o2;
                boolean p1 = Modifier.isPublic(c1.getModifiers());
                if (p1 != (p2 = Modifier.isPublic(c2.getModifiers()))) {
                    return p1 ? -1 : 1;
                }
                int c1pl = c1.getParameterTypes().length;
                int c2pl = c2.getParameterTypes().length;
                return new Integer(c1pl).compareTo(new Integer(c2pl)) * -1;
            }
        });
    }

    public static boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        Method wm = pd.getWriteMethod();
        if (wm == null) {
            return false;
        }
        if (wm.getDeclaringClass().getName().indexOf("$$") == -1) {
            return false;
        }
        Class<?> superclass = wm.getDeclaringClass().getSuperclass();
        return !ClassUtils.hasMethod(superclass, wm.getName(), wm.getParameterTypes());
    }

    public static boolean isSetterDefinedInInterface(PropertyDescriptor pd, Set interfaces) {
        Method setter2 = pd.getWriteMethod();
        if (setter2 != null) {
            Class<?> targetClass = setter2.getDeclaringClass();
            Iterator it = interfaces.iterator();
            while (it.hasNext()) {
                Class ifc = (Class)it.next();
                if (!ifc.isAssignableFrom(targetClass) || !ClassUtils.hasMethod(ifc, setter2.getName(), setter2.getParameterTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public static AutowireCandidateResolver createAutowireCandidateResolver() {
        if (JdkVersion.isAtLeastJava15()) {
            try {
                Class resolverClass = ClassUtils.forName(QUALIFIED_ANNOTATION_AUTOWIRE_CANDIDATE_RESOLVER_CLASS_NAME, AutowireUtils.class.getClassLoader());
                return (AutowireCandidateResolver)resolverClass.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to load Java 1.5 dependent class [org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver]", ex);
            }
        }
        return new SimpleAutowireCandidateResolver();
    }
}

