/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyOverrideConfigurer
extends PropertyResourceConfigurer {
    public static final String DEFAULT_BEAN_NAME_SEPARATOR = ".";
    private String beanNameSeparator = ".";
    private boolean ignoreInvalidKeys = false;
    private Set beanNames = Collections.synchronizedSet(new HashSet());

    public void setBeanNameSeparator(String beanNameSeparator) {
        this.beanNameSeparator = beanNameSeparator;
    }

    public void setIgnoreInvalidKeys(boolean ignoreInvalidKeys) {
        this.ignoreInvalidKeys = ignoreInvalidKeys;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        Enumeration<?> names2 = props.propertyNames();
        while (names2.hasMoreElements()) {
            String key = (String)names2.nextElement();
            try {
                this.processKey(beanFactory, key, props.getProperty(key));
            }
            catch (BeansException ex) {
                String msg = "Could not process key '" + key + "' in PropertyOverrideConfigurer";
                if (!this.ignoreInvalidKeys) {
                    throw new BeanInitializationException(msg, ex);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(msg, ex);
            }
        }
    }

    protected void processKey(ConfigurableListableBeanFactory factory, String key, String value2) throws BeansException {
        int separatorIndex = key.indexOf(this.beanNameSeparator);
        if (separatorIndex == -1) {
            throw new BeanInitializationException("Invalid key '" + key + "': expected 'beanName" + this.beanNameSeparator + "property'");
        }
        String beanName = key.substring(0, separatorIndex);
        String beanProperty = key.substring(separatorIndex + 1);
        this.beanNames.add(beanName);
        this.applyPropertyValue(factory, beanName, beanProperty, value2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Property '" + key + "' set to value [" + value2 + "]");
        }
    }

    protected void applyPropertyValue(ConfigurableListableBeanFactory factory, String beanName, String property, String value2) {
        BeanDefinition bd = factory.getBeanDefinition(beanName);
        while (bd.getOriginatingBeanDefinition() != null) {
            bd = bd.getOriginatingBeanDefinition();
        }
        bd.getPropertyValues().addPropertyValue(property, value2);
    }

    public boolean hasPropertyOverridesFor(String beanName) {
        return this.beanNames.contains(beanName);
    }
}

