/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class ListFactoryBean
extends AbstractFactoryBean {
    private List sourceList;
    private Class targetListClass;

    public void setSourceList(List sourceList) {
        this.sourceList = sourceList;
    }

    public void setTargetListClass(Class targetListClass) {
        if (targetListClass == null) {
            throw new IllegalArgumentException("'targetListClass' must not be null");
        }
        if (!List.class.isAssignableFrom(targetListClass)) {
            throw new IllegalArgumentException("'targetListClass' must implement [java.util.List]");
        }
        this.targetListClass = targetListClass;
    }

    public Class getObjectType() {
        return List.class;
    }

    protected Object createInstance() {
        if (this.sourceList == null) {
            throw new IllegalArgumentException("'sourceList' is required");
        }
        ArrayList<Object> result2 = null;
        result2 = this.targetListClass != null ? (ArrayList<Object>)BeanUtils.instantiateClass(this.targetListClass) : new ArrayList<Object>(this.sourceList.size());
        Class valueType = null;
        if (this.targetListClass != null && JdkVersion.isAtLeastJava15()) {
            valueType = GenericCollectionTypeResolver.getCollectionType(this.targetListClass);
        }
        if (valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            Iterator it = this.sourceList.iterator();
            while (it.hasNext()) {
                result2.add(converter.convertIfNecessary(it.next(), valueType));
            }
        } else {
            result2.addAll(this.sourceList);
        }
        return result2;
    }
}

