/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class CustomScopeConfigurer
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
Ordered {
    private Map scopes;
    private int order = Integer.MAX_VALUE;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();

    public void setScopes(Map scopes) {
        this.scopes = scopes;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.scopes != null) {
            Iterator it = this.scopes.entrySet().iterator();
            while (it.hasNext()) {
                Class scopeClass;
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid scope key [" + key + "]: only Strings allowed");
                }
                String scopeName = (String)key;
                Object value2 = entry.getValue();
                if (value2 instanceof Scope) {
                    beanFactory.registerScope(scopeName, (Scope)value2);
                    continue;
                }
                if (value2 instanceof Class) {
                    scopeClass = (Class)value2;
                    Assert.isAssignable(class$org$springframework$beans$factory$config$Scope == null ? CustomScopeConfigurer.class$("org.springframework.beans.factory.config.Scope") : class$org$springframework$beans$factory$config$Scope, scopeClass);
                    beanFactory.registerScope(scopeName, (Scope)BeanUtils.instantiateClass(scopeClass));
                    continue;
                }
                if (value2 instanceof String) {
                    scopeClass = ClassUtils.resolveClassName((String)value2, this.beanClassLoader);
                    Assert.isAssignable(class$org$springframework$beans$factory$config$Scope == null ? CustomScopeConfigurer.class$("org.springframework.beans.factory.config.Scope") : class$org$springframework$beans$factory$config$Scope, scopeClass);
                    beanFactory.registerScope(scopeName, (Scope)BeanUtils.instantiateClass(scopeClass));
                    continue;
                }
                throw new IllegalArgumentException("Mapped value [" + value2 + "] for scope key [" + key + "] is not an instance of required type [" + Scope.class.getName() + "] or a corresponding Class or String value indicating a Scope implementation");
            }
        }
    }
}

