/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static boolean isFactoryDereference(String name2) {
        return name2 != null && name2.startsWith("&");
    }

    public static String transformedBeanName(String name2) {
        Assert.notNull(name2, "'name' must not be null");
        String beanName = name2;
        while (beanName.startsWith("&")) {
            beanName = beanName.substring("&".length());
        }
        return beanName;
    }

    public static boolean isGeneratedBeanName(String name2) {
        return name2 != null && name2.indexOf(GENERATED_BEAN_NAME_SEPARATOR) != -1;
    }

    public static String originalBeanName(String name2) {
        Assert.notNull(name2, "'name' must not be null");
        int separatorIndex = name2.indexOf(GENERATED_BEAN_NAME_SEPARATOR);
        return separatorIndex != -1 ? name2.substring(0, separatorIndex) : name2;
    }

    public static int countBeansIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesIncludingAncestors(lbf).length;
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors(lbf, Object.class);
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class type) {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type);
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.addAll(Arrays.asList(result2));
            for (int i = 0; i < parentResult.length; ++i) {
                String beanName = parentResult[i];
                if (resultList.contains(beanName) || hbf.containsLocalBean(beanName)) continue;
                resultList.add(beanName);
            }
            result2 = StringUtils.toStringArray(resultList);
        }
        return result2;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includeNonSingletons, boolean allowEagerInit) {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includeNonSingletons, allowEagerInit);
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.addAll(Arrays.asList(result2));
            for (int i = 0; i < parentResult.length; ++i) {
                String beanName = parentResult[i];
                if (resultList.contains(beanName) || hbf.containsLocalBean(beanName)) continue;
                resultList.add(beanName);
            }
            result2 = StringUtils.toStringArray(resultList);
        }
        return result2;
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type) throws BeansException {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        LinkedHashMap result2 = new LinkedHashMap(4);
        result2.putAll(lbf.getBeansOfType(type));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            Iterator it = parentResult.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String beanName = (String)entry.getKey();
                if (result2.containsKey(beanName) || hbf.containsLocalBean(beanName)) continue;
                result2.put(beanName, entry.getValue());
            }
        }
        return result2;
    }

    public static Map beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        LinkedHashMap result2 = new LinkedHashMap(4);
        result2.putAll(lbf.getBeansOfType(type, includeNonSingletons, allowEagerInit));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includeNonSingletons, allowEagerInit);
            Iterator it = parentResult.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String beanName = (String)entry.getKey();
                if (result2.containsKey(beanName) || hbf.containsLocalBean(beanName)) continue;
                result2.put(beanName, entry.getValue());
            }
        }
        return result2;
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type) throws BeansException {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Map beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type, includeNonSingletons, allowEagerInit);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfType(ListableBeanFactory lbf, Class type) throws BeansException {
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        Map beansOfType = lbf.getBeansOfType(type);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }

    public static Object beanOfType(ListableBeanFactory lbf, Class type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        Map beansOfType = lbf.getBeansOfType(type, includeNonSingletons, allowEagerInit);
        if (beansOfType.size() == 1) {
            return beansOfType.values().iterator().next();
        }
        throw new NoSuchBeanDefinitionException(type, "expected single bean but found " + beansOfType.size());
    }
}

