/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class TypeConverterDelegate {
    private static final Log logger = LogFactory.getLog(TypeConverterDelegate.class);
    private static final Map unknownEditorTypes = Collections.synchronizedMap(new WeakHashMap());
    private final PropertyEditorRegistrySupport propertyEditorRegistry;
    private final Object targetObject;

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry) {
        this(propertyEditorRegistry, null);
    }

    public TypeConverterDelegate(PropertyEditorRegistrySupport propertyEditorRegistry, Object targetObject) {
        this.propertyEditorRegistry = propertyEditorRegistry;
        this.targetObject = targetObject;
    }

    public Object convertIfNecessary(Object newValue, Class requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, null);
    }

    public Object convertIfNecessary(Object newValue, Class requiredType, MethodParameter methodParam) throws IllegalArgumentException {
        return this.convertIfNecessary(null, null, newValue, requiredType, null, methodParam);
    }

    public Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class requiredType) throws IllegalArgumentException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, requiredType, null, null);
    }

    public Object convertIfNecessary(Object oldValue, Object newValue, PropertyDescriptor descriptor) throws IllegalArgumentException {
        return this.convertIfNecessary(descriptor.getName(), oldValue, newValue, descriptor.getPropertyType(), descriptor, BeanUtils.getWriteMethodParameter(descriptor));
    }

    protected Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class requiredType, PropertyDescriptor descriptor, MethodParameter methodParam) throws IllegalArgumentException {
        Object convertedValue = newValue;
        PropertyEditor editor = this.propertyEditorRegistry.findCustomEditor(requiredType, propertyName);
        if (editor != null || requiredType != null && !ClassUtils.isAssignableValue(requiredType, convertedValue)) {
            if (editor == null) {
                editor = this.findDefaultEditor(requiredType, descriptor);
            }
            convertedValue = this.doConvertValue(oldValue, convertedValue, requiredType, editor);
        }
        if (requiredType != null) {
            block18: {
                if (convertedValue != null) {
                    if (String.class.equals(requiredType) && ClassUtils.isPrimitiveOrWrapper(convertedValue.getClass())) {
                        return convertedValue.toString();
                    }
                    if (requiredType.isArray()) {
                        return this.convertToTypedArray(convertedValue, propertyName, requiredType.getComponentType());
                    }
                    if (convertedValue instanceof Collection && CollectionFactory.isApproximableCollectionType(requiredType)) {
                        convertedValue = this.convertToTypedCollection((Collection)convertedValue, propertyName, methodParam);
                    } else if (convertedValue instanceof Map && CollectionFactory.isApproximableMapType(requiredType)) {
                        convertedValue = this.convertToTypedMap((Map)convertedValue, propertyName, methodParam);
                    } else if (convertedValue instanceof String && !requiredType.isInstance(convertedValue)) {
                        String strValue = ((String)convertedValue).trim();
                        if (JdkVersion.isAtLeastJava15() && requiredType.isEnum() && "".equals(strValue)) {
                            return null;
                        }
                        try {
                            Field enumField = requiredType.getField(strValue);
                            convertedValue = enumField.get(null);
                        }
                        catch (Throwable ex) {
                            if (!logger.isTraceEnabled()) break block18;
                            logger.trace("Field [" + convertedValue + "] isn't an enum value", ex);
                        }
                    }
                }
            }
            if (!ClassUtils.isAssignableValue(requiredType, convertedValue)) {
                StringBuffer msg = new StringBuffer();
                msg.append("Cannot convert value of type [").append(ClassUtils.getDescriptiveType(newValue));
                msg.append("] to required type [").append(ClassUtils.getQualifiedName(requiredType)).append("]");
                if (propertyName != null) {
                    msg.append(" for property '" + propertyName + "'");
                }
                if (editor != null) {
                    msg.append(": PropertyEditor [" + editor.getClass().getName() + "] returned inappropriate value");
                } else {
                    msg.append(": no matching editors or conversion strategy found");
                }
                throw new IllegalArgumentException(msg.toString());
            }
        }
        return convertedValue;
    }

    protected PropertyEditor findDefaultEditor(Class requiredType, PropertyDescriptor descriptor) {
        PropertyEditor editor = null;
        if (descriptor != null) {
            if (JdkVersion.isAtLeastJava15()) {
                editor = descriptor.createPropertyEditor(this.targetObject);
            } else {
                Class<?> editorClass = descriptor.getPropertyEditorClass();
                if (editorClass != null) {
                    editor = (PropertyEditor)BeanUtils.instantiateClass(editorClass);
                }
            }
        }
        if (editor == null && requiredType != null && (editor = this.propertyEditorRegistry.getDefaultEditor(requiredType)) == null && !String.class.equals(requiredType) && (editor = BeanUtils.findEditorByConvention(requiredType)) == null && !unknownEditorTypes.containsKey(requiredType)) {
            editor = PropertyEditorManager.findEditor(requiredType);
            if (editor == null) {
                unknownEditorTypes.put(requiredType, Boolean.TRUE);
            } else {
                logger.warn("PropertyEditor [" + editor.getClass().getName() + "] found through deprecated global PropertyEditorManager fallback - " + "consider using a more isolated form of registration, e.g. on the BeanWrapper/BeanFactory!");
            }
        }
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doConvertValue(Object oldValue, Object newValue, Class requiredType, PropertyEditor editor) {
        PropertyEditor propertyEditor;
        boolean sharedEditor;
        Object convertedValue;
        block18: {
            convertedValue = newValue;
            sharedEditor = false;
            if (editor != null) {
                sharedEditor = this.propertyEditorRegistry.isSharedEditor(editor);
            }
            if (editor != null && !(convertedValue instanceof String)) {
                try {
                    Object newConvertedValue = null;
                    if (sharedEditor) {
                        propertyEditor = editor;
                        synchronized (propertyEditor) {
                            editor.setValue(convertedValue);
                            newConvertedValue = editor.getValue();
                        }
                    } else {
                        editor.setValue(convertedValue);
                        newConvertedValue = editor.getValue();
                    }
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        editor = null;
                    }
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block18;
                    logger.debug("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call", ex);
                }
            }
        }
        if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
            if (logger.isTraceEnabled()) {
                logger.trace("Converting String array to comma-delimited String [" + convertedValue + "]");
            }
            convertedValue = StringUtils.arrayToCommaDelimitedString((String[])convertedValue);
        }
        if (editor != null && convertedValue instanceof String) {
            if (logger.isTraceEnabled()) {
                logger.trace("Converting String to [" + requiredType + "] using property editor [" + editor + "]");
            }
            String newTextValue = (String)convertedValue;
            if (sharedEditor) {
                propertyEditor = editor;
                synchronized (propertyEditor) {
                    return this.doConvertTextValue(oldValue, newTextValue, editor);
                }
            }
            return this.doConvertTextValue(oldValue, newTextValue, editor);
        }
        return convertedValue;
    }

    protected Object doConvertTextValue(Object oldValue, String newTextValue, PropertyEditor editor) {
        block2: {
            try {
                editor.setValue(oldValue);
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("PropertyEditor [" + editor.getClass().getName() + "] does not support setValue call", ex);
            }
        }
        editor.setAsText(newTextValue);
        return editor.getValue();
    }

    protected Object convertToTypedArray(Object input2, String propertyName, Class componentType) {
        if (input2 instanceof Collection) {
            Collection coll = (Collection)input2;
            Object result2 = Array.newInstance(componentType, coll.size());
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                Object value2 = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, it.next(), componentType);
                Array.set(result2, i, value2);
                ++i;
            }
            return result2;
        }
        if (input2.getClass().isArray()) {
            if (componentType.equals(input2.getClass().getComponentType()) && !this.propertyEditorRegistry.hasCustomEditorForElement(componentType, propertyName)) {
                return input2;
            }
            int arrayLength = Array.getLength(input2);
            Object result3 = Array.newInstance(componentType, arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Object value3 = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, i), null, Array.get(input2, i), componentType);
                Array.set(result3, i, value3);
            }
            return result3;
        }
        Object result4 = Array.newInstance(componentType, 1);
        Object value4 = this.convertIfNecessary(this.buildIndexedPropertyName(propertyName, 0), null, input2, componentType);
        Array.set(result4, 0, value4);
        return result4;
    }

    protected Collection convertToTypedCollection(Collection original, String propertyName, MethodParameter methodParam) {
        Class elementType = null;
        if (methodParam != null && JdkVersion.isAtLeastJava15()) {
            elementType = GenericCollectionTypeResolver.getCollectionParameterType(methodParam);
        }
        if (elementType == null && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        Collection convertedCopy = null;
        Iterator it = null;
        try {
            it = original.iterator();
            if (it == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collection of type [" + original.getClass().getName() + "] returned null Iterator - injecting original Collection as-is");
                }
                return original;
            }
            convertedCopy = CollectionFactory.createApproximateCollection(original, original.size());
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot access Collection of type [" + original.getClass().getName() + "] - injecting original Collection as-is", ex);
            }
            return original;
        }
        boolean actuallyConverted = false;
        int i = 0;
        while (it.hasNext()) {
            Object element2 = it.next();
            String indexedPropertyName = this.buildIndexedPropertyName(propertyName, i);
            if (methodParam != null) {
                methodParam.increaseNestingLevel();
            }
            Object convertedElement = this.convertIfNecessary(indexedPropertyName, null, element2, elementType, null, methodParam);
            if (methodParam != null) {
                methodParam.decreaseNestingLevel();
            }
            convertedCopy.add(convertedElement);
            actuallyConverted = actuallyConverted || element2 != convertedElement;
            ++i;
        }
        return actuallyConverted ? convertedCopy : original;
    }

    protected Map convertToTypedMap(Map original, String propertyName, MethodParameter methodParam) {
        Class keyType = null;
        Class valueType = null;
        if (methodParam != null && JdkVersion.isAtLeastJava15()) {
            keyType = GenericCollectionTypeResolver.getMapKeyParameterType(methodParam);
            valueType = GenericCollectionTypeResolver.getMapValueParameterType(methodParam);
        }
        if (keyType == null && valueType == null && !this.propertyEditorRegistry.hasCustomEditorForElement(null, propertyName)) {
            return original;
        }
        Map convertedCopy = null;
        Iterator it = null;
        try {
            it = original.entrySet().iterator();
            if (it == null && logger.isDebugEnabled()) {
                logger.debug("Map of type [" + original.getClass().getName() + "] returned null Iterator - injecting original Map as-is");
            }
            convertedCopy = CollectionFactory.createApproximateMap(original, original.size());
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot access Map of type [" + original.getClass().getName() + "] - injecting original Map as-is", ex);
            }
            return original;
        }
        boolean actuallyConverted = false;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            String keyedPropertyName = this.buildKeyedPropertyName(propertyName, key);
            if (methodParam != null) {
                methodParam.increaseNestingLevel();
                methodParam.setTypeIndexForCurrentLevel(0);
            }
            Object convertedKey = this.convertIfNecessary(keyedPropertyName, null, key, keyType, null, methodParam);
            if (methodParam != null) {
                methodParam.setTypeIndexForCurrentLevel(1);
            }
            Object convertedValue = this.convertIfNecessary(keyedPropertyName, null, value2, valueType, null, methodParam);
            if (methodParam != null) {
                methodParam.decreaseNestingLevel();
            }
            convertedCopy.put(convertedKey, convertedValue);
            actuallyConverted = actuallyConverted || key != convertedKey || value2 != convertedValue;
        }
        return actuallyConverted ? convertedCopy : original;
    }

    private String buildIndexedPropertyName(String propertyName, int index2) {
        return propertyName != null ? propertyName + "[" + index2 + "]" : null;
    }

    private String buildKeyedPropertyName(String propertyName, Object key) {
        return propertyName != null ? propertyName + "[" + key + "]" : null;
    }
}

