/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm.commons;

import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.Type;

public class Method {
    private final String name;
    private final String desc;
    private static final Map DESCRIPTORS = new HashMap();

    public Method(String string2, String string3) {
        this.name = string2;
        this.desc = string3;
    }

    public Method(String string2, Type type, Type[] typeArray) {
        this(string2, Type.getMethodDescriptor(type, typeArray));
    }

    public static Method getMethod(String string2) throws IllegalArgumentException {
        int n;
        int n2 = string2.indexOf(32);
        int n3 = string2.indexOf(40, n2) + 1;
        int n4 = string2.indexOf(41, n3);
        if (n2 == -1 || n3 == -1 || n4 == -1) {
            throw new IllegalArgumentException();
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1, n3 - 1).trim();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        do {
            if ((n = string2.indexOf(44, n3)) == -1) {
                stringBuffer.append(Method.map(string2.substring(n3, n4).trim()));
                continue;
            }
            stringBuffer.append(Method.map(string2.substring(n3, n).trim()));
            n3 = n + 1;
        } while (n != -1);
        stringBuffer.append(')');
        stringBuffer.append(Method.map(string3));
        return new Method(string4, stringBuffer.toString());
    }

    private static String map(String string2) {
        if (string2.equals("")) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = string2.indexOf("[]", n) + 1) > 0) {
            stringBuffer.append('[');
        }
        String string3 = string2.substring(0, string2.length() - stringBuffer.length() * 2);
        String string4 = (String)DESCRIPTORS.get(string3);
        if (string4 != null) {
            stringBuffer.append(string4);
        } else {
            stringBuffer.append('L');
            if (string3.indexOf(46) < 0) {
                stringBuffer.append("java/lang/" + string3);
            } else {
                stringBuffer.append(string3.replace('.', '/'));
            }
            stringBuffer.append(';');
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.desc;
    }

    public Type getReturnType() {
        return Type.getReturnType(this.desc);
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.desc);
    }

    public String toString() {
        return this.name + this.desc;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Method)) {
            return false;
        }
        Method method = (Method)object;
        return this.name.equals(method.name) && this.desc.equals(method.desc);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.desc.hashCode();
    }

    static {
        DESCRIPTORS.put("void", "V");
        DESCRIPTORS.put("byte", "B");
        DESCRIPTORS.put("char", "C");
        DESCRIPTORS.put("double", "D");
        DESCRIPTORS.put("float", "F");
        DESCRIPTORS.put("int", "I");
        DESCRIPTORS.put("long", "J");
        DESCRIPTORS.put("short", "S");
        DESCRIPTORS.put("boolean", "Z");
    }
}

