/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractRegexpMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private String[] patterns = new String[0];
    private String[] excludedPatterns = new String[0];

    public void setPattern(String pattern) {
        this.setPatterns(new String[]{pattern});
    }

    public void setPatterns(String[] patterns) {
        Assert.notEmpty(patterns, "'patterns' must not be empty");
        this.patterns = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            this.patterns[i] = StringUtils.trimWhitespace(patterns[i]);
        }
        this.initPatternRepresentation(this.patterns);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setExcludedPattern(String excludedPattern) {
        this.setExcludedPatterns(new String[]{excludedPattern});
    }

    public void setExcludedPatterns(String[] excludedPatterns) {
        Assert.notEmpty(excludedPatterns, "'excludedPatterns' must not be empty");
        this.excludedPatterns = new String[excludedPatterns.length];
        for (int i = 0; i < excludedPatterns.length; ++i) {
            this.excludedPatterns[i] = StringUtils.trimWhitespace(excludedPatterns[i]);
        }
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }

    public String[] getExcludedPatterns() {
        return this.excludedPatterns;
    }

    public boolean matches(Method method, Class targetClass) {
        return targetClass != null && this.matchesPattern(targetClass.getName() + "." + method.getName()) || this.matchesPattern(method.getDeclaringClass().getName() + "." + method.getName());
    }

    protected boolean matchesPattern(String signatureString) {
        for (int i = 0; i < this.patterns.length; ++i) {
            boolean matched = this.matches(signatureString, i);
            if (!matched) continue;
            for (int j = 0; j < this.excludedPatterns.length; ++j) {
                boolean excluded = this.matchesExclusion(signatureString, j);
                if (!excluded) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract void initPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract void initExcludedPatternRepresentation(String[] var1) throws IllegalArgumentException;

    protected abstract boolean matches(String var1, int var2);

    protected abstract boolean matchesExclusion(String var1, int var2);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractRegexpMethodPointcut)) {
            return false;
        }
        AbstractRegexpMethodPointcut otherPointcut = (AbstractRegexpMethodPointcut)other;
        return Arrays.equals(this.patterns, otherPointcut.patterns) && Arrays.equals(this.excludedPatterns, otherPointcut.excludedPatterns);
    }

    public int hashCode() {
        int i;
        int result2 = 27;
        for (i = 0; i < this.patterns.length; ++i) {
            String pattern = this.patterns[i];
            result2 = 13 * result2 + pattern.hashCode();
        }
        for (i = 0; i < this.excludedPatterns.length; ++i) {
            String excludedPattern = this.excludedPatterns[i];
            result2 = 13 * result2 + excludedPattern.hashCode();
        }
        return result2;
    }

    public String toString() {
        return this.getClass().getName() + ": patterns " + ObjectUtils.nullSafeToString(this.patterns) + ", excluded patterns " + ObjectUtils.nullSafeToString(this.excludedPatterns);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.initPatternRepresentation(this.patterns);
        this.initExcludedPatternRepresentation(this.excludedPatterns);
    }
}

