/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

public class BeanFactoryAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory {
    private final BeanFactory beanFactory;
    private final String name;
    private final AspectMetadata aspectMetadata;

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name2) {
        this(beanFactory, name2, beanFactory.getType(name2));
    }

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name2, Class type) {
        this.beanFactory = beanFactory;
        this.name = name2;
        this.aspectMetadata = new AspectMetadata(type, name2);
    }

    public Object getAspectInstance() {
        return this.beanFactory.getBean(this.name);
    }

    public ClassLoader getAspectClassLoader() {
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).getBeanClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    public AspectMetadata getAspectMetadata() {
        return this.aspectMetadata;
    }

    public int getOrder() {
        Class type = this.beanFactory.getType(this.name);
        if (type != null) {
            if (Ordered.class.isAssignableFrom(type) && this.beanFactory.isSingleton(this.name)) {
                return ((Ordered)this.beanFactory.getBean(this.name)).getOrder();
            }
            Order order = type.getAnnotation(Order.class);
            if (order != null) {
                return order.value();
            }
        }
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": bean name '" + this.name + "'";
    }
}

