/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class URLUploadServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest((HttpServletRequest)request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"repository");
        String url = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"url");
        String baseURI = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"baseURI");
        String dataFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"dataFormat", (String)RDFFormat.RDFXML.toString());
        String resultFormatStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        String verifyDataStr = HttpServerUtil.getParameter((HttpServletRequest)request, (String)"verifyData", (String)"off");
        this._handleRequest(request, response, repository, url, baseURI, dataFormatStr, resultFormatStr, verifyDataStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest((HttpServletRequest)request);
        String repository = HttpServerUtil.getParameter((Map)fileItemMap, (String)"repository");
        String url = HttpServerUtil.getParameter((Map)fileItemMap, (String)"url");
        String baseURI = HttpServerUtil.getParameter((Map)fileItemMap, (String)"baseURI");
        String dataFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"dataFormat", (String)RDFFormat.RDFXML.toString());
        String resultFormatStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"resultFormat", (String)AdminResultFormat.XML.toString());
        String verifyDataStr = HttpServerUtil.getParameter((Map)fileItemMap, (String)"verifyData", (String)"off");
        this._handleRequest(request, response, repository, url, baseURI, dataFormatStr, resultFormatStr, verifyDataStr);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String url, String baseURI, String dataFormatStr, String resultFormatStr, String verifyDataStr) throws IOException {
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log((String)">>> upload data");
        ThreadLog.trace((String)("repository = " + repository));
        ThreadLog.trace((String)("url = " + url));
        if (baseURI != null) {
            ThreadLog.trace((String)("baseURI = " + baseURI));
        }
        ThreadLog.trace((String)("dataFormat = " + dataFormatStr));
        ThreadLog.trace((String)("resultFormat = " + resultFormatStr));
        ThreadLog.trace((String)("verifyData = " + verifyDataStr));
        if (url == null) {
            this._sendBadRequest("URL is missing", response);
            return;
        }
        if (baseURI == null) {
            baseURI = url;
        }
        if (repository == null) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        RDFFormat dataFormat = RDFFormat.forValue(dataFormatStr);
        if (dataFormat != RDFFormat.RDFXML && dataFormat != RDFFormat.NTRIPLES && dataFormat != RDFFormat.TURTLE) {
            this._sendBadRequest("Unsupported data format: " + dataFormatStr, response);
            return;
        }
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setCacheableResult(false);
        AdminListener report = null;
        AdminResultFormat resultFormat = AdminResultFormat.forValue(resultFormatStr);
        if (resultFormat == AdminResultFormat.XML) {
            httpOut.setContentType("text/xml");
            report = new XmlAdminMsgWriter(httpOut);
        } else if (resultFormat == AdminResultFormat.HTML) {
            httpOut.setContentType("text/html");
            report = new HtmlAdminMsgWriter(httpOut);
        } else {
            this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
            return;
        }
        boolean verifyData = verifyDataStr.equals("on");
        InputStream rdfStream = null;
        try {
            URL u = new URL(url);
            rdfStream = u.openStream();
        }
        catch (MalformedURLException e) {
            this._sendBadRequest("Malformed URL '" + url + "': " + e.getMessage(), response);
            return;
        }
        catch (IOException e) {
            this._sendBadRequest("I/O error: " + e.getMessage(), response);
            return;
        }
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep2 = service.getRepository(repository);
            long startTime = System.currentTimeMillis();
            rep2.addData(rdfStream, baseURI, dataFormat, verifyData, report);
            rdfStream.close();
            long endTime = System.currentTimeMillis();
            ThreadLog.trace((String)("data added in " + (endTime - startTime) + "ms"));
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied", response);
        }
        catch (ConfigurationException e) {
            this._sendInternalError("Configuration error", e, response);
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
        }
        catch (RuntimeException e) {
            ThreadLog.error((String)("Unknown error on adding RDF data to repository " + repository), (Object)e);
        }
    }
}

