/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.rules;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.openrdf.sesame.sailimpl.rdbms.rules.Component;
import org.openrdf.sesame.sailimpl.rdbms.rules.Rule;
import org.openrdf.sesame.sailimpl.rdbms.rules.TripleTemplate;
import org.openrdf.util.xml.XMLReaderFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RuleParser
implements ContentHandler {
    private static final String TAG_AXIOM = "axiom";
    private static final String TAG_RULE = "rule";
    private static final String TAG_PREMISE = "premise";
    private static final String TAG_CONSEQUENT = "consequent";
    private static final String TAG_SUBJECT = "subject";
    private static final String TAG_PREDICATE = "predicate";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_TRIGGERS_RULE = "triggers_rule";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VAR = "var";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_PATTERN = "pattern";
    private static final String ATTR_ESCAPE = "escape";
    private ArrayList _rules = null;
    private ArrayList _axioms = null;
    private boolean _parsingTriggers;
    private boolean _parsingAxiom;
    private Locator _locator = null;
    private Component _subjectComp = null;
    private Component _predicateComp = null;
    private Component _objectComp = null;
    private Rule _rule = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String filename) throws IOException, SAXException {
        InputStream in = new FileInputStream(filename);
        in = new BufferedInputStream(in, 4096);
        try {
            this.parse(in);
        }
        finally {
            in.close();
        }
    }

    public void parse(InputStream in) throws IOException, SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        parser.setContentHandler(this);
        parser.parse(new InputSource(in));
    }

    public void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public void startDocument() throws SAXException {
        this._rules = new ArrayList(16);
        this._axioms = new ArrayList(32);
        this._parsingTriggers = false;
        this._parsingAxiom = false;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equals(TAG_AXIOM)) {
            this._parsingAxiom = true;
        } else if (localName.equals(TAG_RULE)) {
            String ruleName = atts.getValue(ATTR_NAME);
            if (this._parsingTriggers) {
                this._rule.triggersRule(ruleName);
            } else {
                this._rule = new Rule(ruleName);
            }
        } else if (localName.equals(TAG_TRIGGERS_RULE)) {
            if (this._rule == null) {
                this._throwSAXException("Triggers can only be defined with the context of a rule");
            }
            this._parsingTriggers = true;
            this._rule.initTriggersRuleCollection();
        } else if (localName.equals(TAG_SUBJECT)) {
            this._subjectComp = this._createComponent(atts, this._parsingAxiom);
        } else if (localName.equals(TAG_PREDICATE)) {
            this._predicateComp = this._createComponent(atts, this._parsingAxiom);
        } else if (localName.equals(TAG_OBJECT)) {
            this._objectComp = this._createComponent(atts, this._parsingAxiom);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals(TAG_AXIOM)) {
            if (this._subjectComp == null) {
                this._throwSAXException("Subject missing in axiom definition");
            }
            if (this._predicateComp == null) {
                this._throwSAXException("Predicate missing in axiom definition");
            }
            if (this._objectComp == null) {
                this._throwSAXException("Object missing in axiom definition");
            }
            Rule.getId(this._subjectComp);
            Rule.getId(this._predicateComp);
            Rule.getId(this._objectComp);
            this._axioms.add(new TripleTemplate(this._subjectComp, this._predicateComp, this._objectComp));
            this._parsingAxiom = false;
        } else if (!this._parsingTriggers && localName.equals(TAG_RULE)) {
            this._rules.add(this._rule);
            this._rule = null;
        } else if (localName.equals(TAG_TRIGGERS_RULE)) {
            if (!this._parsingTriggers) {
                this._throwSAXException("Unexpected </triggers_rule>");
            }
            this._parsingTriggers = false;
        } else if (localName.equals(TAG_PREMISE)) {
            if (this._subjectComp == null) {
                this._throwSAXException("Subject missing in premise definition");
            }
            if (this._predicateComp == null) {
                this._throwSAXException("Predicate missing in premise definition");
            }
            if (this._objectComp == null) {
                this._throwSAXException("Object missing in premise definition");
            }
            this._rule.addPremise(new TripleTemplate(this._subjectComp, this._predicateComp, this._objectComp));
        } else if (localName.equals(TAG_CONSEQUENT)) {
            if (this._subjectComp == null) {
                this._throwSAXException("Subject missing in consequent definition");
            }
            if (this._predicateComp == null) {
                this._throwSAXException("Predicate missing in consequent definition");
            }
            if (this._objectComp == null) {
                this._throwSAXException("Object missing in consequent definition");
            }
            if (this._rule.getConsequent() != null) {
                this._throwSAXException("A rule can only have one consequent");
            }
            this._rule.setConsequent(new TripleTemplate(this._subjectComp, this._predicateComp, this._objectComp));
        }
    }

    public void characters(char[] ch, int start2, int length) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri2) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start2, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data2) throws SAXException {
    }

    public void skippedEntity(String name2) throws SAXException {
    }

    private Component _createComponent(Attributes attr2, boolean forceUriOnly) throws SAXException {
        Component result2 = null;
        String attrUri = attr2.getValue(ATTR_URI);
        if (forceUriOnly) {
            if (attrUri == null) {
                this._throwSAXException("Missing 'uri' attribute");
            }
            result2 = new Component(attrUri, 2);
        } else if (attrUri != null) {
            result2 = new Component(attrUri, 2);
        } else {
            String var = attr2.getValue(ATTR_VAR);
            if (var == null) {
                this._throwSAXException("No 'uri' or 'var' attribute found");
            }
            result2 = new Component(var, 1);
            String pattern = attr2.getValue(ATTR_PATTERN);
            String escape2 = attr2.getValue(ATTR_ESCAPE);
            if (pattern != null) {
                result2.setRegExpTemplate(pattern, escape2);
            }
        }
        return result2;
    }

    private void _throwSAXException(String msg) throws SAXException {
        throw new SAXException("Parse error (line " + this._locator.getLineNumber() + ", column " + this._locator.getColumnNumber() + "): " + msg);
    }

    protected boolean matchTriples(TripleTemplate t1, TripleTemplate t2) {
        if (t1.predicate.isUri() && t2.predicate.isUri() && t1.predicate.value().equals(t2.predicate.value()) && t1.subject.isVar() && t1.object.isVar() && t1.subject.value().equals(t1.object.value()) && t2.subject.isVar() && t2.object.isVar() && !t2.subject.value().equals(t2.object.value())) {
            return false;
        }
        if (!(t1.subject.isVar() || t2.subject.isVar() || t1.subject.value().equalsIgnoreCase(t2.subject.value()))) {
            return false;
        }
        if (!(t1.predicate.isVar() || t2.predicate.isVar() || t1.predicate.value().equalsIgnoreCase(t2.predicate.value()))) {
            return false;
        }
        return t1.object.isVar() || t2.object.isVar() || t1.object.value().equalsIgnoreCase(t2.object.value());
    }

    protected boolean[][] buildTriggers(ArrayList theRules) {
        int num_rule_variants = 0;
        for (int i = 0; i < theRules.size(); ++i) {
            Rule r = (Rule)theRules.get(i);
            num_rule_variants += r.getPremiseCount();
        }
        boolean[][] result2 = new boolean[num_rule_variants][num_rule_variants];
        int rowIndex = 0;
        for (int i = 0; i < theRules.size(); ++i) {
            int colIndex = 0;
            Rule activator = (Rule)theRules.get(i);
            for (int j = 0; j < theRules.size(); ++j) {
                Rule activated = (Rule)theRules.get(j);
                String aName = activated.getName();
                boolean inTrigersList = false;
                if (activator.getTriggersRule() != null) {
                    Iterator trIter = activator.getTriggersRule().iterator();
                    while (trIter.hasNext()) {
                        String toCheck = (String)trIter.next();
                        if (!toCheck.equalsIgnoreCase(aName)) continue;
                        inTrigersList = true;
                        break;
                    }
                }
                if (inTrigersList) {
                    TripleTemplate consequent = activator.getConsequent();
                    for (int indexActivated = 0; indexActivated < activated.getPremiseCount(); ++indexActivated) {
                        TripleTemplate premiseToCheck = (TripleTemplate)activated.getPremiseCollection().get(indexActivated);
                        boolean valueToSet = this.matchTriples(consequent, premiseToCheck);
                        for (int activatorSize = 0; activatorSize < activator.getPremiseCount(); ++activatorSize) {
                            result2[rowIndex + activatorSize][colIndex + indexActivated] = valueToSet;
                        }
                    }
                }
                colIndex += activated.getPremiseCount();
            }
            rowIndex += activator.getPremiseCount();
        }
        return result2;
    }

    public ArrayList getRules() {
        return this._rules;
    }

    public ArrayList getAxioms() {
        return this._axioms;
    }
}

