/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openrdf.sesame.sailimpl.rdbms.CustomInferenceServices;
import org.openrdf.sesame.sailimpl.rdbms.TableNames;
import org.openrdf.sesame.sailimpl.rdbms.rules.Component;
import org.openrdf.sesame.sailimpl.rdbms.rules.TripleTemplate;

public class Rule
implements TableNames {
    static final String C_SELECT = "SELECT DISTINCT ";
    static HashMap idMap = new HashMap();
    ArrayList premiseList = new ArrayList();
    TripleTemplate consequent = null;
    String ruleName;
    ArrayList triggersRule = null;
    HashMap regExpByVars;
    private boolean matchwasbyobject = false;
    private String where = "";
    HashMap alreadyJoined;

    void normalizeRegExpVar(Component var) {
        if (var.isRegExp()) {
            if (this.regExpByVars == null) {
                this.regExpByVars = new HashMap();
            }
            this.regExpByVars.put(var.value(), var);
        }
    }

    static String getFROM() {
        return " FROM newtriples nt ";
    }

    static String getLEFT_JOIN(int id) {
        return "LEFT JOIN triples t" + id + " ON ";
    }

    public static Iterator constantsIter() {
        return idMap.keySet().iterator();
    }

    public static String getId(Component constant) {
        Integer val = (Integer)idMap.get(constant.value());
        if (val == null) {
            if (!constant.isVar()) {
                val = Rule.setId(constant, idMap.size());
            } else {
                return null;
            }
        }
        return val.toString();
    }

    public static int getIntId(Component constant) {
        Integer val = (Integer)idMap.get(constant.value());
        if (val == null) {
            if (!constant.isVar()) {
                val = Rule.setId(constant, idMap.size());
            } else {
                return -1;
            }
        }
        return val;
    }

    public static Integer setId(Component constant, int id) {
        if (!constant.isVar()) {
            return Rule.setId(constant.value(), id);
        }
        return new Integer(id);
    }

    public static Integer setId(String constant, int id) {
        Integer i = new Integer(id);
        idMap.put(constant, i);
        return i;
    }

    public Rule(String name2) {
        this.ruleName = name2;
    }

    public void addPremise(TripleTemplate t) {
        if (!t.subject.isVar()) {
            Rule.getId(t.subject);
        }
        if (!t.predicate.isVar()) {
            Rule.getId(t.predicate);
        }
        if (!t.object.isVar()) {
            Rule.getId(t.object);
        }
        this.normalizeRegExpVar(t.subject);
        this.normalizeRegExpVar(t.predicate);
        this.normalizeRegExpVar(t.object);
        this.premiseList.add(t);
    }

    public void setConsequent(TripleTemplate t) {
        if (!t.subject.isVar()) {
            Rule.getId(t.subject);
        }
        if (!t.predicate.isVar()) {
            Rule.getId(t.predicate);
        }
        if (!t.object.isVar()) {
            Rule.getId(t.object);
        }
        this.normalizeRegExpVar(t.subject);
        this.normalizeRegExpVar(t.predicate);
        this.normalizeRegExpVar(t.object);
        this.consequent = t;
    }

    String match(Component component, int until2) {
        this.matchwasbyobject = false;
        if (!component.isVar()) {
            return Rule.getId(component);
        }
        Iterator iter2 = this.premiseList.iterator();
        for (int count2 = 0; iter2.hasNext() && count2 < until2; ++count2) {
            TripleTemplate tt = (TripleTemplate)iter2.next();
            if (0 == component.compareTo(tt.subject)) {
                return "" + (count2 == 0 ? "nt" : "t" + count2) + ".subj";
            }
            if (0 == component.compareTo(tt.predicate)) {
                return "" + (count2 == 0 ? "nt" : "t" + count2) + ".pred";
            }
            if (0 != component.compareTo(tt.object)) continue;
            this.matchwasbyobject = true;
            return "" + (count2 == 0 ? "nt" : "t" + count2) + ".obj";
        }
        return null;
    }

    void processJoin(StringBuffer buffer, int id, TripleTemplate tt) {
        buffer.append(' ');
        buffer.append(Rule.getLEFT_JOIN(id));
        boolean bFirst = false;
        String s2 = this.match(tt.subject, id);
        if (s2 != null) {
            buffer.append("t" + id);
            buffer.append(".subj = ");
            buffer.append(s2);
            if (this.matchwasbyobject) {
                if (this.where.length() != 0) {
                    this.where = this.where + " AND ";
                }
                this.where = this.where + s2 + " > 0";
            }
            bFirst = true;
        }
        if ((s2 = this.match(tt.predicate, id)) != null) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append("t" + id);
            buffer.append(".pred= ");
            buffer.append(s2);
            bFirst = true;
        }
        if ((s2 = this.match(tt.object, id)) != null) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append("t" + id);
            buffer.append(".obj= ");
            buffer.append(s2);
        }
        this.processjoinWithRegExpr(buffer, tt.subject, "t" + id, "subj");
        this.processjoinWithRegExpr(buffer, tt.predicate, "t" + id, "pred");
        this.processjoinWithRegExpr(buffer, tt.object, "t" + id, "obj");
    }

    public ArrayList getAllSQLs() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(this.getSQL());
        if (this.premiseList.size() < 2) {
            return result2;
        }
        for (int i = 1; i < this.premiseList.size(); ++i) {
            Object f = this.premiseList.remove(0);
            this.premiseList.add(f);
            result2.add(this.getSQL());
        }
        Object f = this.premiseList.remove(0);
        this.premiseList.add(f);
        return result2;
    }

    String getSQL() {
        this.alreadyJoined = null;
        this.where = "";
        StringBuffer buffer = new StringBuffer();
        buffer.append(C_SELECT);
        buffer.append(this.match(this.consequent.subject, this.premiseList.size()));
        buffer.append(',');
        buffer.append(this.match(this.consequent.predicate, this.premiseList.size()));
        buffer.append(',');
        buffer.append(this.match(this.consequent.object, this.premiseList.size()));
        buffer.append('\n');
        buffer.append(Rule.getFROM());
        buffer.append('\n');
        for (int i = 1; i < this.premiseList.size(); ++i) {
            TripleTemplate tt = (TripleTemplate)this.premiseList.get(i);
            this.processJoin(buffer, i, tt);
        }
        this.processJoin(buffer, this.premiseList.size(), this.consequent);
        TripleTemplate ttFirst = (TripleTemplate)this.premiseList.get(0);
        buffer.append(" WHERE ");
        boolean ifFirst = false;
        if (this.where.length() > 0) {
            buffer.append(this.where);
            ifFirst = true;
        }
        if (!ttFirst.subject.isVar()) {
            if (ifFirst) {
                buffer.append(" AND ");
            }
            buffer.append("nt.subj= ");
            buffer.append(Rule.getId(ttFirst.subject));
            ifFirst = true;
        }
        if (!ttFirst.predicate.isVar()) {
            if (ifFirst) {
                buffer.append(" AND ");
            }
            buffer.append("nt.pred = ");
            buffer.append(Rule.getId(ttFirst.predicate));
            ifFirst = true;
        }
        if (!ttFirst.object.isVar()) {
            if (ifFirst) {
                buffer.append(" AND ");
            }
            buffer.append("nt.obj = ");
            buffer.append(Rule.getId(ttFirst.object));
            ifFirst = true;
        }
        for (int i = 1; i < this.premiseList.size(); ++i) {
            if (ifFirst) {
                buffer.append(" AND ");
            }
            buffer.append("t" + i + ".subj is not NULL");
            ifFirst = true;
        }
        if (ifFirst) {
            buffer.append(" AND ");
        }
        buffer.append("t" + this.premiseList.size() + ".subj is NULL");
        return buffer.toString();
    }

    private boolean appendConstaints(StringBuffer buffer, TripleTemplate t, boolean bFirst, String tablePrefix) {
        if (!t.subject.isVar()) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append(tablePrefix);
            buffer.append(".subj = ");
            buffer.append(Rule.getId(t.subject));
            bFirst = true;
        }
        if (!t.predicate.isVar()) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append(tablePrefix);
            buffer.append(".pred = ");
            buffer.append(Rule.getId(t.predicate));
            bFirst = true;
        }
        if (!t.object.isVar()) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append(tablePrefix);
            buffer.append(".obj = ");
            buffer.append(Rule.getId(t.object));
            bFirst = true;
        }
        return bFirst;
    }

    private String matchVarComponent(Component var, TripleTemplate t) {
        if (var.compareTo(t.subject) == 0) {
            return ".subj";
        }
        if (var.compareTo(t.predicate) == 0) {
            return ".pred";
        }
        if (var.compareTo(t.object) == 0) {
            return ".obj";
        }
        return null;
    }

    private boolean matchAgainst(StringBuffer buffer, boolean bFirst, TripleTemplate from2, String fromPrefix, TripleTemplate to2, String toPrefix) {
        if (bFirst) {
            buffer.append(" AND ");
        }
        buffer.append(fromPrefix);
        buffer.append(".id <> ");
        buffer.append(toPrefix);
        buffer.append(".id ");
        bFirst = true;
        String foundMatch = null;
        foundMatch = this.matchVarComponent(from2.subject, to2);
        if (foundMatch != null) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append(fromPrefix);
            buffer.append(".subj = ");
            buffer.append(toPrefix);
            buffer.append(foundMatch);
            foundMatch = null;
            bFirst = true;
        }
        if ((foundMatch = this.matchVarComponent(from2.predicate, to2)) != null) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append(fromPrefix);
            buffer.append(".pred = ");
            buffer.append(toPrefix);
            buffer.append(foundMatch);
            foundMatch = null;
            bFirst = true;
        }
        if ((foundMatch = this.matchVarComponent(from2.object, to2)) != null) {
            if (bFirst) {
                buffer.append(" AND ");
            }
            buffer.append(fromPrefix);
            buffer.append(".obj = ");
            buffer.append(toPrefix);
            buffer.append(foundMatch);
            foundMatch = null;
            bFirst = true;
        }
        return bFirst;
    }

    public ArrayList getDependSQL() {
        this.alreadyJoined = null;
        StringBuffer bufferPrefix = new StringBuffer();
        bufferPrefix.append("insert into ");
        bufferPrefix.append("depend");
        bufferPrefix.append("\n\r SELECT t.id ");
        for (int i = 1; i <= CustomInferenceServices.getMaxTemplateCountsPerRule(); ++i) {
            if (i <= this.premiseList.size()) {
                bufferPrefix.append(", dep" + i + ".id ");
                continue;
            }
            bufferPrefix.append(", 0");
        }
        bufferPrefix.append(" FROM ");
        StringBuffer bufferMidSuffix = new StringBuffer();
        StringBuffer bufferSuffix = new StringBuffer();
        bufferSuffix.append(" WHERE ");
        boolean bFirst = false;
        bFirst = this.appendConstaints(bufferSuffix, this.consequent, bFirst, "t");
        for (int i = 0; i < this.premiseList.size(); ++i) {
            TripleTemplate tr = (TripleTemplate)this.premiseList.get(i);
            bFirst = this.appendConstaints(bufferSuffix, tr, bFirst, "dep" + (i + 1));
            bFirst = this.matchAgainst(bufferSuffix, bFirst, this.consequent, "t", tr, "dep" + (i + 1));
            for (int j = 0; j < i; ++j) {
                bFirst = this.matchAgainst(bufferSuffix, bFirst, tr, "dep" + (i + 1), (TripleTemplate)this.premiseList.get(j), "dep" + (j + 1));
            }
            this.processjoinWithRegExpr(bufferMidSuffix, tr.subject, "dep" + (i + 1), "subj");
            this.processjoinWithRegExpr(bufferMidSuffix, tr.predicate, "dep" + (i + 1), "pred");
            this.processjoinWithRegExpr(bufferMidSuffix, tr.object, "dep" + (i + 1), "obj");
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < this.premiseList.size(); ++i) {
            String middle = "";
            for (int j = 0; j < this.premiseList.size(); ++j) {
                middle = i == j ? middle + "allnewtriples dep" + (j + 1) + "," : middle + "triples dep" + (j + 1) + ",";
            }
            middle = middle + "triples t ";
            ret.add(bufferPrefix.toString() + middle + bufferMidSuffix + bufferSuffix.toString());
        }
        return ret;
    }

    public void initTriggersRuleCollection() {
        this.triggersRule = new ArrayList();
    }

    public void triggersRule(String ruleRef) {
        this.triggersRule.add(ruleRef);
    }

    public boolean hasTriggersRuleCollection() {
        return this.triggersRule != null;
    }

    public String getName() {
        return this.ruleName;
    }

    protected String escapeRegExpression(String expression, String esc) {
        if (esc == null) {
            esc = "\\";
        }
        if (0 == esc.compareTo("\\")) {
            esc = esc + esc;
        }
        expression = expression.replaceAll("[',_,%," + esc + "]", esc + "$0");
        expression = expression.replaceAll("([^" + esc + "])([?])", "$1_");
        return expression.replaceAll("([^" + esc + "])([\\*])", "$1%");
    }

    protected void processjoinWithRegExpr(StringBuffer buffer, Component component, String tableID, String sub_ob_pred) {
        if (this.regExpByVars == null) {
            return;
        }
        if (this.alreadyJoined == null) {
            this.alreadyJoined = new HashMap();
        }
        if ((component = (Component)this.regExpByVars.get(component.value())) == null) {
            return;
        }
        if (component.isRegExp() && null == this.alreadyJoined.get(component)) {
            String varName = component.value();
            Component regExpr = (Component)this.regExpByVars.get(varName);
            if (regExpr != null) {
                buffer.append(" inner join ");
                buffer.append("resources");
                buffer.append(" r" + varName);
                buffer.append(" on r" + varName);
                buffer.append(".id = " + tableID);
                buffer.append("." + sub_ob_pred);
                buffer.append(" inner join ");
                buffer.append("namespaces");
                buffer.append(" n" + varName);
                buffer.append(" on r" + varName);
                buffer.append(".namespace = n" + varName + ".id AND ");
                buffer.append("concat( n" + varName + ".name, ");
                buffer.append(" r" + varName + ".localname ) LIKE '");
                String esc = regExpr.getRegExpEsc();
                if (esc == null) {
                    esc = "\\";
                }
                String likeText = this.escapeRegExpression(regExpr.getRegExpTemplate(), esc);
                buffer.append(likeText);
                buffer.append("' ESCAPE '" + esc + esc + "' ");
            }
            this.alreadyJoined.put(component, "");
        }
    }

    public int getPremiseCount() {
        return this.premiseList.size();
    }

    public TripleTemplate getConsequent() {
        return this.consequent;
    }

    public ArrayList getPremiseCollection() {
        return this.premiseList;
    }

    public ArrayList getTriggersRule() {
        return this.triggersRule;
    }

    public static void main(String[] op) {
        Rule rule = new Rule("test");
        Component subjectComp = new Component("xxx", 1);
        Component predicateComp = new Component("id", 3);
        predicateComp.setRegExpTemplate("http://www.w3.org/1999/02/22-rdf-syntax-ns#_*", "\\");
        Component objectComp = new Component("yyy", 1);
        TripleTemplate t = new TripleTemplate(subjectComp, predicateComp, objectComp);
        rule.addPremise(t);
        subjectComp = new Component("id", 1);
        predicateComp = new Component("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", 2);
        objectComp = new Component("http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty", 2);
        t = new TripleTemplate(subjectComp, predicateComp, objectComp);
        rule.setConsequent(t);
        ArrayList list2 = rule.getAllSQLs();
        Iterator iter2 = list2.iterator();
        while (iter2.hasNext()) {
            System.out.println(iter2.next());
        }
    }
}

