/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.And;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.ConstructQuery;
import org.openrdf.sesame.sail.query.GraphPattern;
import org.openrdf.sesame.sail.query.GraphPatternQuery;
import org.openrdf.sesame.sail.query.Like;
import org.openrdf.sesame.sail.query.LiteralExpr;
import org.openrdf.sesame.sail.query.Not;
import org.openrdf.sesame.sail.query.Null;
import org.openrdf.sesame.sail.query.Or;
import org.openrdf.sesame.sail.query.PathExpression;
import org.openrdf.sesame.sail.query.ProjectionElem;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryOptimizer;
import org.openrdf.sesame.sail.query.ResourceExpr;
import org.openrdf.sesame.sail.query.SelectQuery;
import org.openrdf.sesame.sail.query.SetOperator;
import org.openrdf.sesame.sail.query.StringExpr;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.ValueCompare;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdbmsNamespace;
import org.openrdf.sesame.sailimpl.rdbms.RdbmsPathExpression;
import org.openrdf.sesame.sailimpl.rdbms.TableNames;
import org.openrdf.sesame.sailimpl.rdbms.iterators.RdbmsNamespaceIterator;
import org.openrdf.sesame.sailimpl.rdbms.iterators.RdbmsStatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.model.IdBNode;
import org.openrdf.sesame.sailimpl.rdbms.model.IdLiteral;
import org.openrdf.sesame.sailimpl.rdbms.model.IdResource;
import org.openrdf.sesame.sailimpl.rdbms.model.IdURI;
import org.openrdf.sesame.sailimpl.rdbms.model.IdValue;
import org.openrdf.util.log.ThreadLog;

public class RdfSource
implements org.openrdf.sesame.sail.RdfSource,
TableNames,
ValueFactory {
    public static final String KEY_SCHEMAVERSION = "schemaversion";
    public static final String KEY_SCHEMACREATOR = "schemacreator";
    public static final String KEY_EXPORT_FLAGS = "exportflags";
    public static final String VALUE_UP_TO_DATE = "up-to-date";
    public static final String VALUE_DIRTY = "dirty";
    public static final String JDBC_DRIVER_KEY = "jdbcDriver";
    public static final String JDBC_URL_KEY = "jdbcUrl";
    public static final String USER_KEY = "user";
    public static final String PASSWORD_KEY = "password";
    protected int CURRENT_SCHEMA_VERSION = 6;
    protected String SCHEMA_CREATOR = "org.openrdf.sesame.sailimpl.rdbms.RdfSource";
    protected String NN_ON_TEXT;
    protected int _schemaVersion;
    protected RDBMS _rdbms;
    protected MessageDigest _md5Digest;
    private String _bnodePrefix;
    private int _nextBNodeID;
    protected int _nextNamespaceId;
    protected Map _namespaceTable;
    protected List _namespaceList;
    protected String[] _namespaceNames;
    private boolean _exportStatusUpToDate;

    public RdfSource() {
        this._updateBNodePrefix();
        this._nextNamespaceId = 1;
        this._namespaceTable = new HashMap();
        this._namespaceList = new ArrayList();
        try {
            this._md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 digest algorithm not available on this platform", e);
        }
    }

    protected void _updateBNodePrefix() {
        this._bnodePrefix = "node" + Long.toString(System.currentTimeMillis(), 32) + "x";
        this._nextBNodeID = 1;
    }

    public void initialize(String jdbcDriver, String jdbcUrl) throws SailInitializationException {
        HashMap<String, String> configParams = new HashMap<String, String>(2);
        configParams.put(JDBC_DRIVER_KEY, jdbcDriver);
        configParams.put(JDBC_URL_KEY, jdbcUrl);
        this.initialize(configParams);
    }

    public void initialize(String jdbcDriver, String jdbcUrl, String user, String password) throws SailInitializationException {
        HashMap<String, String> configParams = new HashMap<String, String>(4);
        configParams.put(JDBC_DRIVER_KEY, jdbcDriver);
        configParams.put(JDBC_URL_KEY, jdbcUrl);
        configParams.put(USER_KEY, user);
        configParams.put(PASSWORD_KEY, password);
        this.initialize(configParams);
    }

    public void initialize(Map configParams) throws SailInitializationException {
        String jdbcDriver = (String)configParams.get(JDBC_DRIVER_KEY);
        String jdbcUrl = (String)configParams.get(JDBC_URL_KEY);
        String user = (String)configParams.get(USER_KEY);
        String password = (String)configParams.get(PASSWORD_KEY);
        if (jdbcDriver == null) {
            throw new SailInitializationException("parameter 'jdbcDriver' missing");
        }
        if (jdbcUrl == null) {
            throw new SailInitializationException("parameter 'jdbcUrl' missing");
        }
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException e) {
            throw new SailInitializationException("Unable to load JDBC-driver '" + jdbcDriver + "'", e);
        }
        try {
            this._rdbms = RDBMS.createInstance(jdbcUrl, user, password);
            this.NN_ON_TEXT = this._rdbms.emptyStringIsNull() ? "" : " NOT NULL";
        }
        catch (SQLException e) {
            throw new SailInitializationException(e);
        }
        this._initDatabase();
    }

    public void shutDown() {
        this._rdbms.disconnect();
    }

    protected void _initDatabase() throws SailInitializationException {
        try {
            this._schemaVersion = this._checkDbSchema();
            if (this._schemaVersion > this.CURRENT_SCHEMA_VERSION) {
                throw new SailInitializationException("The database schema was created by a newer version of this Sail!");
            }
            if (this._schemaVersion < this.CURRENT_SCHEMA_VERSION) {
                if (this._schemaVersion == -1) {
                    ThreadLog.trace((String)"No DB schema yet, creating it...");
                } else if (this._schemaVersion < this.CURRENT_SCHEMA_VERSION) {
                    ThreadLog.trace((String)"Old DB schema, updating it...");
                }
                this._createDbSchema();
                this._schemaVersion = this.CURRENT_SCHEMA_VERSION;
                this._exportStatusUpToDate = true;
            } else {
                this._exportStatusUpToDate = !VALUE_DIRTY.equals(this._getRepInfo(KEY_EXPORT_FLAGS));
                ThreadLog.trace((String)"DB schema is up to date");
            }
            this._initNamespaceCache();
        }
        catch (SQLException e) {
            throw new SailInitializationException(e);
        }
    }

    protected int _checkDbSchema() throws SQLException, SailInitializationException {
        int result2;
        ThreadLog.trace((String)"Checking DB schema...");
        if (this._rdbms.tableExists("repinfo")) {
            String creator = this._getRepInfo(KEY_SCHEMACREATOR);
            String version = this._getRepInfo(KEY_SCHEMAVERSION);
            if (!this.SCHEMA_CREATOR.equals(creator)) {
                if (!creator.startsWith("nl.aidministrator.rdf.sail.rdbms.")) {
                    throw new SailInitializationException("Database schema was not created by this Sail");
                }
                this._setRepInfo(KEY_SCHEMACREATOR, this.SCHEMA_CREATOR);
            }
            try {
                result2 = Integer.parseInt(version);
            }
            catch (NumberFormatException nfe) {
                throw new SailInitializationException("schema version is not an integer");
            }
        } else {
            result2 = -1;
        }
        return result2;
    }

    protected void _createDbSchema() throws SQLException {
        this._createRepInfoTable();
        this._createNamespacesTable();
        this._createResourcesTable();
        this._createLiteralsTable();
        this._createTriplesTable();
    }

    protected void _createRepInfoTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._rdbms.executeUpdate("CREATE TABLE repinfo (infokey " + this._rdbms.INFOFIELD + " NOT NULL PRIMARY KEY," + " infovalue " + this._rdbms.INFOFIELD + " NOT NULL)");
            this._setRepInfo(KEY_SCHEMAVERSION, String.valueOf(this.CURRENT_SCHEMA_VERSION));
            this._setRepInfo(KEY_SCHEMACREATOR, this.SCHEMA_CREATOR);
        } else if (this._schemaVersion < this.CURRENT_SCHEMA_VERSION) {
            this._setRepInfo(KEY_SCHEMAVERSION, String.valueOf(this.CURRENT_SCHEMA_VERSION));
        }
    }

    protected void _createNamespacesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._rdbms.executeUpdate("CREATE TABLE namespaces (id " + this._rdbms.ID_INT + " NOT NULL PRIMARY KEY," + " prefix " + this._rdbms.PREFIX + this.NN_ON_TEXT + "," + " name " + this._rdbms.NAME + "," + " userDefined " + this._rdbms.BOOLEAN + " NOT NULL," + " export " + this._rdbms.BOOLEAN + " NOT NULL," + " UNIQUE(prefix))");
            this._rdbms.executeUpdate("INSERT INTO namespaces VALUES(0, '', NULL, " + this._rdbms.FALSE + ", " + this._rdbms.FALSE + ")");
        }
    }

    protected void _createResourcesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._rdbms.executeUpdate("CREATE TABLE resources (id " + this._rdbms.ID_INT + " NOT NULL PRIMARY KEY," + " namespace " + this._rdbms.ID_INT + " NOT NULL, " + " localname " + this._rdbms.LOCALNAME + this.NN_ON_TEXT + "," + " UNIQUE(namespace, localname))");
            this._rdbms.executeUpdate("INSERT INTO resources VALUES(0, 0, '')");
        }
    }

    protected void _createLiteralsTable() throws SQLException {
        if (this._schemaVersion < 2) {
            String OLD_LITERALS_TABLE = "oldliterals";
            if (this._schemaVersion != -1) {
                this._rdbms.dropIndex("literals", "labelKey");
                this._rdbms.renameTable("literals", OLD_LITERALS_TABLE);
            }
            this._rdbms.executeUpdate("CREATE TABLE literals (id " + this._rdbms.ID_INT + " NOT NULL PRIMARY KEY," + " datatype " + this._rdbms.ID_INT + " NOT NULL," + " labelHash " + this._rdbms.LABEL_HASH + " NOT NULL," + " language " + this._rdbms.LANGUAGE + "," + " label " + this._rdbms.LABEL + this.NN_ON_TEXT + ")");
            this._rdbms.createIndex("literals", "labelHash");
            if (this._schemaVersion != -1) {
                Connection addLiteralCon = this._rdbms.getConnection();
                addLiteralCon.setAutoCommit(false);
                PreparedStatement addLiteralSt = addLiteralCon.prepareStatement("INSERT INTO literals VALUES(?, ?, ?, ?, ?)");
                Connection con = this._rdbms.getConnection();
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("SELECT id, datatype, language, label FROM " + OLD_LITERALS_TABLE);
                int count2 = 0;
                while (rs.next()) {
                    addLiteralSt.setInt(1, rs.getInt(1));
                    addLiteralSt.setInt(2, rs.getInt(2));
                    String lang = rs.getString(3);
                    String label = rs.getString(4);
                    if (label == null) {
                        label = "";
                    }
                    addLiteralSt.setLong(3, this._getLabelHash(label));
                    if (lang != null) {
                        addLiteralSt.setString(4, lang);
                    } else {
                        addLiteralSt.setNull(4, this._rdbms.LANGUAGE_TYPE);
                    }
                    addLiteralSt.setString(5, label);
                    addLiteralSt.executeUpdate();
                    ++count2;
                }
                rs.close();
                st.close();
                con.close();
                addLiteralCon.commit();
                addLiteralSt.close();
                addLiteralCon.close();
                this._rdbms.optimizeTable("literals", count2);
                this._rdbms.dropTable(OLD_LITERALS_TABLE);
            }
        }
    }

    protected void _createTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._createTriplesTable("triples", true);
            this._rdbms.createIndex("triples", new String[]{"pred", "obj"}, false);
            this._rdbms.createIndex("triples", new String[]{"obj", "subj"}, false);
            this._rdbms.createUniqueIndex("triples", "id");
        } else {
            if (this._schemaVersion < 4) {
                this._rdbms.renameTableColumn("triples", "subject", "subj", this._rdbms.ID_INT + " NOT NULL");
                this._rdbms.renameTableColumn("triples", "predicate", "pred", this._rdbms.ID_INT + " NOT NULL");
                this._rdbms.renameTableColumn("triples", "object", "obj", this._rdbms.ID_INT + " NOT NULL");
            }
            if (this._schemaVersion < 6) {
                this._rdbms.dropIndex("triples", "subj");
                this._rdbms.dropIndex("triples", "pred");
                this._rdbms.dropIndex("triples", "obj");
                this._rdbms.dropIndex("triples", new String[]{"subj", "pred"});
                this._rdbms.dropIndex("triples", new String[]{"subj", "obj"});
                this._rdbms.createIndex("triples", new String[]{"obj", "subj"}, false);
                this._rdbms.createUniqueIndex("triples", "id");
            }
        }
    }

    protected void _createTriplesTable(String tableName, boolean uniqueRows) throws SQLException {
        StringBuffer update2 = new StringBuffer(200);
        update2.append("CREATE TABLE " + tableName + " ");
        update2.append("(id " + this._rdbms.ID_INT + " NOT NULL,");
        update2.append(" subj " + this._rdbms.ID_INT + " NOT NULL,");
        update2.append(" pred " + this._rdbms.ID_INT + " NOT NULL,");
        update2.append(" obj " + this._rdbms.ID_INT + " NOT NULL,");
        update2.append(" explicit " + this._rdbms.BOOLEAN + " NOT NULL");
        if (uniqueRows) {
            update2.append(", UNIQUE(subj, pred, obj)");
        }
        update2.append(")");
        this._rdbms.executeUpdate(update2.toString());
    }

    protected void _setRepInfo(String key, String value2) throws SQLException {
        this._rdbms.executeUpdate("DELETE FROM repinfo WHERE infokey = '" + this._rdbms.escapeString(key) + "'");
        this._rdbms.executeUpdate("INSERT INTO repinfo VALUES ('" + this._rdbms.escapeString(key) + "', '" + this._rdbms.escapeString(value2) + "')");
    }

    protected String _getRepInfo(String key) throws SQLException {
        String result2 = null;
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT infovalue FROM repinfo WHERE infokey = '" + this._rdbms.escapeString(key) + "'");
        if (rs.next()) {
            result2 = rs.getString(1);
        }
        rs.close();
        st.close();
        con.close();
        return result2;
    }

    protected void _setExportStatusUpToDate(boolean upToDate) throws SQLException {
        if (this._exportStatusUpToDate != upToDate) {
            this._exportStatusUpToDate = upToDate;
            if (upToDate) {
                this._setRepInfo(KEY_EXPORT_FLAGS, VALUE_UP_TO_DATE);
            } else {
                this._setRepInfo(KEY_EXPORT_FLAGS, VALUE_DIRTY);
            }
        }
    }

    protected boolean _exportStatusUpToDate() {
        return this._exportStatusUpToDate;
    }

    protected void _initNamespaceCache() throws SQLException {
        this._namespaceTable.clear();
        this._namespaceList.clear();
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT id, prefix, name, export FROM namespaces WHERE id <> 0");
        int maxId = 0;
        while (rs.next()) {
            int id = rs.getInt(1);
            String prefix = rs.getString(2);
            String name2 = rs.getString(3);
            boolean export = rs.getBoolean(4);
            if (prefix == null) {
                prefix = "";
            }
            RdbmsNamespace ns = new RdbmsNamespace(id, prefix, name2, export);
            this._namespaceTable.put(name2, ns);
            this._namespaceList.add(ns);
            if (id <= maxId) continue;
            maxId = id;
        }
        rs.close();
        st.close();
        con.close();
        this._nextNamespaceId = maxId + 1;
        this._namespaceNames = new String[maxId + 1];
        for (int i = 0; i < this._namespaceList.size(); ++i) {
            RdbmsNamespace ns = (RdbmsNamespace)this._namespaceList.get(i);
            this._namespaceNames[ns.getId()] = ns.getName();
        }
    }

    protected int _getNextNamespaceId() {
        return this._nextNamespaceId++;
    }

    public ValueFactory getValueFactory() {
        return this;
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj) {
        return this.getStatements(subj, pred, obj, false);
    }

    public StatementIterator getStatements(Resource subj, URI pred, Value obj, boolean explicitOnly) {
        int subjId = 0;
        int predId = 0;
        int objId = 0;
        if (subj != null && (subjId = this._getResourceId(subj)) == 0) {
            return new EmptyStatementIterator();
        }
        if (pred != null && (predId = this._getURIId(pred)) == 0) {
            return new EmptyStatementIterator();
        }
        if (obj != null && (objId = this._getValueId(obj)) == 0) {
            return new EmptyStatementIterator();
        }
        String queryResources = null;
        String queryLiterals = null;
        if (obj instanceof Resource) {
            queryResources = this._buildGetStatementsQuery(subjId, predId, objId, true, explicitOnly);
        } else if (obj instanceof Literal) {
            queryLiterals = this._buildGetStatementsQuery(subjId, predId, objId, false, explicitOnly);
        } else {
            queryResources = this._buildGetStatementsQuery(subjId, predId, objId, true, explicitOnly);
            queryLiterals = this._buildGetStatementsQuery(subjId, predId, objId, false, explicitOnly);
        }
        try {
            Connection con = this._rdbms.getConnection();
            return new RdbmsStatementIterator(this, this._namespaceNames, con, queryResources, queryLiterals, subj, pred, obj);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected String _buildGetStatementsQuery(int subjId, int predId, int objId, boolean queryResources, boolean explicitOnly) {
        StringBuffer select = new StringBuffer(100);
        StringBuffer from2 = new StringBuffer(200);
        StringBuffer where = new StringBuffer(200);
        boolean writeCommas = false;
        if (subjId != 0) {
            where.append("t.subj = " + subjId + " AND ");
        } else {
            select.append("r1.id, r1.namespace, r1.localname");
            from2.append("resources r1");
            where.append("t.subj = r1.id AND ");
            writeCommas = true;
        }
        if (predId != 0) {
            where.append("t.pred = " + predId + " AND ");
        } else {
            if (writeCommas) {
                select.append(", ");
                from2.append(", ");
            }
            select.append("r2.id, r2.namespace, r2.localname");
            from2.append("resources r2");
            where.append("t.pred = r2.id AND ");
            writeCommas = true;
        }
        if (objId != 0) {
            where.append("t.obj = " + objId);
        } else {
            if (writeCommas) {
                select.append(", ");
                from2.append(", ");
            }
            if (queryResources) {
                select.append("r3.id, r3.namespace, r3.localname");
                from2.append("resources r3");
                where.append("t.obj > 0 AND t.obj = r3.id");
            } else {
                select.append("l.id, dt.id, dt.namespace, dt.localname, l.language, l.label");
                from2.append("literals l, resources dt");
                where.append("t.obj < 0 AND t.obj = l.id AND l.datatype = dt.id");
            }
        }
        StringBuffer query2 = new StringBuffer(400);
        query2.append("SELECT ");
        if (select.length() == 0) {
            query2.append("t.id");
        } else {
            query2.append(select.toString());
        }
        query2.append(" FROM triples t");
        if (from2.length() > 0) {
            query2.append(", " + from2.toString());
        }
        query2.append(" WHERE " + where.toString());
        if (explicitOnly) {
            query2.append(" AND t.explicit = " + this._rdbms.TRUE);
        }
        return query2.toString();
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj) {
        return this.hasStatement(subj, pred, obj, false);
    }

    public Query optimizeQuery(Query query2) {
        if (query2 instanceof GraphPatternQuery) {
            this._optimizeGraphPatternQuery((GraphPatternQuery)query2);
        } else if (query2 instanceof SetOperator) {
            SetOperator setOp = (SetOperator)query2;
            this.optimizeQuery(setOp.getLeftArg());
            this.optimizeQuery(setOp.getRightArg());
        }
        return query2;
    }

    private void _optimizeGraphPatternQuery(GraphPatternQuery graphPatternQuery) {
        int i;
        GraphPattern graphPattern = graphPatternQuery.getGraphPattern();
        List pathExpressions = graphPattern.getPathExpressions();
        if (pathExpressions.size() == 0 || pathExpressions.size() == 1 && graphPattern.getConjunctiveConstraints().isEmpty()) {
            QueryOptimizer.optimizeQuery(graphPatternQuery);
            return;
        }
        StringBuffer from2 = new StringBuffer(512);
        StringBuffer where = new StringBuffer(256);
        HashMap varToSqlIdMapping = new HashMap();
        ArrayList<PathExpression> unknownPathExpressions = new ArrayList<PathExpression>();
        for (int i2 = 0; i2 < pathExpressions.size(); ++i2) {
            PathExpression pe = (PathExpression)pathExpressions.get(i2);
            String peId = "t" + i2;
            if ((pe = this._convertPathExpressionToSQL(pe, peId, from2, where, varToSqlIdMapping)) == null) continue;
            unknownPathExpressions.add(pe);
        }
        if (pathExpressions.size() - unknownPathExpressions.size() <= 1 && graphPattern.getConjunctiveConstraints().isEmpty()) {
            QueryOptimizer.optimizeQuery(graphPatternQuery);
            return;
        }
        this._inlineConstraints(graphPattern, from2, where, varToSqlIdMapping);
        HashSet varSet = new HashSet();
        graphPatternQuery.getProjectionVariables(varSet);
        BooleanExpr rootConstraint = graphPattern.getRootConstraint();
        if (rootConstraint != null) {
            rootConstraint.getVariables(varSet);
        }
        List optionals = graphPattern.getOptionals();
        for (i = 0; i < optionals.size(); ++i) {
            GraphPattern optionalGP = (GraphPattern)optionals.get(i);
            optionalGP.getVariables(varSet);
        }
        for (i = 0; i < unknownPathExpressions.size(); ++i) {
            PathExpression pe = (PathExpression)unknownPathExpressions.get(i);
            pe.getVariables(varSet);
        }
        varSet.retainAll(varToSqlIdMapping.keySet());
        ArrayList varList = new ArrayList(varSet);
        StringBuffer sqlQuery = new StringBuffer(1024);
        sqlQuery.append("SELECT ");
        if (graphPatternQuery.isDistinct()) {
            sqlQuery.append("DISTINCT ");
            HashSet projVarSet = new HashSet();
            graphPatternQuery.getProjectionVariables(projVarSet);
            if (((Object)varSet).equals(projVarSet) && optionals.size() == 0) {
                boolean hasTransFunc = false;
                if (graphPatternQuery instanceof SelectQuery) {
                    ProjectionElem[] projection = ((SelectQuery)graphPatternQuery).getProjection();
                    for (int i3 = 0; i3 < projection.length; ++i3) {
                        ValueExpr valueExpr = projection[i3].getValueExpr();
                        if (valueExpr instanceof Var || valueExpr instanceof ResourceExpr || valueExpr instanceof LiteralExpr || valueExpr instanceof Null) continue;
                        hasTransFunc = true;
                        break;
                    }
                } else if (graphPatternQuery instanceof ConstructQuery) {
                    // empty if block
                }
                if (!hasTransFunc) {
                    graphPatternQuery.setDistinct(false);
                }
            }
        }
        for (int i4 = 0; i4 < varList.size(); ++i4) {
            Var var = (Var)varList.get(i4);
            if (i4 > 0) {
                sqlQuery.append(", ");
            }
            sqlQuery.append((String)varToSqlIdMapping.get(var));
        }
        from2.delete(0, 2);
        sqlQuery.append(" FROM ");
        sqlQuery.append(from2);
        if (where.length() > 0) {
            where.delete(0, 5);
            sqlQuery.append(" WHERE ");
            sqlQuery.append(where);
        }
        ThreadLog.trace((String)sqlQuery.toString());
        RdbmsPathExpression rpe = new RdbmsPathExpression(this, this._rdbms, varList, sqlQuery.toString());
        ArrayList<PathExpression> newPathExpressions = new ArrayList<PathExpression>(1 + unknownPathExpressions.size());
        newPathExpressions.add(rpe);
        newPathExpressions.addAll(unknownPathExpressions);
        graphPattern.setPathExpressions(newPathExpressions);
    }

    protected PathExpression _convertPathExpressionToSQL(PathExpression pathExpr, String peId, StringBuffer from2, StringBuffer where, Map varToSqlIdMapping) {
        if (pathExpr instanceof TriplePattern) {
            TriplePattern tp = (TriplePattern)pathExpr;
            from2.append(", triples " + peId);
            this._processPathExpressionVar(tp.getSubjectVar(), peId + ".subj", where, varToSqlIdMapping);
            this._processPathExpressionVar(tp.getPredicateVar(), peId + ".pred", where, varToSqlIdMapping);
            this._processPathExpressionVar(tp.getObjectVar(), peId + ".obj", where, varToSqlIdMapping);
            return null;
        }
        return pathExpr;
    }

    protected void _processPathExpressionVar(Var var, String sqlId, StringBuffer where, Map varToSqlIdMapping) {
        if (var.hasValue()) {
            int valueId = this._getValueId(var.getValue());
            where.append(" AND " + sqlId + " = " + valueId);
        } else {
            String otherSqlId = (String)varToSqlIdMapping.get(var);
            if (otherSqlId != null) {
                where.append(" AND " + sqlId + " = " + otherSqlId);
            } else {
                varToSqlIdMapping.put(var, sqlId);
            }
        }
    }

    protected void _inlineConstraints(GraphPattern graphPattern, StringBuffer from2, StringBuffer where, Map varToSqlIdMapping) {
        boolean constraintsModified = false;
        LinkedList conjunctiveConstraints = new LinkedList(graphPattern.getConjunctiveConstraints());
        Iterator iter2 = conjunctiveConstraints.iterator();
        while (iter2.hasNext()) {
            BooleanExpr conjunctiveExpr = (BooleanExpr)iter2.next();
            String sqlConstraint = this._constraintToSql(conjunctiveExpr, from2, varToSqlIdMapping);
            if (sqlConstraint == null) continue;
            where.append(" AND " + sqlConstraint);
            iter2.remove();
            constraintsModified = true;
        }
        if (constraintsModified) {
            graphPattern.setConstraints(conjunctiveConstraints);
        }
    }

    protected String _constraintToSql(BooleanExpr booleanExpr, StringBuffer from2, Map varToSqlIdMapping) {
        ValueCompare valueCompare;
        if (booleanExpr instanceof Not) {
            Not not2 = (Not)booleanExpr;
            String argConstraint = this._constraintToSql(not2.getArg(), from2, varToSqlIdMapping);
            if (argConstraint != null) {
                return "NOT(" + argConstraint + ")";
            }
        } else if (booleanExpr instanceof Or) {
            Or or = (Or)booleanExpr;
            String leftConstraint = this._constraintToSql(or.getLeftArg(), from2, varToSqlIdMapping);
            String rightConstraint = this._constraintToSql(or.getRightArg(), from2, varToSqlIdMapping);
            if (leftConstraint != null && rightConstraint != null) {
                return "(" + leftConstraint + " OR " + rightConstraint + ")";
            }
        } else if (booleanExpr instanceof And) {
            And and2 = (And)booleanExpr;
            String leftConstraint = this._constraintToSql(and2.getLeftArg(), from2, varToSqlIdMapping);
            String rightConstraint = this._constraintToSql(and2.getRightArg(), from2, varToSqlIdMapping);
            if (leftConstraint != null && rightConstraint != null) {
                return "(" + leftConstraint + " AND " + rightConstraint + ")";
            }
        } else if (booleanExpr instanceof Like) {
            Like likeExpr = (Like)booleanExpr;
            if (this._rdbms.supportsPatternMatches(likeExpr.caseSensitive())) {
                String exprSqlId = null;
                StringExpr expr = likeExpr.getStringExpr();
                if (expr instanceof ValueExpr) {
                    Value exprValue = ((ValueExpr)expr).getValue();
                    if (exprValue != null) {
                        exprSqlId = String.valueOf(this._getValueId(exprValue));
                    } else if (expr instanceof Var) {
                        exprSqlId = (String)varToSqlIdMapping.get(expr);
                    }
                }
                if (exprSqlId != null) {
                    String pattern = this._rdbms.getPatternMatchExpr(likeExpr.getPattern(), likeExpr.caseSensitive());
                    int j = 0;
                    while (from2.indexOf("literals l" + j) >= 0) {
                        ++j;
                    }
                    String literalsId = "l" + j;
                    from2.append(", literals " + literalsId);
                    String sqlLike = this._rdbms.getPatternMatchOperator(likeExpr.caseSensitive());
                    return literalsId + ".id = " + exprSqlId + " AND " + literalsId + ".label " + sqlLike + " '" + pattern + "'";
                }
            }
        } else if (booleanExpr instanceof ValueCompare && ((valueCompare = (ValueCompare)booleanExpr).getOperator() == 1 || valueCompare.getOperator() == 2)) {
            URI rightDt;
            URI leftDt;
            ValueExpr leftArg = ((ValueCompare)booleanExpr).getLeftArg();
            ValueExpr rightArg = ((ValueCompare)booleanExpr).getRightArg();
            if (leftArg instanceof Literal ? (leftDt = ((Literal)((Object)leftArg)).getDatatype()) != null : rightArg instanceof Literal && (rightDt = ((Literal)((Object)rightArg)).getDatatype()) != null) {
                return null;
            }
            String leftSqlId = null;
            if (leftArg.getValue() != null) {
                leftSqlId = String.valueOf(this._getValueId(leftArg.getValue()));
            } else if (leftArg instanceof Var) {
                leftSqlId = (String)varToSqlIdMapping.get(leftArg);
            }
            String rightSqlId = null;
            if (rightArg.getValue() != null) {
                rightSqlId = String.valueOf(this._getValueId(rightArg.getValue()));
            } else if (rightArg instanceof Var) {
                rightSqlId = (String)varToSqlIdMapping.get(rightArg);
            }
            if (leftSqlId != null && rightSqlId != null) {
                if (valueCompare.getOperator() == 1) {
                    return leftSqlId + " = " + rightSqlId;
                }
                return leftSqlId + " <> " + rightSqlId;
            }
            return null;
        }
        return null;
    }

    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean explicitOnly) {
        StringBuffer query2 = new StringBuffer(200);
        query2.append("SELECT id FROM triples");
        if (subj != null || pred != null || obj != null || explicitOnly) {
            query2.append(" WHERE ");
            boolean writeAND = false;
            if (subj != null) {
                int subjId = this._getResourceId(subj);
                if (subjId == 0) {
                    return false;
                }
                query2.append("subj = " + subjId);
                writeAND = true;
            }
            if (pred != null) {
                int predId = this._getURIId(pred);
                if (predId == 0) {
                    return false;
                }
                if (writeAND) {
                    query2.append(" AND ");
                }
                query2.append("pred = " + predId);
                writeAND = true;
            }
            if (obj != null) {
                int objId = this._getValueId(obj);
                if (objId == 0) {
                    return false;
                }
                if (writeAND) {
                    query2.append(" AND ");
                }
                query2.append("obj = " + objId);
                writeAND = true;
            }
            if (explicitOnly) {
                if (writeAND) {
                    query2.append(" AND ");
                }
                query2.append("explicit = " + this._rdbms.TRUE);
            }
        }
        try {
            return this._rdbms.queryHasResults(query2.toString());
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public NamespaceIterator getNamespaces() {
        if (!this._exportStatusUpToDate()) {
            this._updateExportedNamespaces();
        }
        return new RdbmsNamespaceIterator(this._namespaceList);
    }

    protected int _getValueId(Value value2) {
        if (value2 instanceof Resource) {
            return this._getResourceId((Resource)value2);
        }
        if (value2 instanceof Literal) {
            return this._getLiteralId((Literal)value2);
        }
        throw new IllegalArgumentException("parameter 'value' should be of type Resource or Literal");
    }

    protected int _getResourceId(Resource res) {
        if (res instanceof URI) {
            return this._getURIId((URI)res);
        }
        if (res instanceof BNode) {
            return this._getBNodeId((BNode)res);
        }
        throw new IllegalArgumentException("parameter 'res' should be of type URI or BNode");
    }

    protected int _getURIId(URI uri2) {
        int id;
        IdURI idURI = null;
        if (this._isOwnValue(uri2) && (id = (idURI = (IdURI)uri2).getInternalId()) != 0) {
            return id;
        }
        int result2 = 0;
        int nsId = this._getNamespaceId(uri2.getNamespace());
        if (nsId == 0) {
            return 0;
        }
        String lname = uri2.getLocalName();
        StringBuffer query2 = new StringBuffer(150);
        query2.append("SELECT id FROM resources");
        query2.append(" WHERE namespace = " + nsId);
        query2.append(" AND localname ");
        if (this._rdbms.emptyStringIsNull() && lname.length() == 0) {
            query2.append("IS NULL");
        } else {
            query2.append("= '");
            query2.append(this._rdbms.escapeString(lname));
            query2.append("'");
        }
        try {
            Connection connection = this._rdbms.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query2.toString());
            if (resultSet.next()) {
                result2 = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        if (idURI != null) {
            idURI.setInternalId(result2);
        }
        return result2;
    }

    protected int _getBNodeId(BNode bNode) {
        int id;
        IdBNode idBNode = null;
        if (this._isOwnValue(bNode) && (id = (idBNode = (IdBNode)bNode).getInternalId()) != 0) {
            return id;
        }
        int result2 = 0;
        String nodeId = bNode.getID();
        StringBuffer query2 = new StringBuffer(150);
        query2.append("SELECT id FROM resources");
        query2.append(" WHERE namespace = 0 AND localname = '");
        query2.append(this._rdbms.escapeString(nodeId));
        query2.append("'");
        try {
            Connection connection = this._rdbms.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query2.toString());
            if (resultSet.next()) {
                result2 = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        if (idBNode != null) {
            idBNode.setInternalId(result2);
        }
        return result2;
    }

    protected int _getLiteralId(Literal literal) {
        int id;
        IdLiteral idLiteral = null;
        if (this._isOwnValue(literal) && (id = (idLiteral = (IdLiteral)literal).getInternalId()) != 0) {
            return id;
        }
        int result2 = 0;
        int datatypeId = 0;
        String label = literal.getLabel();
        String language2 = literal.getLanguage();
        URI datatype = literal.getDatatype();
        if (datatype != null && (datatypeId = this._getURIId(datatype)) == 0) {
            return 0;
        }
        StringBuffer query2 = new StringBuffer(200);
        query2.append("SELECT id, label FROM ");
        query2.append("literals");
        query2.append(" WHERE ");
        query2.append("labelHash = ");
        query2.append(this._getLabelHash(label));
        query2.append(" AND datatype = " + datatypeId);
        query2.append(" AND language");
        if (language2 == null) {
            query2.append(" IS NULL");
        } else {
            query2.append(" = '");
            query2.append(this._rdbms.escapeString(language2));
            query2.append("'");
        }
        try {
            Connection connection = this._rdbms.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(query2.toString());
            while (resultSet.next()) {
                String resultLabel = resultSet.getString(2);
                if (resultLabel == null) {
                    resultLabel = "";
                }
                if (!resultLabel.equals(label)) continue;
                result2 = resultSet.getInt(1);
                break;
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        if (idLiteral != null) {
            idLiteral.setInternalId(result2);
        }
        return result2;
    }

    protected boolean _isOwnValue(Value value2) {
        return value2 instanceof IdValue && ((IdValue)value2).getRdfSource() == this;
    }

    protected int _getNamespaceId(String namespace) {
        RdbmsNamespace n = (RdbmsNamespace)this._namespaceTable.get(namespace);
        if (n != null) {
            return n.getId();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _getLabelHash(String label) {
        try {
            byte[] labelData = label.getBytes("UTF-8");
            byte[] md5hash = null;
            MessageDigest messageDigest = this._md5Digest;
            synchronized (messageDigest) {
                this._md5Digest.reset();
                md5hash = this._md5Digest.digest(labelData);
            }
            return new BigInteger(md5hash).longValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new SailInternalException("UTF-8 encoding not available on this platorm", e);
        }
    }

    protected String[] _chunkIdSet(ResultSet rs, int maxStringLength) throws SQLException {
        ArrayList<String> chunkList = new ArrayList<String>();
        StringBuffer chunk = new StringBuffer(maxStringLength);
        chunk.append("(");
        int count2 = 0;
        while (rs.next()) {
            String nextId = String.valueOf(rs.getInt(1));
            if (chunk.length() + nextId.length() + 1 > maxStringLength) {
                chunk.append(")");
                chunkList.add(chunk.toString());
                chunk.setLength(0);
                chunk.append("(");
                count2 = 0;
            }
            if (count2 > 0) {
                chunk.append(",");
            }
            chunk.append(rs.getInt(1));
            ++count2;
        }
        if (count2 > 0) {
            chunk.append(")");
            chunkList.add(chunk.toString());
        }
        String[] result2 = new String[chunkList.size()];
        for (int i = 0; i < chunkList.size(); ++i) {
            result2[i] = (String)chunkList.get(i);
        }
        return result2;
    }

    protected void _updateExportedNamespaces() {
        ThreadLog.trace((String)"Updating exported namespaces information.");
        try {
            this._rdbms.executeUpdate("UPDATE namespaces SET export = " + this._rdbms.FALSE + " WHERE userDefined = " + this._rdbms.FALSE);
            Connection con = this._rdbms.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT DISTINCT r.namespace FROM resources r, triples t WHERE t.pred = r.id ");
            String[] idChunks = this._chunkIdSet(rs, 3500);
            rs.close();
            st.close();
            con.setAutoCommit(false);
            st = con.createStatement();
            for (int i = 0; i < idChunks.length; ++i) {
                st.executeUpdate("UPDATE namespaces SET export = " + this._rdbms.TRUE + " WHERE id IN " + idChunks[i]);
            }
            con.commit();
            st.close();
            con.close();
            this._setExportStatusUpToDate(true);
            this._initNamespaceCache();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public IdValue getValue(int id) {
        if (id > 0) {
            return this.getResource(id);
        }
        if (id < 0) {
            return this.getLiteral(id);
        }
        return null;
    }

    public IdResource getResource(int id) {
        try {
            IdResource result2 = null;
            Connection con = this._rdbms.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT r.namespace, r.localname FROM resources r WHERE r.id = " + id);
            if (rs.next()) {
                int nsId = rs.getInt(1);
                String localName = rs.getString(2);
                if (localName == null) {
                    localName = "";
                }
                result2 = nsId == 0 ? new IdBNode(this, localName, id) : new IdURI(this, this._namespaceNames[nsId], localName, id);
            }
            rs.close();
            st.close();
            con.close();
            return result2;
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public IdLiteral getLiteral(int id) {
        try {
            IdLiteral result2 = null;
            Connection con = this._rdbms.getConnection();
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT r.id, r.namespace, r.localname, l.language, l.label FROM literals l, resources r WHERE l.datatype = r.id AND l.id = " + id);
            if (rs.next()) {
                int dtId = rs.getInt(1);
                String label = rs.getString(5);
                if (label == null) {
                    label = "";
                }
                if (dtId != 0) {
                    int dtNsId = rs.getInt(2);
                    String dtLname = rs.getString(3);
                    if (dtLname == null) {
                        dtLname = "";
                    }
                    IdURI datatype = new IdURI(this, this._namespaceNames[dtNsId], dtLname, dtId);
                    result2 = new IdLiteral(this, label, datatype, id);
                } else {
                    String lang = rs.getString(4);
                    result2 = lang != null ? new IdLiteral(this, label, lang, id) : new IdLiteral(this, label, id);
                }
            }
            rs.close();
            st.close();
            con.close();
            return result2;
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public URI createURI(String uri2) {
        return new IdURI(this, uri2, 0);
    }

    public URI createURI(String namespace, String localName) {
        return new IdURI(this, namespace, localName, 0);
    }

    public BNode createBNode() {
        if (this._nextBNodeID == Integer.MAX_VALUE) {
            this._updateBNodePrefix();
        }
        return this.createBNode(this._bnodePrefix + this._nextBNodeID++);
    }

    public BNode createBNode(String nodeId) {
        return new IdBNode(this, nodeId, 0);
    }

    public Literal createLiteral(String value2) {
        return new IdLiteral(this, value2, 0);
    }

    public Literal createLiteral(String value2, String language2) {
        return new IdLiteral(this, value2, language2, 0);
    }

    public Literal createLiteral(String value2, URI datatype) {
        return new IdLiteral(this, value2, datatype, 0);
    }

    public org.openrdf.model.Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }
}

