/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.SailChangedListener;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.util.SailChangedEventImpl;
import org.openrdf.sesame.sailimpl.rdbms.RdbmsNamespace;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.TableNames;
import org.openrdf.util.log.ThreadLog;

public class RdfRepository
extends RdfSource
implements org.openrdf.sesame.sail.RdfRepository,
TableNames {
    protected List _sailChangedListeners = new ArrayList(0);
    protected SailChangedEventImpl _sailChangedEvent;
    protected static final String COMMIT_INTERVAL_KEY = "commitInterval";
    protected int _nextResourceId = 1;
    protected int _nextLiteralId = -1;
    protected int _nextStatementId = 1;
    protected boolean _transactionStarted = false;
    protected boolean _statementsAdded;
    protected boolean _statementsRemoved;
    protected int _triplesCommitInterval = 1000;
    protected Connection _addRawTriplesConn;
    protected PreparedStatement _addRawTriplesSt;
    protected int _rawTriplesCount;

    public void initialize(Map configParams) throws SailInitializationException {
        String commitIntervalStr = (String)configParams.get(COMMIT_INTERVAL_KEY);
        if (commitIntervalStr != null) {
            try {
                this._triplesCommitInterval = Integer.parseInt(commitIntervalStr);
            }
            catch (NumberFormatException e) {
                throw new SailInitializationException(e);
            }
        }
        super.initialize(configParams);
    }

    protected void _initDatabase() throws SailInitializationException {
        super._initDatabase();
        try {
            this._setNextResourceId();
            this._setNextLiteralId();
            this._setNextStatementId();
        }
        catch (SQLException e) {
            throw new SailInitializationException(e);
        }
    }

    protected void _createDbSchema() throws SQLException {
        super._createDbSchema();
        this._createAddedTriplesTable();
        this._createNewTriplesTable();
        this._createRawTriplesTable();
        this._createExpiredTriplesTable();
        this._createExpiredResourcesTable();
        this._createExpiredLiteralsTable();
    }

    protected void _createAddedTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._createTriplesTable("addedtriples", false);
            this._rdbms.createIndex("addedtriples", new String[]{"subj", "pred", "obj"}, false);
        } else if (this._schemaVersion < 4) {
            this._rdbms.renameTableColumn("addedtriples", "subject", "subj", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("addedtriples", "predicate", "pred", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("addedtriples", "object", "obj", this._rdbms.ID_INT + " NOT NULL");
        }
    }

    protected void _createNewTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._createTriplesTable("newtriples", false);
        } else if (this._schemaVersion < 4) {
            this._rdbms.renameTableColumn("newtriples", "subject", "subj", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("newtriples", "predicate", "pred", this._rdbms.ID_INT + " NOT NULL");
            this._rdbms.renameTableColumn("newtriples", "object", "obj", this._rdbms.ID_INT + " NOT NULL");
        }
    }

    protected void _createRawTriplesTable() throws SQLException {
        if (this._schemaVersion < 2) {
            if (this._schemaVersion != -1) {
                this._rdbms.dropTable("rawtriples");
            }
            this._rdbms.executeUpdate("CREATE TABLE rawtriples (id " + this._rdbms.ID_INT + " NOT NULL, " + "subjNs " + this._rdbms.ID_INT + " NOT NULL, " + "subjLname " + this._rdbms.LOCALNAME + this.NN_ON_TEXT + ", " + "predNs " + this._rdbms.ID_INT + " NOT NULL, " + "predLname " + this._rdbms.LOCALNAME + this.NN_ON_TEXT + ", " + "objNs " + this._rdbms.ID_INT + " NOT NULL, " + "objLname " + this._rdbms.LOCALNAME + this.NN_ON_TEXT + ", " + "objLabelHash " + this._rdbms.LABEL_HASH + ", " + "objLang " + this._rdbms.LANGUAGE + ", " + "objLabel " + this._rdbms.LABEL + ", " + "objIsLiteral " + this._rdbms.BOOLEAN + ")");
        }
    }

    protected void _createExpiredTriplesTable() throws SQLException {
        if (this._schemaVersion == -1) {
            this._rdbms.executeUpdate("CREATE TABLE expiredtriples (id " + this._rdbms.ID_INT + " NOT NULL)");
        } else if (this._schemaVersion < 5) {
            this._rdbms.dropTable("expiredvalues");
        }
    }

    protected void _createExpiredResourcesTable() throws SQLException {
        if (this._schemaVersion < 5) {
            this._rdbms.executeUpdate("CREATE TABLE expiredresources (id " + this._rdbms.ID_INT + " NOT NULL)");
        }
    }

    protected void _createExpiredLiteralsTable() throws SQLException {
        if (this._schemaVersion < 5) {
            this._rdbms.executeUpdate("CREATE TABLE expiredliterals (id " + this._rdbms.ID_INT + " NOT NULL)");
        }
    }

    protected void _setNextResourceId() throws SQLException {
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM resources");
        this._nextResourceId = rs.next() ? rs.getInt(1) + 1 : 1;
        rs.close();
        st.close();
        con.close();
    }

    protected int _getNextResourceId() {
        return this._nextResourceId++;
    }

    protected void _setNextLiteralId() throws SQLException {
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT MIN(id) FROM literals");
        this._nextLiteralId = rs.next() ? rs.getInt(1) - 1 : -1;
        rs.close();
        st.close();
        con.close();
    }

    protected int _getNextLiteralId() {
        return this._nextLiteralId--;
    }

    protected void _setNextStatementId() throws SQLException {
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT MAX(id) FROM triples");
        this._nextStatementId = rs.next() ? rs.getInt(1) + 1 : 1;
        rs.close();
        st.close();
        con.close();
    }

    protected int _getNextStatementId() {
        return this._nextStatementId++;
    }

    protected void _prepareUploadConnection() throws SQLException {
        this._addRawTriplesConn = this._rdbms.getConnection();
        this._addRawTriplesConn.setAutoCommit(false);
        this._addRawTriplesSt = this._addRawTriplesConn.prepareStatement("INSERT INTO rawtriples VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    }

    protected void _closeUploadConnection() throws SQLException {
        if (this._rawTriplesCount > 0) {
            this._addRawTriplesConn.commit();
            this._rawTriplesCount = 0;
        }
        this._addRawTriplesSt.close();
        this._addRawTriplesConn.close();
    }

    public void startTransaction() {
        if (this._transactionStarted) {
            throw new SailInternalException("A transaction has already been started");
        }
        try {
            this._prepareUploadConnection();
            this._rawTriplesCount = 0;
            this._transactionStarted = true;
            this._sailChangedEvent = new SailChangedEventImpl();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public boolean transactionStarted() {
        return this._transactionStarted;
    }

    public void addStatement(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this._transactionStarted) {
            throw new SailUpdateException("No transaction was started");
        }
        try {
            int nsId;
            URI uri2;
            BNode bNode;
            this._addRawTriplesSt.setInt(1, this._getNextStatementId());
            if (subj instanceof BNode) {
                bNode = (BNode)subj;
                String nodeId = bNode.getID();
                this._addRawTriplesSt.setInt(2, 0);
                this._addRawTriplesSt.setString(3, nodeId);
            } else {
                uri2 = (URI)subj;
                nsId = this._createIdForNamespace(uri2.getNamespace());
                this._addRawTriplesSt.setInt(2, nsId);
                this._addRawTriplesSt.setString(3, uri2.getLocalName());
            }
            nsId = this._createIdForNamespace(pred.getNamespace());
            this._addRawTriplesSt.setInt(4, nsId);
            this._addRawTriplesSt.setString(5, pred.getLocalName());
            if (obj instanceof Resource) {
                if (obj instanceof BNode) {
                    bNode = (BNode)obj;
                    this._addRawTriplesSt.setInt(6, 0);
                    this._addRawTriplesSt.setString(7, bNode.getID());
                } else {
                    uri2 = (URI)obj;
                    nsId = this._createIdForNamespace(uri2.getNamespace());
                    this._addRawTriplesSt.setInt(6, nsId);
                    this._addRawTriplesSt.setString(7, uri2.getLocalName());
                }
                this._addRawTriplesSt.setLong(8, 0L);
                this._addRawTriplesSt.setNull(9, this._rdbms.LANGUAGE_TYPE);
                this._addRawTriplesSt.setNull(10, this._rdbms.LABEL_TYPE);
                this._addRawTriplesSt.setBoolean(11, false);
            } else if (obj instanceof Literal) {
                Literal objLit = (Literal)obj;
                String label = objLit.getLabel();
                String lang = objLit.getLanguage();
                URI datatype = objLit.getDatatype();
                if (datatype != null) {
                    nsId = this._createIdForNamespace(datatype.getNamespace());
                    this._addRawTriplesSt.setInt(6, nsId);
                    this._addRawTriplesSt.setString(7, datatype.getLocalName());
                } else {
                    this._addRawTriplesSt.setInt(6, 0);
                    this._addRawTriplesSt.setString(7, "");
                }
                this._addRawTriplesSt.setLong(8, this._getLabelHash(label));
                if (lang != null && datatype == null) {
                    this._addRawTriplesSt.setString(9, lang);
                } else {
                    this._addRawTriplesSt.setNull(9, this._rdbms.LANGUAGE_TYPE);
                }
                this._addRawTriplesSt.setString(10, label);
                this._addRawTriplesSt.setBoolean(11, true);
            }
            this._addRawTriplesSt.executeUpdate();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        this._statementsAdded = true;
        ++this._rawTriplesCount;
        if (this._rawTriplesCount >= this._triplesCommitInterval) {
            try {
                this._closeUploadConnection();
                this._processRawTriples();
                this._prepareUploadConnection();
            }
            catch (SQLException e) {
                throw new SailInternalException(e);
            }
        }
    }

    public int removeStatements(Resource subj, URI pred, Value obj) throws SailUpdateException {
        if (!this._transactionStarted) {
            throw new SailUpdateException("No transaction started");
        }
        String query2 = "INSERT INTO expiredtriples SELECT id FROM triples WHERE explicit = " + this._rdbms.TRUE;
        if (subj != null) {
            int subjId = this._getResourceId(subj);
            if (subjId == 0) {
                return 0;
            }
            query2 = query2 + " AND subj = " + subjId;
        }
        if (pred != null) {
            int predId = this._getURIId(pred);
            if (predId == 0) {
                return 0;
            }
            query2 = query2 + " AND pred = " + predId;
        }
        if (obj != null) {
            int objId = this._getValueId(obj);
            if (objId == 0) {
                return 0;
            }
            query2 = query2 + " AND obj = " + objId;
        }
        try {
            int count2 = this._rdbms.executeUpdate(query2);
            if (count2 > 0) {
                this._rdbms.optimizeTable("expiredtriples", count2);
                this._statementsRemoved = true;
            }
            return count2;
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public void commitTransaction() {
        try {
            this._closeUploadConnection();
            if (this._statementsRemoved) {
                this._sailChangedEvent.setStatementsRemoved(true);
                this._recordExpiredValues();
                this._removeExpiredStatements();
                this._removeExpiredValues();
            }
            if (this._statementsAdded) {
                this._sailChangedEvent.setStatementsAdded(true);
                this._processRawTriples();
                this._rdbms.optimizeTable("addedtriples");
                this._removeDuplicatesFromAddedTriples();
                this._processAddedTriples();
                int newTriplesCount = this._rdbms.copyRows("newtriples", "triples");
                if (newTriplesCount == 0) {
                    this._rdbms.optimizeTable("triples", newTriplesCount);
                    this._statementsAdded = false;
                }
            }
            if (this._statementsAdded || this._statementsRemoved) {
                this._processChangedTriples();
                this._rdbms.clearTable("newtriples");
                this._rdbms.clearTable("expiredtriples");
                this._setExportStatusUpToDate(false);
                this._statementsAdded = false;
                this._statementsRemoved = false;
            }
            this._notifySailChanged(this._sailChangedEvent);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        finally {
            this._sailChangedEvent = null;
            this._transactionStarted = false;
        }
    }

    protected void _recordExpiredValues() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO expiredresources SELECT t.subj FROM triples t, expiredtriples expt WHERE t.id = expt.id");
        this._rdbms.executeUpdate("INSERT INTO expiredresources SELECT t.pred FROM triples t, expiredtriples expt WHERE t.id = expt.id");
        this._rdbms.executeUpdate("INSERT INTO expiredresources SELECT t.obj FROM triples t, expiredtriples expt WHERE t.id = expt.id AND t.obj > 0");
        this._rdbms.executeUpdate("INSERT INTO expiredliterals SELECT t.obj FROM triples t, expiredtriples expt WHERE t.id = expt.id AND t.obj < 0");
    }

    protected void _removeExpiredValues() throws SQLException {
        int i;
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT expr.id FROM expiredresources expr  LEFT JOIN triples t  ON expr.id = t.subj OR expr.id = t.pred OR expr.id = t.obj  LEFT JOIN literals l  ON expr.id = l.datatype  WHERE t.id IS NULL AND l.id IS NULL");
        String[] idChunks = this._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.close();
        this._rdbms.clearTable("expiredresources");
        if (idChunks.length > 0) {
            con = this._rdbms.getConnection();
            con.setAutoCommit(false);
            st = con.createStatement();
            for (i = 0; i < idChunks.length; ++i) {
                st.executeUpdate("DELETE FROM resources WHERE id IN " + idChunks[i]);
            }
            con.commit();
            st.close();
            con.close();
            this._rdbms.optimizeTable("resources");
        }
        con = this._rdbms.getConnection();
        st = con.createStatement();
        rs = st.executeQuery("SELECT expl.id FROM expiredliterals expl LEFT JOIN triples t ON expl.id = t.obj WHERE t.id IS NULL");
        idChunks = this._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.close();
        this._rdbms.clearTable("expiredliterals");
        if (idChunks.length > 0) {
            con = this._rdbms.getConnection();
            con.setAutoCommit(false);
            st = con.createStatement();
            for (i = 0; i < idChunks.length; ++i) {
                st.executeUpdate("DELETE FROM literals WHERE id IN " + idChunks[i]);
            }
            con.commit();
            st.close();
            con.close();
            this._rdbms.optimizeTable("literals");
        }
    }

    protected void _removeExpiredStatements() throws SQLException {
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT id FROM expiredtriples");
        String[] idChunks = this._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.setAutoCommit(false);
        st = con.createStatement();
        int count2 = 0;
        for (int i = 0; i < idChunks.length; ++i) {
            count2 += st.executeUpdate("DELETE FROM triples WHERE id IN " + idChunks[i]);
            this._processChunkFromRemoveExpiredStatements(idChunks[i]);
        }
        con.commit();
        st.close();
        con.close();
        this._rdbms.optimizeTable("triples", count2);
    }

    protected void _processChunkFromRemoveExpiredStatements(String idList) throws SQLException {
    }

    protected void _processRawTriples() throws SQLException {
        this._rdbms.optimizeTable("rawtriples");
        this._addNewResources();
        this._addNewLiterals();
        this._copyRawTriplesToAddedTriples();
        this._rdbms.clearTable("rawtriples");
    }

    protected void _addNewResources() throws SQLException {
        Connection addResourceCon = this._rdbms.getConnection();
        addResourceCon.setAutoCommit(false);
        PreparedStatement addResourceSt = addResourceCon.prepareStatement("INSERT INTO resources VALUES(?, ?, ?)");
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        String localnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.subjLname IS NULL AND r.localname IS NULL OR " : "";
        String query2 = "SELECT DISTINCT rt.subjNs, rt.subjLname FROM rawtriples rt LEFT JOIN resources r ON rt.subjNs = r.namespace AND (" + localnamesAreNullOr + "rt.subjLname = r.localname) " + "WHERE r.namespace IS NULL";
        this._processNewResources(st.executeQuery(query2), addResourceCon, addResourceSt);
        localnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.predLname IS NULL AND r.localname IS NULL OR " : "";
        query2 = "SELECT DISTINCT rt.predNs, rt.predLname FROM rawtriples rt LEFT JOIN resources r ON rt.predNs = r.namespace AND (" + localnamesAreNullOr + "rt.predLname = r.localname) " + "WHERE r.namespace IS NULL";
        this._processNewResources(st.executeQuery(query2), addResourceCon, addResourceSt);
        localnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.objLname IS NULL AND r.localname IS NULL OR " : "";
        query2 = "SELECT DISTINCT rt.objNs, rt.objLname FROM rawtriples rt LEFT JOIN resources r ON rt.objNs = r.namespace AND (" + localnamesAreNullOr + "rt.objLname = r.localname) " + "WHERE r.namespace IS NULL";
        this._processNewResources(st.executeQuery(query2), addResourceCon, addResourceSt);
        st.close();
        con.close();
        addResourceSt.close();
        addResourceCon.close();
    }

    protected void _processNewResources(ResultSet rs, Connection addResourceCon, PreparedStatement addResourceSt) throws SQLException {
        int newCount = 0;
        while (rs.next()) {
            int ns = rs.getInt(1);
            String lname = rs.getString(2);
            if (lname == null) {
                lname = "";
            }
            int resId = this._getNextResourceId();
            addResourceSt.setInt(1, resId);
            addResourceSt.setInt(2, ns);
            addResourceSt.setString(3, lname);
            addResourceSt.executeUpdate();
            ++newCount;
        }
        rs.close();
        if (newCount > 0) {
            addResourceCon.commit();
            this._rdbms.optimizeTable("resources", newCount);
        }
    }

    protected void _addNewLiterals() throws SQLException {
        Connection addLiteralCon = this._rdbms.getConnection();
        addLiteralCon.setAutoCommit(false);
        PreparedStatement addLiteralSt = addLiteralCon.prepareStatement("INSERT INTO literals VALUES(?, ?, ?, ?, ?)");
        String localnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.objLname IS NULL AND dt.localname IS NULL OR " : "";
        String labelsAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.objLabel IS NULL AND l.label IS NULL OR " : "";
        String query2 = "SELECT DISTINCT dt.id, rt.objLang, rt.objLabelHash, rt.objLabel FROM rawtriples rt LEFT JOIN resources dt ON rt.objNs = dt.namespace AND (" + localnamesAreNullOr + "rt.objLname = dt.localname) " + "LEFT JOIN " + "literals" + " l ON " + "rt.objLabelHash = l.labelHash " + "AND dt.id = l.datatype " + "AND (rt.objLang IS NULL AND l.language IS NULL OR rt.objLang = l.language) " + "AND (" + labelsAreNullOr + "rt.objLabel = l.label) " + "WHERE " + "rt.objIsLiteral = " + this._rdbms.TRUE + " AND " + "l.id IS NULL";
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query2);
        int newCount = 0;
        while (rs.next()) {
            int datatypeId = rs.getInt(1);
            String lang = rs.getString(2);
            long labelHash = rs.getLong(3);
            String label = rs.getString(4);
            if (label == null) {
                label = "";
            }
            addLiteralSt.setInt(1, this._getNextLiteralId());
            addLiteralSt.setInt(2, datatypeId);
            addLiteralSt.setLong(3, labelHash);
            if (lang != null) {
                addLiteralSt.setString(4, lang);
            } else {
                addLiteralSt.setNull(4, this._rdbms.LANGUAGE_TYPE);
            }
            addLiteralSt.setString(5, label);
            addLiteralSt.executeUpdate();
            ++newCount;
        }
        rs.close();
        st.close();
        con.close();
        if (newCount > 0) {
            addLiteralCon.commit();
            this._rdbms.optimizeTable("literals", newCount);
        }
        addLiteralSt.close();
        addLiteralCon.close();
    }

    protected void _copyRawTriplesToAddedTriples() throws SQLException {
        String subjLnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.subjLname IS NULL AND r1.localname IS NULL OR " : "";
        String predLnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.predLname IS NULL AND r2.localname IS NULL OR " : "";
        String objLnamesAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.objLname IS NULL AND r3.localname IS NULL OR " : "";
        String labelsAreNullOr = this._rdbms.emptyStringIsNull() ? "rt.objLabel IS NULL AND l.label IS NULL OR " : "";
        this._rdbms.executeUpdate("INSERT INTO addedtriples SELECT rt.id, r1.id, r2.id, r3.id, " + this._rdbms.TRUE + " " + "FROM " + "rawtriples" + " rt, " + "resources" + " r1, " + "resources" + " r2, " + "resources" + " r3 " + "WHERE " + "rt.objIsLiteral = " + this._rdbms.FALSE + " AND " + "rt.subjNs = r1.namespace AND " + "(" + subjLnamesAreNullOr + "rt.subjLname = r1.localname) AND " + "rt.predNs = r2.namespace AND " + "(" + predLnamesAreNullOr + "rt.predLname = r2.localname) AND " + "rt.objNs = r3.namespace AND " + "(" + objLnamesAreNullOr + "rt.objLname = r3.localname)");
        this._rdbms.executeUpdate("INSERT INTO addedtriples SELECT rt.id, r1.id, r2.id, l.id, " + this._rdbms.TRUE + " " + "FROM " + "rawtriples" + " rt, " + "resources" + " r1, " + "resources" + " r2, " + "literals" + " l, " + "resources" + " r3 " + "WHERE " + "rt.objIsLiteral = " + this._rdbms.TRUE + " AND " + "rt.subjNs = r1.namespace AND " + "(" + subjLnamesAreNullOr + "rt.subjLname = r1.localname) AND " + "rt.predNs = r2.namespace AND " + "(" + predLnamesAreNullOr + "rt.predLname = r2.localname) AND " + "rt.objLabelHash = l.labelHash AND " + "(rt.objLang IS NULL AND l.language IS NULL OR rt.objLang = l.language) AND " + "(" + labelsAreNullOr + "rt.objLabel = l.label) AND " + "l.datatype = r3.id AND " + "r3.namespace = rt.objNs AND " + "(" + objLnamesAreNullOr + "rt.objLname = r3.localname)");
    }

    protected void _removeDuplicatesFromAddedTriples() throws SQLException {
        Connection con = this._rdbms.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT at2.id FROM addedtriples at1, addedtriples at2 WHERE at1.subj = at2.subj AND at1.pred = at2.pred AND at1.obj = at2.obj AND at1.id < at2.id");
        String[] idChunks = this._chunkIdSet(rs, 3500);
        rs.close();
        st.close();
        con.setAutoCommit(false);
        st = con.createStatement();
        for (int i = 0; i < idChunks.length; ++i) {
            st.executeUpdate("DELETE FROM addedtriples WHERE id IN " + idChunks[i]);
        }
        con.commit();
        st.close();
        con.close();
    }

    protected void _processAddedTriples() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO newtriples SELECT at.* FROM addedtriples at LEFT JOIN triples t ON at.subj = t.subj AND at.pred = t.pred AND at.obj = t.obj WHERE t.subj IS NULL");
        this._rdbms.clearTable("addedtriples");
        this._rdbms.optimizeTable("newtriples");
    }

    protected void _processChangedTriples() throws SQLException {
    }

    public void clearRepository() throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("No transaction was started");
        }
        try {
            this._rdbms.clearTable("addedtriples");
            this._rdbms.clearTable("newtriples");
            this._rdbms.clearTable("rawtriples");
            this._rdbms.clearTable("expiredtriples");
            this._rdbms.clearTable("expiredresources");
            this._rdbms.clearTable("expiredliterals");
            this._rdbms.clearTable("triples");
            this._rdbms.clearTable("literals");
            this._rdbms.clearTable("resources");
            this._rdbms.clearTable("namespaces");
            this._rdbms.executeUpdate("INSERT INTO namespaces VALUES(0, '', NULL, " + this._rdbms.FALSE + ", " + this._rdbms.FALSE + ")");
            this._rdbms.executeUpdate("INSERT INTO resources VALUES(0, 0, '')");
            this._setExportStatusUpToDate(true);
            this._initNamespaceCache();
            this._setNextResourceId();
            this._setNextLiteralId();
            this._setNextStatementId();
            this._updateBNodePrefix();
            this._sailChangedEvent.setStatementsRemoved(true);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public void changeNamespacePrefix(String namespace, String prefix) throws SailUpdateException {
        if (!this.transactionStarted()) {
            throw new SailUpdateException("No transaction was started");
        }
        if (prefix.length() > this._rdbms.MAX_PREFIX_LENGTH) {
            ThreadLog.log((String)("Prefix '" + prefix + "' too long, truncating it to " + this._rdbms.MAX_PREFIX_LENGTH + " characters"));
            prefix = prefix.substring(0, this._rdbms.MAX_PREFIX_LENGTH);
        }
        try {
            RdbmsNamespace ns = this._getNamespaceForPrefix(prefix);
            if (ns != null) {
                if (ns.getName().equals(namespace)) {
                    return;
                }
                throw new SailUpdateException("Prefix '" + prefix + "'is already used for another namespace");
            }
            this._rdbms.executeUpdate("UPDATE namespaces SET prefix = '" + this._rdbms.escapeString(prefix) + "'," + " userDefined = " + this._rdbms.TRUE + "," + " export = " + this._rdbms.TRUE + " WHERE name = '" + this._rdbms.escapeString(namespace) + "'");
            ns = (RdbmsNamespace)this._namespaceTable.get(namespace);
            if (ns != null) {
                ns.setPrefix(prefix);
                ns.setExported(true);
            }
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    protected int _createIdForNamespace(String namespace) {
        int namespaceId = 0;
        if (namespace != null && (namespaceId = this._getNamespaceId(namespace)) == 0) {
            namespaceId = this._addNamespace(namespace);
        }
        return namespaceId;
    }

    private int _addNamespace(String namespace) {
        RdbmsNamespace ns;
        String prefix = null;
        int nsId = this._getNextNamespaceId();
        while ((ns = this._getNamespaceForPrefix(prefix = "ns" + nsId)) != null) {
            nsId = this._getNextNamespaceId();
        }
        return this._addNamespace(nsId, prefix, namespace);
    }

    private int _addNamespace(int nsId, String prefix, String namespace) {
        try {
            this._rdbms.executeUpdate("INSERT INTO namespaces VALUES (" + nsId + ", '" + this._rdbms.escapeString(prefix) + "', '" + this._rdbms.escapeString(namespace) + "', " + this._rdbms.FALSE + ", " + this._rdbms.FALSE + ")");
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        RdbmsNamespace ns = new RdbmsNamespace(nsId, prefix, namespace, false);
        this._namespaceTable.put(namespace, ns);
        this._namespaceList.add(ns);
        if (nsId >= this._namespaceNames.length) {
            int newLength = this._namespaceNames.length * 2;
            newLength = Math.max(newLength, nsId + 1);
            String[] newArray = new String[newLength];
            System.arraycopy(this._namespaceNames, 0, newArray, 0, this._namespaceNames.length);
            this._namespaceNames = newArray;
        }
        this._namespaceNames[nsId] = namespace;
        return nsId;
    }

    protected RdbmsNamespace _getNamespaceForPrefix(String prefix) {
        Iterator iter2 = this._namespaceList.iterator();
        while (iter2.hasNext()) {
            RdbmsNamespace ns = (RdbmsNamespace)iter2.next();
            if (!ns.getPrefix().equals(prefix)) continue;
            return ns;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SailChangedListener listener) {
        List list2 = this._sailChangedListeners;
        synchronized (list2) {
            this._sailChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SailChangedListener listener) {
        List list2 = this._sailChangedListeners;
        synchronized (list2) {
            this._sailChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _notifySailChanged(SailChangedEventImpl event) {
        List list2 = this._sailChangedListeners;
        synchronized (list2) {
            if (this._sailChangedListeners.size() > 0 && event.sailChanged()) {
                Iterator listeners = this._sailChangedListeners.iterator();
                while (listeners.hasNext()) {
                    SailChangedListener listener = (SailChangedListener)listeners.next();
                    listener.sailChanged(event);
                }
            }
        }
    }
}

