/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdfSchemaRepository;
import org.openrdf.sesame.sailimpl.rdbms.TableNames;
import org.openrdf.util.log.ThreadLog;

public class RdfMTInferencer
implements TableNames {
    private static final int Rdf1 = 0;
    private static final int Rdfs2_1 = 1;
    private static final int Rdfs2_2 = 2;
    private static final int Rdfs3_1 = 3;
    private static final int Rdfs3_2 = 4;
    private static final int Rdfs4a = 5;
    private static final int Rdfs4b = 6;
    private static final int Rdfs5_1 = 7;
    private static final int Rdfs5_2 = 8;
    private static final int Rdfs6 = 9;
    private static final int Rdfs7_1 = 10;
    private static final int Rdfs7_2 = 11;
    private static final int Rdfs8 = 12;
    private static final int Rdfs9_1 = 13;
    private static final int Rdfs9_2 = 14;
    private static final int Rdfs10 = 15;
    private static final int Rdfs11_1 = 16;
    private static final int Rdfs11_2 = 17;
    private static final int Rdfs12 = 18;
    private static final int Rdfs13 = 19;
    private static final int RX1 = 20;
    private static final int RULECOUNT = 21;
    private static final String[] RULENAMES = new String[]{"Rdf1", "Rdfs2_1", "Rdfs2_2", "Rdfs3_1", "Rdfs3_2", "Rdfs4a", "Rdfs4b", "Rdfs5_1", "Rdfs5_2", "Rdfs6", "Rdfs7_1", "Rdfs7_2", "Rdfs8", "Rdfs9_1", "Rdfs9_2", "Rdfs10", "Rdfs11_1", "Rdfs11_2", "Rdfs12", "Rdfs13", "RX1"};
    private static final boolean _ = false;
    private static final boolean X = true;
    private static final boolean[][] TRIGGERS = new boolean[][]{{false, true, false, true, false, true, false, false, false, true, true, false, false, false, true, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, true, true, false, true, true, false, false, false, false, false, false, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false}, {false, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, true, true, true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true}, {false, true, false, true, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, false, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, false, false, true, false, false, false, false, false, true, true, false, true, false, true, true, false, false, true, true, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, true, false, true, false, false, true, true, true, false, true, true, false, false, false, false, false, false, false, false, false}, {false, true, false, false, false, false, false, false, false, false, true, false, false, true, false, false, true, true, false, false, false}, {false, true, false, true, false, false, false, false, false, false, true, false, false, false, true, false, false, false, true, false, false}};
    private RdfSchemaRepository _repository;
    private RDBMS _rdbms;
    private Connection _insertCon;
    private PreparedStatement _insertSt;
    private boolean[] _checkRule = new boolean[21];
    private boolean[] _checkRuleNextIter = new boolean[21];
    private int _totalInferred = 0;
    private int[] _ruleCount = new int[21];
    private long[] _ruleTime = new long[21];

    public RdfMTInferencer(RdfSchemaRepository repository, RDBMS rdbms) {
        this._repository = repository;
        this._rdbms = rdbms;
    }

    private void _prepareInsertConnection() throws SQLException {
        this._insertCon = this._rdbms.getConnection();
        this._insertCon.setAutoCommit(false);
        this._insertSt = this._insertCon.prepareStatement("INSERT INTO inferred VALUES(?, ?, ?, ?, ?)");
        this._insertSt.setBoolean(5, false);
    }

    private void _closeInsertConnection(boolean mustCommit) throws SQLException {
        if (mustCommit) {
            this._insertCon.commit();
        }
        this._insertSt.close();
        this._insertCon.close();
    }

    public void initialize() {
        try {
            this._addAxioms();
            this.doInferencing();
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    private void _addAxioms() throws SQLException {
        ThreadLog.trace((String)"adding axioms");
        this._prepareInsertConnection();
        this._insertAxiom(this._repository.rdfTypeId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfSubjectId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfPredicateId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfObjectId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfFirstId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfRestId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfValueId, this._repository.rdfTypeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfNilId, this._repository.rdfTypeId, this._repository.rdfListId);
        this._insertAxiom(this._repository.rdfTypeId, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsDomainId, this._repository.rdfsDomainId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfsRangeId, this._repository.rdfsDomainId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfsSubPropertyOfId, this._repository.rdfsDomainId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfsSubClassOfId, this._repository.rdfsDomainId, this._repository.rdfsClassId);
        this._insertAxiom(this._repository.rdfSubjectId, this._repository.rdfsDomainId, this._repository.rdfStatementId);
        this._insertAxiom(this._repository.rdfPredicateId, this._repository.rdfsDomainId, this._repository.rdfStatementId);
        this._insertAxiom(this._repository.rdfObjectId, this._repository.rdfsDomainId, this._repository.rdfStatementId);
        this._insertAxiom(this._repository.rdfsMemberId, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfFirstId, this._repository.rdfsDomainId, this._repository.rdfListId);
        this._insertAxiom(this._repository.rdfRestId, this._repository.rdfsDomainId, this._repository.rdfListId);
        this._insertAxiom(this._repository.rdfsSeeAlsoId, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsIsDefinedById, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsCommentId, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsLabelId, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfValueId, this._repository.rdfsDomainId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfTypeId, this._repository.rdfsRangeId, this._repository.rdfsClassId);
        this._insertAxiom(this._repository.rdfsDomainId, this._repository.rdfsRangeId, this._repository.rdfsClassId);
        this._insertAxiom(this._repository.rdfsRangeId, this._repository.rdfsRangeId, this._repository.rdfsClassId);
        this._insertAxiom(this._repository.rdfsSubPropertyOfId, this._repository.rdfsRangeId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfsSubClassOfId, this._repository.rdfsRangeId, this._repository.rdfsClassId);
        this._insertAxiom(this._repository.rdfSubjectId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfPredicateId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfObjectId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsMemberId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfFirstId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfRestId, this._repository.rdfsRangeId, this._repository.rdfListId);
        this._insertAxiom(this._repository.rdfsSeeAlsoId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsIsDefinedById, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfsCommentId, this._repository.rdfsRangeId, this._repository.rdfsLiteralId);
        this._insertAxiom(this._repository.rdfsLabelId, this._repository.rdfsRangeId, this._repository.rdfsLiteralId);
        this._insertAxiom(this._repository.rdfValueId, this._repository.rdfsRangeId, this._repository.rdfsResourceId);
        this._insertAxiom(this._repository.rdfAltId, this._repository.rdfsSubClassOfId, this._repository.rdfsContainerId);
        this._insertAxiom(this._repository.rdfBagId, this._repository.rdfsSubClassOfId, this._repository.rdfsContainerId);
        this._insertAxiom(this._repository.rdfSeqId, this._repository.rdfsSubClassOfId, this._repository.rdfsContainerId);
        this._insertAxiom(this._repository.rdfsContainerMembershipPropertyId, this._repository.rdfsSubClassOfId, this._repository.rdfPropertyId);
        this._insertAxiom(this._repository.rdfsIsDefinedById, this._repository.rdfsSubPropertyOfId, this._repository.rdfsSeeAlsoId);
        this._insertAxiom(this._repository.rdfXMLLiteralId, this._repository.rdfTypeId, this._repository.rdfsDatatypeId);
        this._insertAxiom(this._repository.rdfXMLLiteralId, this._repository.rdfsSubClassOfId, this._repository.rdfsLiteralId);
        this._insertAxiom(this._repository.rdfsDatatypeId, this._repository.rdfsSubClassOfId, this._repository.rdfsClassId);
        this._closeInsertConnection(true);
        int newAxioms = this._rdbms.executeUpdate("INSERT INTO newtriples SELECT inf.* FROM inferred inf LEFT JOIN triples t ON inf.subj = t.subj AND inf.pred = t.pred AND inf.obj = t.obj WHERE t.subj IS NULL");
        if (newAxioms > 0) {
            this._rdbms.copyRows("newtriples", "triples");
            this._rdbms.copyRows("newtriples", "allnewtriples");
        }
        this._rdbms.clearTable("inferred");
    }

    private void _insertAxiom(int subjId, int predId, int objId) throws SQLException {
        this._insertSt.setInt(1, this._repository._getNextStatementId());
        this._insertSt.setInt(2, subjId);
        this._insertSt.setInt(3, predId);
        this._insertSt.setInt(4, objId);
        this._insertSt.executeUpdate();
    }

    public void doInferencing() {
        this._totalInferred = 0;
        int iteration = 0;
        for (int i = 0; i < 21; ++i) {
            this._ruleCount[i] = 0;
            this._ruleTime[i] = 0L;
            this._checkRuleNextIter[i] = true;
        }
        int nofInferred = 1;
        ThreadLog.trace((String)"starting inferencing");
        try {
            while (nofInferred > 0) {
                ++iteration;
                this._prepareNextIteration();
                nofInferred = 0;
                nofInferred += this._applyRuleRdf1();
                nofInferred += this._applyRuleRdfs2_1();
                nofInferred += this._applyRuleRdfs2_2();
                nofInferred += this._applyRuleRdfs3_1();
                nofInferred += this._applyRuleRdfs3_2();
                nofInferred += this._applyRuleRdfs4a();
                nofInferred += this._applyRuleRdfs4b();
                nofInferred += this._applyRuleRdfs5_1();
                nofInferred += this._applyRuleRdfs5_2();
                nofInferred += this._applyRuleRdfs6();
                nofInferred += this._applyRuleRdfs6();
                nofInferred += this._applyRuleRdfs7_1();
                nofInferred += this._applyRuleRdfs7_2();
                nofInferred += this._applyRuleRdfs8();
                nofInferred += this._applyRuleRdfs9_1();
                nofInferred += this._applyRuleRdfs9_2();
                nofInferred += this._applyRuleRdfs10();
                nofInferred += this._applyRuleRdfs11_1();
                nofInferred += this._applyRuleRdfs11_2();
                nofInferred += this._applyRuleRdfs12();
                nofInferred += this._applyRuleRdfs13();
                this._totalInferred += (nofInferred += this._applyRuleX1());
                this._rdbms.clearTable("newtriples");
                if (nofInferred > 0) {
                    this._rdbms.copyRows("allinferred", "newtriples");
                    this._rdbms.copyRows("allinferred", "allnewtriples");
                    this._rdbms.clearTable("allinferred");
                    this._rdbms.optimizeTable("newtriples");
                    this._rdbms.optimizeTable("triples");
                }
                ThreadLog.trace((String)("iteration " + iteration + " done; " + "inferred " + nofInferred + " new statements"));
            }
            this._rdbms.optimizeTable("allnewtriples");
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
        ThreadLog.trace((String)"---RdfMTInferencer statistics:---");
        ThreadLog.trace((String)("total statements inferred = " + this._totalInferred));
        for (int i = 0; i < 21; ++i) {
            ThreadLog.trace((String)("rule " + RULENAMES[i] + ": time=" + this._ruleTime[i] + ";\t#inferred=" + this._ruleCount[i]));
        }
        ThreadLog.trace((String)"---end of statistics:---");
    }

    private void _prepareNextIteration() {
        for (int i = 0; i < 21; ++i) {
            this._checkRule[i] = this._checkRuleNextIter[i];
            this._checkRuleNextIter[i] = false;
        }
    }

    private int _applyRuleRdf1() throws SQLException {
        String query2 = "SELECT DISTINCT nt.pred, " + this._repository.rdfTypeId + ", " + this._repository.rdfPropertyId + " FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.pred = t.subj AND " + "   t.pred = " + this._repository.rdfTypeId + " AND " + "   t.obj = " + this._repository.rdfPropertyId + " " + "WHERE " + "   t.subj IS NULL";
        return this._applyRule(0, query2);
    }

    private int _applyRuleRdfs2_1() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfTypeId + ", " + "t1.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.pred = t1.subj AND " + "   t1.pred = " + this._repository.rdfsDomainId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.subj = t2.subj AND " + "   t1.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfTypeId + " " + "WHERE " + "   t1.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(1, query2);
    }

    private int _applyRuleRdfs2_2() throws SQLException {
        String query2 = "SELECT DISTINCT t1.subj, " + this._repository.rdfTypeId + ", " + "nt.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.subj = t1.pred " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.obj = t2.obj AND " + "   t1.subj = t2.subj AND " + "   t2.pred = " + this._repository.rdfTypeId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfsDomainId + " AND " + "   nt.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(2, query2);
    }

    private int _applyRuleRdfs3_1() throws SQLException {
        String query2 = "SELECT DISTINCT nt.obj, " + this._repository.rdfTypeId + ", " + "t1.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.pred = t1.subj AND " + "   t1.pred = " + this._repository.rdfsRangeId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.obj = t2.subj AND " + "   t1.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfTypeId + " " + "WHERE " + "   nt.obj > 0 AND " + "   t1.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(3, query2);
    }

    private int _applyRuleRdfs3_2() throws SQLException {
        String query2 = "SELECT DISTINCT t1.obj, " + this._repository.rdfTypeId + ", " + "nt.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.subj = t1.pred " + "LEFT JOIN " + "triples" + " t2 ON " + "   t1.obj = t2.subj AND " + "   nt.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfTypeId + " " + "WHERE " + "   t1.obj > 0 AND " + "   nt.obj > 0 AND " + "   nt.pred = " + this._repository.rdfsRangeId + " AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(4, query2);
    }

    private int _applyRuleRdfs4a() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfTypeId + ", " + this._repository.rdfsResourceId + " FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.subj = t.subj AND " + "   t.pred = " + this._repository.rdfTypeId + " AND " + "   t.obj = " + this._repository.rdfsResourceId + " " + "WHERE " + "   t.subj IS NULL";
        return this._applyRule(5, query2);
    }

    private int _applyRuleRdfs4b() throws SQLException {
        String query2 = "SELECT DISTINCT nt.obj, " + this._repository.rdfTypeId + ", " + this._repository.rdfsResourceId + " FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.obj = t.subj AND " + "   t.pred = " + this._repository.rdfTypeId + " AND " + "   t.obj = " + this._repository.rdfsResourceId + " " + "WHERE " + "   nt.obj > 0 AND " + "   t.subj IS NULL";
        return this._applyRule(6, query2);
    }

    private int _applyRuleRdfs5_1() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubPropertyOfId + ", " + "t1.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.obj = t1.subj AND " + "   t1.pred = " + this._repository.rdfsSubPropertyOfId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.subj = t2.subj AND " + "   t1.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfsSubPropertyOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfsSubPropertyOfId + " AND " + "   t1.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(7, query2);
    }

    private int _applyRuleRdfs5_2() throws SQLException {
        String query2 = "SELECT DISTINCT t1.subj, " + this._repository.rdfsSubPropertyOfId + ", " + "nt.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.subj = t1.obj AND " + "   t1.pred = " + this._repository.rdfsSubPropertyOfId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.obj = t2.obj AND " + "   t1.subj = t2.subj AND " + "   t2.pred = " + this._repository.rdfsSubPropertyOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfsSubPropertyOfId + " AND " + "   nt.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(8, query2);
    }

    private int _applyRuleRdfs6() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubPropertyOfId + ", " + "nt.subj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.subj = t.subj AND " + "   t.subj = t.obj AND " + "   t.pred = " + this._repository.rdfsSubPropertyOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfTypeId + " AND " + "   nt.obj = " + this._repository.rdfPropertyId + " AND " + "   t.subj IS NULL";
        return this._applyRule(9, query2);
    }

    private int _applyRuleRdfs7_1() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, t1.obj, nt.obj FROM newtriples nt LEFT JOIN triples t1 ON    nt.pred = t1.subj AND    t1.pred = " + this._repository.rdfsSubPropertyOfId + " " + "LEFT JOIN " + "resources" + " r ON " + "   r.id = t1.obj " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.subj = t2.subj AND " + "   nt.obj = t2.obj AND " + "   t1.obj = t2.pred " + "WHERE " + "   t1.obj > 0 AND r.namespace > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(10, query2);
    }

    private int _applyRuleRdfs7_2() throws SQLException {
        String query2 = "SELECT DISTINCT t1.subj, nt.obj, t1.obj FROM newtriples nt LEFT JOIN triples t1 ON    nt.subj = t1.pred LEFT JOIN resources r ON    r.id = nt.obj LEFT JOIN triples t2 ON    t1.subj = t2.subj AND    t1.obj = t2.obj AND    nt.obj = t2.pred WHERE    nt.pred = " + this._repository.rdfsSubPropertyOfId + " AND " + "   nt.obj > 0 AND r.namespace > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(11, query2);
    }

    private int _applyRuleRdfs8() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubClassOfId + ", " + this._repository.rdfsResourceId + " FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.subj = t.subj AND " + "   t.pred = " + this._repository.rdfsSubClassOfId + " AND " + "   t.obj = " + this._repository.rdfsResourceId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfTypeId + " AND " + "   nt.obj = " + this._repository.rdfsClassId + " AND " + "   t.subj IS NULL";
        return this._applyRule(12, query2);
    }

    private int _applyRuleRdfs9_1() throws SQLException {
        String query2 = "SELECT DISTINCT t1.subj, " + this._repository.rdfTypeId + ", " + "nt.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.subj = t1.obj AND " + "   t1.pred = " + this._repository.rdfTypeId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   t1.subj = t2.subj AND " + "   nt.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfTypeId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfsSubClassOfId + " AND " + "   nt.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(13, query2);
    }

    private int _applyRuleRdfs9_2() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfTypeId + ", " + "t1.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.obj = t1.subj AND " + "   t1.pred = " + this._repository.rdfsSubClassOfId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.subj = t2.subj AND " + "   t1.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfTypeId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfTypeId + " AND " + "   t1.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(14, query2);
    }

    private int _applyRuleRdfs10() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubClassOfId + ", " + "nt.subj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.subj = t.subj AND " + "   t.subj = t.obj AND " + "   t.pred = " + this._repository.rdfsSubClassOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfTypeId + " AND " + "   nt.obj = " + this._repository.rdfsClassId + " AND " + "   t.subj IS NULL";
        return this._applyRule(15, query2);
    }

    private int _applyRuleRdfs11_1() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubClassOfId + ", " + "t1.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.obj = t1.subj AND " + "   t1.pred = " + this._repository.rdfsSubClassOfId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   nt.subj = t2.subj AND " + "   t1.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfsSubClassOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfsSubClassOfId + " AND " + "   t1.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(16, query2);
    }

    private int _applyRuleRdfs11_2() throws SQLException {
        String query2 = "SELECT DISTINCT t1.subj, " + this._repository.rdfsSubClassOfId + ", " + "nt.obj " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t1 ON " + "   nt.subj = t1.obj AND " + "   t1.pred = " + this._repository.rdfsSubClassOfId + " " + "LEFT JOIN " + "triples" + " t2 ON " + "   t1.subj = t2.subj AND " + "   nt.obj = t2.obj AND " + "   t2.pred = " + this._repository.rdfsSubClassOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfsSubClassOfId + " AND " + "   nt.obj > 0 AND " + "   t2.subj IS NULL AND " + "   t1.subj IS NOT NULL";
        return this._applyRule(17, query2);
    }

    private int _applyRuleRdfs12() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubPropertyOfId + ", " + this._repository.rdfsMemberId + " FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.subj = t.subj AND " + "   t.obj = " + this._repository.rdfsMemberId + " AND " + "   t.pred = " + this._repository.rdfsSubPropertyOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfTypeId + " AND " + "   nt.obj = " + this._repository.rdfsContainerMembershipPropertyId + " AND " + "   t.subj IS NULL";
        return this._applyRule(18, query2);
    }

    private int _applyRuleRdfs13() throws SQLException {
        String query2 = "SELECT DISTINCT nt.subj, " + this._repository.rdfsSubClassOfId + ", " + this._repository.rdfsLiteralId + " FROM " + "newtriples" + " nt " + "LEFT JOIN " + "triples" + " t ON " + "   nt.subj = t.subj AND " + "   t.obj = " + this._repository.rdfsLiteralId + " AND " + "   t.pred = " + this._repository.rdfsSubClassOfId + " " + "WHERE " + "   nt.pred = " + this._repository.rdfTypeId + " AND " + "   nt.obj = " + this._repository.rdfsDatatypeId + " AND " + "   t.subj IS NULL";
        return this._applyRule(19, query2);
    }

    /*
     * WARNING - void declaration
     */
    private int _applyRuleX1() throws SQLException {
        void var2_2;
        String likePattern;
        int rdfNsId = this._repository._getNamespaceId("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        if (rdfNsId == 0) {
            return 0;
        }
        if (this._rdbms.getSearchStringEscape() != null) {
            likePattern = "'" + this._rdbms.getSearchStringEscape() + "_%' ";
        } else if (this._rdbms.supportsLikeEscapeClause()) {
            likePattern = "'\\_%' ESCAPE '\\' ";
        } else {
            throw new SQLException("Unable to create like pattern; no escape character available");
        }
        String query2 = "SELECT DISTINCT nt.pred, " + this._repository.rdfTypeId + ", " + this._repository.rdfsContainerMembershipPropertyId + " " + "FROM " + "newtriples" + " nt " + "LEFT JOIN " + "resources" + " r ON " + "nt.pred = r.id AND " + "r.namespace = " + rdfNsId + " AND " + "r.localname LIKE " + (String)var2_2 + "LEFT JOIN " + "triples" + " t ON " + "nt.pred = t.subj AND " + "t.pred = " + this._repository.rdfTypeId + " AND " + "t.obj = " + this._repository.rdfsContainerMembershipPropertyId + " " + "WHERE " + "r.id IS NOT NULL AND " + "t.subj IS NULL";
        return this._applyRule(20, query2);
    }

    private int _applyRule(int ruleNo, String query2) throws SQLException {
        if (!this._checkRule[ruleNo]) {
            return 0;
        }
        long startTime = System.currentTimeMillis();
        int nofInferred = 0;
        this._prepareInsertConnection();
        Connection queryCon = this._rdbms.getConnection();
        Statement querySt = queryCon.createStatement();
        ResultSet rs = querySt.executeQuery(query2);
        while (rs.next()) {
            this._insertSt.setInt(1, this._repository._getNextStatementId());
            this._insertSt.setInt(2, rs.getInt(1));
            this._insertSt.setInt(3, rs.getInt(2));
            this._insertSt.setInt(4, rs.getInt(3));
            this._insertSt.executeUpdate();
            ++nofInferred;
        }
        rs.close();
        querySt.close();
        queryCon.close();
        this._closeInsertConnection(nofInferred > 0);
        if (nofInferred > 0) {
            int n = ruleNo;
            this._ruleCount[n] = this._ruleCount[n] + nofInferred;
            this._rdbms.copyRows("inferred", "allinferred");
            this._rdbms.copyRows("inferred", "triples");
            this._rdbms.clearTable("inferred");
        }
        long endTime = System.currentTimeMillis();
        int n = ruleNo;
        this._ruleTime[n] = this._ruleTime[n] + (endTime - startTime);
        if (nofInferred > 0) {
            boolean[] triggers = TRIGGERS[ruleNo];
            for (int i = 0; i < 21; ++i) {
                if (!triggers[i]) continue;
                this._checkRuleNextIter[i] = true;
            }
        }
        return nofInferred;
    }
}

