/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.sesame.sailimpl.omm.security.ClassesOverSchemaRestriction;
import org.openrdf.sesame.sailimpl.omm.security.ClassesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.InstancesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.PatternRestriction;
import org.openrdf.sesame.sailimpl.omm.security.PropertiesRestriction;
import org.openrdf.sesame.sailimpl.omm.security.QueryRestriction;
import org.openrdf.sesame.sailimpl.omm.security.RepositoryRestriction;
import org.openrdf.sesame.sailimpl.omm.security.SchemaRestriction;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;

public abstract class Restriction {
    private static Set restrictions = new HashSet();
    public static final int REPOSITORY = 1;
    public static final int SCHEMA = 2;
    public static final int CLASSES = 3;
    public static final int INSTANCES = 4;
    public static final int PROPERTIES = 5;
    public static final int PATTERN = 6;
    public static final int QUERY = 7;
    public static final int CLASSES_OVER_SCHEMA = 8;
    public static final String REPOSITORY_RESTRICTION = "RepositoryRestriction";
    public static final String SCHEMA_RESTRICTION = "SchemaRestriction";
    public static final String CLASSES_RESTRICTION = "ClassesRestriction";
    public static final String INSTANCES_RESTRICTION = "InstancesRestriction";
    public static final String PROPERTIES_RESTRICTION = "PropertiesRestriction";
    public static final String PATTERN_RESTRICTION = "PatternRestriction";
    public static final String QUERY_RESTRICTION = "QueryRestriction";
    public static final String CLASSES_OVER_SCHEMA_RESTRICTION = "ClassesOverSchemaRestriction";
    private static int lastId = 0;
    int type;
    int id;
    String name = null;
    String description = null;
    private String uri = null;

    protected Restriction(int id, int kind, String name2, String desc) {
        this.id = id;
        this.type = kind;
        this.name = name2;
        this.description = desc;
        restrictions.add(this);
    }

    protected Restriction(int type) {
        this.type = type;
        this.id = ++lastId;
    }

    public static Restriction createRestriction(int type) {
        Restriction restr = null;
        switch (type) {
            case 1: {
                restr = new RepositoryRestriction(++lastId, "", "");
                break;
            }
            case 2: {
                restr = new SchemaRestriction(++lastId, "", "");
                break;
            }
            case 3: {
                restr = new ClassesRestriction(++lastId, "", "");
                break;
            }
            case 4: {
                restr = new InstancesRestriction(++lastId, "", "");
                break;
            }
            case 5: {
                restr = new PropertiesRestriction(++lastId, "", "");
                break;
            }
            case 6: {
                restr = new PatternRestriction(++lastId, "", "");
                break;
            }
            case 7: {
                restr = new QueryRestriction(++lastId, "", "");
                break;
            }
            case 8: {
                restr = new ClassesOverSchemaRestriction(++lastId, "", "");
            }
        }
        return restr;
    }

    public static Restriction createRestriction(int type, int id) {
        Restriction restr = null;
        switch (type) {
            case 1: {
                restr = new RepositoryRestriction(id, "", "");
                break;
            }
            case 2: {
                restr = new SchemaRestriction(id, "", "");
                break;
            }
            case 3: {
                restr = new ClassesRestriction(id, "", "");
                break;
            }
            case 4: {
                restr = new InstancesRestriction(id, "", "");
                break;
            }
            case 5: {
                restr = new PropertiesRestriction(id, "", "");
                break;
            }
            case 6: {
                restr = new PatternRestriction(id, "", "");
                break;
            }
            case 7: {
                restr = new QueryRestriction(id, "", "");
                break;
            }
            case 8: {
                restr = new ClassesOverSchemaRestriction(id, "", "");
            }
        }
        if (id > lastId) {
            lastId = id;
        }
        return restr;
    }

    public static Restriction createRepositoryRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new RepositoryRestriction(id, name2, descr);
    }

    public static Restriction createRepositoryRestriction(String name2, String descr) {
        return new RepositoryRestriction(++lastId, name2, descr);
    }

    public static Restriction createSchemaRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new SchemaRestriction(id, name2, descr);
    }

    public static Restriction createSchemaRestriction(String name2, String descr) {
        return new SchemaRestriction(++lastId, name2, descr);
    }

    public static Restriction createClassesRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new ClassesRestriction(id, name2, descr);
    }

    public static Restriction createClassesRestriction(String name2, String descr) {
        return new ClassesRestriction(++lastId, name2, descr);
    }

    public static Restriction createClassesOverSchemaRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new ClassesOverSchemaRestriction(id, name2, descr);
    }

    public static Restriction createClassesOverSchemaRestriction(String name2, String descr) {
        return new ClassesOverSchemaRestriction(++lastId, name2, descr);
    }

    public static Restriction createInstancesRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new InstancesRestriction(id, name2, descr);
    }

    public static Restriction createInstancesRestriction(String name2, String descr) {
        return new InstancesRestriction(++lastId, name2, descr);
    }

    public static Restriction createPropertiesRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new PropertiesRestriction(id, name2, descr);
    }

    public static Restriction createPropertiesRestriction(String name2, String descr) {
        return new PropertiesRestriction(++lastId, name2, descr);
    }

    public static Restriction createPatternRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new PatternRestriction(id, name2, descr);
    }

    public static Restriction createPatternRestriction(String name2, String descr) {
        return new PatternRestriction(++lastId, name2, descr);
    }

    public static Restriction createQueryRestriction(int id, String name2, String descr) {
        if (id > lastId) {
            lastId = id;
        }
        return new QueryRestriction(id, name2, descr);
    }

    public static Restriction createQueryRestriction(String name2, String descr) {
        return new QueryRestriction(++lastId, name2, descr);
    }

    public static Set getRestrictions() {
        return restrictions;
    }

    public static String type2String(int type) {
        String result2 = "" + type;
        switch (type) {
            case 1: {
                result2 = "Repository";
                break;
            }
            case 2: {
                result2 = "Schema";
                break;
            }
            case 3: {
                result2 = "Classes";
                break;
            }
            case 4: {
                result2 = "Instances";
                break;
            }
            case 5: {
                result2 = "Properties";
                break;
            }
            case 6: {
                result2 = "Pattern";
                break;
            }
            case 7: {
                result2 = "Query";
                break;
            }
            case 8: {
                result2 = "ClassesOverSchema";
            }
        }
        return result2 + "Restriction";
    }

    public static int type2Int(String type) {
        int result2 = 0;
        if (type.equals(REPOSITORY_RESTRICTION)) {
            result2 = 1;
        }
        if (type.equals(SCHEMA_RESTRICTION)) {
            result2 = 2;
        }
        if (type.equals(CLASSES_RESTRICTION)) {
            result2 = 3;
        }
        if (type.equals(INSTANCES_RESTRICTION)) {
            result2 = 4;
        }
        if (type.equals(PROPERTIES_RESTRICTION)) {
            result2 = 5;
        }
        if (type.equals(PATTERN_RESTRICTION)) {
            result2 = 6;
        }
        if (type.equals(QUERY_RESTRICTION)) {
            result2 = 7;
        }
        if (type.equals(CLASSES_OVER_SCHEMA_RESTRICTION)) {
            result2 = 8;
        }
        return result2;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException, SecurityException {
        if (idByRes == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        if (idByLiteral == null) {
            throw new NullParameterException("[ids by literals] map should not be [null].");
        }
        ArrayList<String> list2 = new ArrayList<String>(3);
        StringBuffer query2 = new StringBuffer();
        query2.append("INSERT INTO ");
        query2.append("restrictions");
        query2.append(" VALUES ");
        query2.append("(").append(this.id);
        query2.append(",");
        query2.append(this.type);
        query2.append(",'");
        query2.append(this.name);
        query2.append("','");
        query2.append(this.description).append("');");
        list2.add(query2.toString());
        return list2;
    }

    public void setUri(String uri2) {
        this.uri = uri2;
    }

    public String getUri() {
        return this.uri;
    }
}

