/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;

public class ResourceRestriction
extends Restriction {
    Set resources = new HashSet();

    public ResourceRestriction(int id, int type, String name2, String descr) {
        super(id, type, name2, descr);
    }

    public Set getResources() {
        return this.resources;
    }

    public void setResources(Set resources) throws NullParameterException {
        if (null == resources) {
            throw new NullParameterException("[resources] should not be [null].");
        }
        this.resources = resources;
    }

    public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException, SecurityException {
        if (idByRes == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        if (idByLiteral == null) {
            throw new NullParameterException("[ids by literals] map should not be [null].");
        }
        ArrayList list2 = super.toSql(idByLiteral, idByRes);
        ArrayList resourcez = new ArrayList(this.resources);
        for (int ri = 0; ri < resourcez.size(); ++ri) {
            Resource res = null;
            res = (Resource)resourcez.get(ri);
            Integer i = (Integer)idByRes.get(res);
            if (i == null && (i = (Integer)idByLiteral.get(res)) == null) {
                throw new SecurityException("Id not found for resource/literal : \n" + res);
            }
            int rid = i;
            StringBuffer query2 = new StringBuffer();
            query2.append("INSERT INTO ");
            query2.append("res_propr_restrs");
            query2.append(" VALUES ");
            query2.append("(").append(this.id);
            query2.append(",");
            query2.append(rid).append(");");
            list2.add(query2.toString());
        }
        return list2;
    }
}

