/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;
import org.openrdf.sesame.sailimpl.omm.security.Restriction;
import org.openrdf.sesame.sailimpl.omm.security.SecurityException;

public class PropertiesRestriction
extends Restriction {
    Set properties = new HashSet();

    public PropertiesRestriction(int id, String name2, String descr) {
        super(id, 5, name2, descr);
    }

    public Set getProperties() {
        return this.properties;
    }

    public void setProperties(Set properties) throws NullParameterException {
        if (null == properties) {
            throw new NullParameterException("[properties] should not be [null].");
        }
        this.properties = properties;
    }

    public ArrayList toSql(Map idByLiteral, Map idByRes) throws NullParameterException, SecurityException {
        if (idByRes == null) {
            throw new NullParameterException("[ids by resources] map should not be [null].");
        }
        if (idByLiteral == null) {
            throw new NullParameterException("[ids by literals] map should not be [null].");
        }
        ArrayList list2 = super.toSql(idByLiteral, idByRes);
        ArrayList propz = new ArrayList(this.properties);
        for (int pi = 0; pi < propz.size(); ++pi) {
            Resource res = (Resource)propz.get(pi);
            Integer i = (Integer)idByRes.get(res);
            if (i == null) {
                throw new SecurityException("Id not found for resource : \n" + res);
            }
            int pid = i;
            StringBuffer query2 = new StringBuffer();
            query2.append("INSERT INTO ");
            query2.append("res_propr_restrs");
            query2.append(" VALUES ");
            query2.append("(").append(this.id);
            query2.append(",");
            query2.append(pid).append(");");
            list2.add(query2.toString());
        }
        return list2;
    }
}

