/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf.model;

import org.openrdf.model.BNode;
import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.nativerdf.NativeRdfRepository;
import org.openrdf.sesame.sailimpl.nativerdf.ValueStoreRevision;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeResource;

public class NativeBNode
extends BNodeImpl
implements NativeResource {
    private transient NativeRdfRepository _repository;
    private transient ValueStoreRevision _revision;
    private transient int _id;

    public NativeBNode(NativeRdfRepository repository, String nodeID) {
        super(nodeID);
        this._repository = repository;
    }

    public NativeBNode(NativeRdfRepository repository, BNode bnode) {
        this(repository, bnode.getID());
    }

    public NativeRdfRepository getRepository() {
        return this._repository;
    }

    public void setInternalId(int id, ValueStoreRevision revision) {
        this._id = id;
        this._revision = revision;
    }

    public int getInternalId() {
        return this._id;
    }

    public ValueStoreRevision getValueStoreRevision() {
        return this._revision;
    }

    public StatementIterator getSubjectStatements() throws GraphException {
        if (this._repository == null) {
            throw new GraphException("no backing store associated");
        }
        return this._repository.getStatements(this, null, null);
    }

    public StatementIterator getObjectStatements() throws GraphException {
        if (this._repository == null) {
            throw new GraphException("no backing store associated");
        }
        return this._repository.getStatements(null, null, this);
    }

    public void addProperty(URI property, Value value2) throws GraphException {
        if (this._repository == null) {
            throw new GraphException("no backing store associated");
        }
        this._repository.startTransaction();
        try {
            this._repository.addStatement(this, property, value2);
        }
        catch (SailUpdateException e) {
            throw new GraphException(e);
        }
        finally {
            this._repository.commitTransaction();
        }
    }
}

