/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.sesame.sailimpl.nativerdf.NamespaceStore;
import org.openrdf.sesame.sailimpl.nativerdf.NativeRdfRepository;
import org.openrdf.sesame.sailimpl.nativerdf.ValueStoreRevision;
import org.openrdf.sesame.sailimpl.nativerdf.datastore.DataStore;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeBNode;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeLiteral;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeURI;
import org.openrdf.sesame.sailimpl.nativerdf.model.NativeValue;
import org.openrdf.util.ByteArrayUtil;

public class ValueStore
implements ValueFactory {
    private static final String FILENAME_PREFIX = "values";
    private static final int VALUE_CACHE_SIZE = 256;
    private static final int ID_CACHE_SIZE = 256;
    private static final byte VALUE_TYPE_MASK = 3;
    private static final byte URI_VALUE = 1;
    private static final byte BNODE_VALUE = 2;
    private static final byte LITERAL_VALUE = 3;
    private DataStore _dataStore;
    private NamespaceStore _namespaceStore;
    private NativeRdfRepository _repository;
    private ValueStoreRevision _revision;
    private LinkedHashMap _valueCache;
    private LinkedHashMap _idCache;
    private String _bnodePrefix;
    private int _nextBNodeID;

    public ValueStore(File dataDir, NamespaceStore namespaceStore, NativeRdfRepository repository) throws IOException {
        this._dataStore = new DataStore(dataDir, FILENAME_PREFIX);
        this._namespaceStore = namespaceStore;
        this._repository = repository;
        this._valueCache = new LinkedHashMap(256, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 256;
            }
        };
        this._idCache = new LinkedHashMap(256, 0.75f, true){

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 256;
            }
        };
        this._updateBNodePrefix();
        this._setNewRevision();
    }

    private void _updateBNodePrefix() {
        this._bnodePrefix = "node" + Long.toString(System.currentTimeMillis(), 32) + "x";
        this._nextBNodeID = 1;
    }

    private void _setNewRevision() {
        this._revision = new ValueStoreRevision(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(int id) throws IOException {
        byte[] data2;
        NativeValue resultValue = null;
        Integer cacheID = new Integer(id);
        LinkedHashMap linkedHashMap = this._valueCache;
        synchronized (linkedHashMap) {
            resultValue = (NativeValue)this._valueCache.get(cacheID);
        }
        if (resultValue == null && (data2 = this._dataStore.getData(id)) != null) {
            resultValue = this._data2value(id, data2);
            LinkedHashMap linkedHashMap2 = this._valueCache;
            synchronized (linkedHashMap2) {
                this._valueCache.put(cacheID, resultValue);
            }
        }
        return resultValue;
    }

    public int getID(Value value2) throws IOException {
        return this.getID(value2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID(Value value2, boolean dirtyReads) throws IOException {
        NativeValue nativeValue;
        boolean isOwnValue = this._isOwnValue(value2);
        if (isOwnValue && this._revision.equals((nativeValue = (NativeValue)value2).getValueStoreRevision())) {
            return nativeValue.getInternalId();
        }
        Integer cachedID = null;
        LinkedHashMap linkedHashMap = this._idCache;
        synchronized (linkedHashMap) {
            cachedID = (Integer)this._idCache.get(value2);
        }
        if (cachedID != null) {
            int id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value2).setInternalId(id, this._revision);
            }
            return id;
        }
        byte[] data2 = this._value2data(value2, dirtyReads, false);
        if (data2 != null) {
            int id = this._dataStore.getID(data2, dirtyReads);
            if (id != 0) {
                if (isOwnValue) {
                    ((NativeValue)value2).setInternalId(id, this._revision);
                } else {
                    LinkedHashMap linkedHashMap2 = this._idCache;
                    synchronized (linkedHashMap2) {
                        this._idCache.put(value2, new Integer(id));
                    }
                }
            }
            return id;
        }
        return 0;
    }

    public void startTransaction() throws IOException {
        this._namespaceStore.startTransaction();
        this._dataStore.startTransaction();
    }

    public void commitTransaction() throws IOException {
        this._dataStore.commitTransaction();
        this._namespaceStore.commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() throws IOException {
        LinkedHashMap linkedHashMap = this._idCache;
        synchronized (linkedHashMap) {
            this._idCache.clear();
        }
        this._dataStore.rollbackTransaction();
        this._namespaceStore.rollbackTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int storeValue(Value value2) throws IOException {
        NativeValue nativeValue;
        boolean isOwnValue = this._isOwnValue(value2);
        if (isOwnValue && this._revision.equals((nativeValue = (NativeValue)value2).getValueStoreRevision())) {
            return nativeValue.getInternalId();
        }
        Integer cachedID = null;
        LinkedHashMap linkedHashMap = this._idCache;
        synchronized (linkedHashMap) {
            cachedID = (Integer)this._idCache.get(value2);
        }
        if (cachedID != null) {
            int id = cachedID;
            if (isOwnValue) {
                ((NativeValue)value2).setInternalId(id, this._revision);
            }
            return id;
        }
        byte[] valueData = this._value2data(value2, true, true);
        int id = this._dataStore.storeData(valueData);
        if (isOwnValue) {
            ((NativeValue)value2).setInternalId(id, this._revision);
        } else {
            LinkedHashMap linkedHashMap2 = this._idCache;
            synchronized (linkedHashMap2) {
                this._idCache.put(value2, new Integer(id));
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        this._dataStore.clear();
        this._namespaceStore.clear();
        LinkedHashMap linkedHashMap = this._valueCache;
        synchronized (linkedHashMap) {
            this._valueCache.clear();
        }
        linkedHashMap = this._idCache;
        synchronized (linkedHashMap) {
            this._idCache.clear();
        }
        this._nextBNodeID = 1;
        this._setNewRevision();
    }

    public void close() throws IOException {
        this._dataStore.close();
        this._namespaceStore.close();
        this._valueCache = null;
        this._idCache = null;
        this._repository = null;
    }

    private boolean _isOwnValue(Value value2) {
        return value2 instanceof NativeValue && ((NativeValue)value2).getRepository() == this._repository;
    }

    private byte[] _value2data(Value value2, boolean dirtyReads, boolean create2) throws IOException {
        if (value2 instanceof URI) {
            return this._uri2data((URI)value2, dirtyReads, create2);
        }
        if (value2 instanceof BNode) {
            return this._bnode2data((BNode)value2, dirtyReads, create2);
        }
        if (value2 instanceof Literal) {
            return this._literal2data((Literal)value2, dirtyReads, create2);
        }
        throw new IllegalArgumentException("value parameter should be a URI, BNode or Literal");
    }

    private byte[] _uri2data(URI uri2, boolean dirtyReads, boolean create2) throws IOException {
        int nsID = this._namespaceStore.getID(uri2.getNamespace(), dirtyReads);
        if (nsID == 0) {
            if (create2) {
                nsID = this._namespaceStore.storeNamespace(uri2.getNamespace());
            } else {
                return null;
            }
        }
        byte[] localNameData = uri2.getLocalName().getBytes("UTF-8");
        byte[] uriData = new byte[5 + localNameData.length];
        uriData[0] = 1;
        ByteArrayUtil.putInt((int)nsID, (byte[])uriData, (int)1);
        ByteArrayUtil.put((byte[])localNameData, (byte[])uriData, (int)5);
        return uriData;
    }

    private byte[] _bnode2data(BNode bNode, boolean dirtyReads, boolean create2) throws IOException {
        byte[] idData = bNode.getID().getBytes("UTF-8");
        byte[] bNodeData = new byte[1 + idData.length];
        bNodeData[0] = 2;
        ByteArrayUtil.put((byte[])idData, (byte[])bNodeData, (int)1);
        return bNodeData;
    }

    private byte[] _literal2data(Literal literal, boolean dirtyReads, boolean create2) throws IOException {
        int datatypeID = 0;
        if (literal.getDatatype() != null) {
            if (create2) {
                datatypeID = this.storeValue(literal.getDatatype());
            } else {
                datatypeID = this.getID(literal.getDatatype(), dirtyReads);
                if (datatypeID == 0) {
                    return null;
                }
            }
        }
        byte[] langData = null;
        int langDataLength = 0;
        if (literal.getLanguage() != null) {
            langData = literal.getLanguage().getBytes("UTF-8");
            langDataLength = langData.length;
        }
        byte[] labelData = literal.getLabel().getBytes("UTF-8");
        byte[] literalData = new byte[6 + langDataLength + labelData.length];
        literalData[0] = 3;
        ByteArrayUtil.putInt((int)datatypeID, (byte[])literalData, (int)1);
        literalData[5] = (byte)langDataLength;
        if (langData != null) {
            ByteArrayUtil.put((byte[])langData, (byte[])literalData, (int)6);
        }
        ByteArrayUtil.put((byte[])labelData, (byte[])literalData, (int)(6 + langDataLength));
        return literalData;
    }

    /*
     * WARNING - void declaration
     */
    private NativeValue _data2value(int id, byte[] data2) throws IOException {
        void var3_3;
        switch (data2[0] & 3) {
            case 1: {
                NativeValue nativeValue = this._data2uri(data2);
                break;
            }
            case 2: {
                NativeValue nativeValue = this._data2bnode(data2);
                break;
            }
            case 3: {
                NativeValue nativeValue = this._data2literal(data2);
                break;
            }
            default: {
                throw new IllegalArgumentException("data does not specify a known value type");
            }
        }
        var3_3.setInternalId(id, this._revision);
        return var3_3;
    }

    private NativeURI _data2uri(byte[] data2) throws IOException {
        int nsID = ByteArrayUtil.getInt((byte[])data2, (int)1);
        String namespace = this._namespaceStore.getNamespaceName(nsID);
        String localName = new String(data2, 5, data2.length - 5, "UTF-8");
        return new NativeURI(this._repository, namespace, localName);
    }

    private NativeBNode _data2bnode(byte[] data2) throws IOException {
        String nodeID = new String(data2, 1, data2.length - 1, "UTF-8");
        return new NativeBNode(this._repository, nodeID);
    }

    private NativeLiteral _data2literal(byte[] data2) throws IOException {
        int datatypeID = ByteArrayUtil.getInt((byte[])data2, (int)1);
        URI datatype = null;
        if (datatypeID != 0) {
            datatype = (URI)this.getValue(datatypeID);
        }
        String lang = null;
        byte langLength = data2[5];
        if (langLength > 0) {
            lang = new String(data2, 6, (int)langLength, "UTF-8");
        }
        String label = new String(data2, 6 + langLength, data2.length - 6 - langLength, "UTF-8");
        if (datatype != null) {
            return new NativeLiteral(this._repository, label, datatype);
        }
        if (lang != null) {
            return new NativeLiteral(this._repository, label, lang);
        }
        return new NativeLiteral(this._repository, label);
    }

    public URI createURI(String uri2) {
        return new NativeURI(this._repository, uri2);
    }

    public URI createURI(String namespace, String localName) {
        return new NativeURI(this._repository, namespace, localName);
    }

    public BNode createBNode() {
        if (this._nextBNodeID == Integer.MAX_VALUE) {
            this._updateBNodePrefix();
        }
        return this.createBNode(this._bnodePrefix + this._nextBNodeID++);
    }

    public BNode createBNode(String nodeId) {
        return new NativeBNode(this._repository, nodeId);
    }

    public Literal createLiteral(String value2) {
        return new NativeLiteral(this._repository, value2);
    }

    public Literal createLiteral(String value2, String language2) {
        return new NativeLiteral(this._repository, value2, language2);
    }

    public Literal createLiteral(String value2, URI datatype) {
        return new NativeLiteral(this._repository, value2, datatype);
    }

    public Statement createStatement(Resource subject, URI predicate, Value object) {
        return new StatementImpl(subject, predicate, object);
    }

    public static void main(String[] args) throws Exception {
        File dataDir = new File(args[0]);
        NamespaceStore namespaceStore = new NamespaceStore(dataDir);
        ValueStore valueStore = new ValueStore(dataDir, namespaceStore, null);
        int maxID = valueStore._dataStore.getMaxID();
        for (int id = 1; id <= maxID; ++id) {
            Value value2 = valueStore.getValue(id);
            System.out.println("ID " + id + " : " + value2.toString());
        }
    }
}

