/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.GraphException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;
import org.openrdf.sesame.sailimpl.memory.MemStatementIterator;
import org.openrdf.sesame.sailimpl.memory.RdfRepository;
import org.openrdf.sesame.sailimpl.memory.RdfSchemaRepository;
import org.openrdf.sesame.sailimpl.memory.RdfSource;
import org.openrdf.sesame.sailimpl.memory.ResourceNode;
import org.openrdf.sesame.sailimpl.memory.StatementList;

public class URINode
extends URIImpl
implements ResourceNode {
    protected transient RdfSource _source;
    protected transient StatementList _subjectStatements;
    protected transient StatementList _predicateStatements;
    protected transient StatementList _objectStatements;
    protected transient StatementList _directTypeStatements;
    protected transient StatementList _directSubClassStatements;
    protected transient StatementList _directSubPropertyStatements;

    URINode(RdfSource source, String namespace, String localName) {
        super(namespace, localName);
        this._source = source;
    }

    URINode(RdfSource source, String uri2) {
        super(uri2);
        this._source = source;
    }

    public StatementList getSubjectStatementList() {
        if (this._subjectStatements == null) {
            return EMPTY_LIST;
        }
        return this._subjectStatements;
    }

    public StatementIterator getSubjectStatements() {
        if (this._subjectStatements == null) {
            return new EmptyStatementIterator();
        }
        return new MemStatementIterator(this._subjectStatements);
    }

    public int getSubjectStatementCount() {
        if (this._subjectStatements == null) {
            return 0;
        }
        return this._subjectStatements.size();
    }

    public void addSubjectStatement(Statement st) {
        if (this._subjectStatements == null) {
            this._subjectStatements = new StatementList(4);
        }
        this._subjectStatements.add(st);
    }

    public void removeSubjectStatement(Statement st) {
        this._subjectStatements.remove(st);
        if (this._subjectStatements.isEmpty()) {
            this._subjectStatements = null;
        }
    }

    public StatementList getPredicateStatementList() {
        if (this._predicateStatements == null) {
            return EMPTY_LIST;
        }
        return this._predicateStatements;
    }

    public StatementIterator getPredicateStatements() {
        if (this._predicateStatements == null) {
            return new EmptyStatementIterator();
        }
        return new MemStatementIterator(this._predicateStatements);
    }

    public int getPredicateStatementCount() {
        if (this._predicateStatements == null) {
            return 0;
        }
        return this._predicateStatements.size();
    }

    public void addPredicateStatement(Statement st) {
        if (this._predicateStatements == null) {
            this._predicateStatements = new StatementList(4);
        }
        this._predicateStatements.add(st);
    }

    public void removePredicateStatement(Statement st) {
        this._predicateStatements.remove(st);
        if (this._predicateStatements.isEmpty()) {
            this._predicateStatements = null;
        }
    }

    public StatementList getObjectStatementList() {
        if (this._objectStatements == null) {
            return EMPTY_LIST;
        }
        return this._objectStatements;
    }

    public StatementIterator getObjectStatements() {
        if (this._objectStatements == null) {
            return new EmptyStatementIterator();
        }
        return new MemStatementIterator(this._objectStatements);
    }

    public int getObjectStatementCount() {
        if (this._objectStatements == null) {
            return 0;
        }
        return this._objectStatements.size();
    }

    public void addObjectStatement(Statement st) {
        if (this._objectStatements == null) {
            this._objectStatements = new StatementList(4);
        }
        this._objectStatements.add(st);
    }

    public void removeObjectStatement(Statement st) {
        this._objectStatements.remove(st);
        if (this._objectStatements.isEmpty()) {
            this._objectStatements = null;
        }
    }

    public RdfSource getRdfSource() {
        return this._source;
    }

    public void addProperty(URI property, Value value2) throws GraphException {
        if (this._source instanceof RdfRepository) {
            RdfRepository rep2 = (RdfRepository)this._source;
            rep2.startTransaction();
            try {
                rep2.addStatement(this, property, value2);
            }
            catch (SailUpdateException e) {
                throw new GraphException(e);
            }
            finally {
                rep2.commitTransaction();
            }
        } else {
            throw new GraphException("source not writable");
        }
    }

    public StatementIterator getDirectSubClassStatements() {
        if (this._directSubClassStatements == null) {
            this._directSubClassStatements = new StatementList();
            RdfSchemaRepository repository = (RdfSchemaRepository)this._source;
            StatementIterator subClassOfIter = repository.getSubClassOf(null, this);
            ArrayList<Resource> subClasses = new ArrayList<Resource>();
            while (subClassOfIter.hasNext()) {
                Statement st = subClassOfIter.next();
                if (repository.isSubClassOf(this, st.getSubject())) continue;
                subClasses.add(st.getSubject());
            }
            subClassOfIter.close();
            subClassOfIter = repository.getSubClassOf(null, this);
            while (subClassOfIter.hasNext()) {
                Statement stat = subClassOfIter.next();
                if (!this._isDirectSubClassStat(stat, subClasses)) continue;
                this._directSubClassStatements.add(stat);
            }
        }
        return new MemStatementIterator(this._directSubClassStatements);
    }

    public boolean isDirectSubClass(Resource aClass) {
        boolean result2 = false;
        StatementIterator subClasses = this.getDirectSubClassStatements();
        while (subClasses.hasNext()) {
            Statement st = subClasses.next();
            if (!st.getSubject().equals(aClass)) continue;
            result2 = true;
            break;
        }
        subClasses.close();
        return result2;
    }

    private boolean _isDirectSubClassStat(Statement stat, List subClasses) {
        RdfSchemaRepository repository = (RdfSchemaRepository)this._source;
        ResourceNode subNode = (ResourceNode)stat.getSubject();
        if (subNode == this) {
            return false;
        }
        if (repository.isSubClassOf(this, subNode)) {
            return false;
        }
        boolean isDirect = true;
        StatementIterator supsOfSubClassIter = repository.getSubClassOf(subNode, null);
        while (supsOfSubClassIter.hasNext()) {
            Resource r;
            Statement st = supsOfSubClassIter.next();
            if (!(st.getObject() instanceof Resource) || (r = (Resource)st.getObject()) == subNode || r == this || !subClasses.contains(r) || repository.isSubClassOf(r, subNode)) continue;
            isDirect = false;
            break;
        }
        supsOfSubClassIter.close();
        return isDirect;
    }

    public StatementIterator getDirectTypeStatements() {
        if (this._directTypeStatements == null) {
            RdfSchemaRepository repository = (RdfSchemaRepository)this._source;
            this._directTypeStatements = new StatementList();
            StatementList typeStatements = new StatementList();
            ArrayList<Value> classes = new ArrayList<Value>();
            StatementIterator iter2 = repository.getStatements(this, repository.RDF_TYPE_NODE, null, false);
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                if (!((Object)st.getPredicate()).equals(repository.RDF_TYPE_NODE)) continue;
                typeStatements.add(st);
                classes.add(st.getObject());
            }
            iter2.close();
            MemStatementIterator typeIter = new MemStatementIterator(typeStatements);
            Statement rdfsResourceStatement = null;
            while (typeIter.hasNext()) {
                Statement typeSt = typeIter.next();
                ResourceNode type = (ResourceNode)typeSt.getObject();
                if (type.equals(repository.RDFS_RESOURCE_NODE)) {
                    rdfsResourceStatement = typeSt;
                    continue;
                }
                StatementIterator subClassIter = type.getDirectSubClassStatements();
                boolean directType = true;
                while (directType && subClassIter.hasNext()) {
                    Resource aClass = subClassIter.next().getSubject();
                    if (!classes.contains(aClass)) continue;
                    directType = false;
                }
                if (!directType) continue;
                this._directTypeStatements.add(typeSt);
            }
            typeIter.close();
            if (this._directTypeStatements.size() == 0) {
                this._directTypeStatements.add(rdfsResourceStatement);
            }
        }
        return new MemStatementIterator(this._directTypeStatements);
    }

    public boolean isDirectType(Resource aClass) {
        boolean result2 = false;
        StatementIterator directTypes = this.getDirectTypeStatements();
        while (directTypes.hasNext()) {
            Statement st = directTypes.next();
            if (!st.getObject().equals(aClass)) continue;
            result2 = true;
            break;
        }
        directTypes.close();
        return result2;
    }

    public StatementIterator getDirectSubPropertyStatements() {
        if (this._directSubPropertyStatements == null) {
            this._directSubPropertyStatements = new StatementList();
            RdfSchemaRepository repository = (RdfSchemaRepository)this._source;
            StatementIterator subPropertyOfIter = repository.getSubPropertyOf(null, this);
            ArrayList<Resource> subProps = new ArrayList<Resource>();
            while (subPropertyOfIter.hasNext()) {
                Statement st = subPropertyOfIter.next();
                if (repository.isSubPropertyOf(this, st.getSubject())) continue;
                subProps.add(st.getSubject());
            }
            subPropertyOfIter.close();
            subPropertyOfIter = repository.getSubPropertyOf(null, this);
            while (subPropertyOfIter.hasNext()) {
                Statement stat = subPropertyOfIter.next();
                if (!this._isDirectSubPropertyStat(stat, subProps)) continue;
                this._directSubPropertyStatements.add(stat);
            }
        }
        return new MemStatementIterator(this._directSubPropertyStatements);
    }

    public boolean isDirectSubProperty(Resource aProperty) {
        boolean result2 = false;
        StatementIterator subProps = this.getDirectSubPropertyStatements();
        while (subProps.hasNext()) {
            Statement st = subProps.next();
            if (!st.getSubject().equals(aProperty)) continue;
            result2 = true;
            break;
        }
        subProps.close();
        return result2;
    }

    private boolean _isDirectSubPropertyStat(Statement stat, List subProps) {
        RdfSchemaRepository repository = (RdfSchemaRepository)this._source;
        ResourceNode subNode = (ResourceNode)stat.getSubject();
        if (subNode == this) {
            return false;
        }
        if (repository.isSubPropertyOf(this, subNode)) {
            return false;
        }
        boolean isDirect = true;
        StatementIterator supsOfSubPropIter = repository.getSubPropertyOf(subNode, null);
        while (supsOfSubPropIter.hasNext()) {
            Resource r;
            Statement st = supsOfSubPropIter.next();
            if (!(st.getObject() instanceof Resource) || (r = (Resource)st.getObject()) == subNode || r == this || !subProps.contains(r) || repository.isSubPropertyOf(r, subNode)) continue;
            isDirect = false;
            break;
        }
        supsOfSubPropIter.close();
        return isDirect;
    }

    public void clearCache() {
        this._directSubClassStatements = null;
        this._directTypeStatements = null;
        this._directSubPropertyStatements = null;
    }
}

