/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.memory;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.LiteralIterator;

public class MemLiteralIterator
implements LiteralIterator {
    private Iterator _iter;
    private String _label;
    private String _language;
    private URI _datatype;
    private Literal _nextLiteral;

    public MemLiteralIterator(Collection literals) {
        this(literals, null, null, null);
    }

    public MemLiteralIterator(Collection literals, String label, String language2, URI datatype) {
        this._iter = literals.iterator();
        this._label = label;
        this._language = language2;
        this._datatype = datatype;
        this._findNextLiteral();
    }

    private void _findNextLiteral() {
        if (this._iter != null) {
            while (this._iter.hasNext()) {
                this._nextLiteral = (Literal)this._iter.next();
                boolean matchesPattern = !(this._label != null && !this._label.equals(this._nextLiteral.getLabel()) || this._language != null && !this._language.equals(this._nextLiteral.getLanguage()) || this._datatype != null && !((Object)this._datatype).equals(this._nextLiteral.getDatatype()));
                if (!matchesPattern) continue;
                return;
            }
        }
        this._nextLiteral = null;
    }

    public boolean hasNext() {
        return this._nextLiteral != null;
    }

    public Value next() {
        return this.nextLiteral();
    }

    public Literal nextLiteral() {
        if (this._nextLiteral != null) {
            Literal result2 = this._nextLiteral;
            this._findNextLiteral();
            return result2;
        }
        throw new NoSuchElementException("No more objects in iterator");
    }

    public void close() {
        this._iter = null;
        this._nextLiteral = null;
    }
}

