/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;

public class DirectSubClassOf
extends TriplePattern {
    private static final Var PREDICATE_VAR = new Var("_directSubClassOf", URIImpl.RDFS_SUBCLASSOF);

    public DirectSubClassOf(Var subjectVar, Var objectVar) {
        super(subjectVar, PREDICATE_VAR, objectVar);
    }

    protected StatementIterator _getStatementIterator(RdfSource rdfSource, Resource subj, URI pred, Value obj) throws SailQueryException {
        try {
            RdfSchemaSource rss = (RdfSchemaSource)rdfSource;
            if (obj == null || obj instanceof Resource) {
                return rss.getDirectSubClassOf(subj, (Resource)obj);
            }
            return new EmptyStatementIterator();
        }
        catch (ClassCastException e) {
            throw new SailQueryException("Cannot evaluate directSubClassOf on a non-inferencing repository");
        }
    }

    public void getVariables(Collection variables) {
        variables.add(this.getSubjectVar());
        variables.add(this.getObjectVar());
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(128);
        result2.append("(");
        if (this.getSubjectVar().hasValue()) {
            result2.append(this.getSubjectVar().getString());
        } else {
            result2.append(this.getSubjectVar().toString());
        }
        result2.append(",");
        result2.append("serql:directSubClassOf");
        result2.append(",");
        if (this.getObjectVar().hasValue()) {
            result2.append(this.getObjectVar().getString());
        } else {
            result2.append(this.getObjectVar().toString());
        }
        result2.append(")");
        return result2.toString();
    }
}

