/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.repository.remote;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.NamespaceListener;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseException;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.AdminMsgCollector;
import org.openrdf.sesame.admin.XmlAdminMsgReader;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.QueryResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.BinaryTableResultReader;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsGraphBuilder;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.query.QueryResultsTableBuilder;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.XmlQueryResultReader;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.repository.remote.HTTPService;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.util.http.CookieManager;
import org.openrdf.util.http.HttpClientUtil;
import org.openrdf.util.io.IOUtil;
import org.openrdf.util.xml.XMLReaderFactory;
import org.xml.sax.SAXException;

public class HTTPRepository
implements SesameRepository {
    private static final String TABLE_QUERY_SERVLET = "servlets/evaluateTableQuery";
    private static final String GRAPH_QUERY_SERVLET = "servlets/evaluateGraphQuery";
    private static final String DATA_UPLOAD_SERVLET = "servlets/uploadData";
    private static final String DATA_MERGE_SERVLET = "servlets/mergeData";
    private static final String URL_UPLOAD_SERVLET = "servlets/uploadURL";
    private static final String GRAPH_QUERY_ADD_SERVLET = "servlets/addGraphQuery";
    private static final String GRAPH_QUERY_MERGE_SERVLET = "servlets/mergeGraphQuery";
    private static final String GRAPH_QUERY_REMOVE_SERVLET = "servlets/removeGraphQuery";
    private static final String REMOVE_STATS_SERVLET = "servlets/removeStatements";
    private static final String CLEAR_SERVLET = "servlets/clearRepository";
    private static final String EXTRACT_SERVLET = "servlets/extractRDF";
    private String _repositoryId;
    private QueryResultFormat _tableQueryResultFormat = QueryResultFormat.XML;
    private RDFFormat _graphQueryResultFormat = RDFFormat.RDFXML;
    private CookieManager _cookieManager;
    private URL _tableQueryURL;
    private URL _graphQueryURL;
    private URL _dataUploadURL;
    private URL _urlUploadURL;
    private URL _dataMergeURL;
    private URL _removeStatsURL;
    private URL _clearURL;
    private URL _extractURL;
    private URL _addGraphQueryURL;
    private URL _mergeGraphQueryURL;
    private URL _removeGraphQueryURL;

    protected HTTPRepository(URL serverURL, String repositoryId, CookieManager cookieManager) throws MalformedURLException {
        this._repositoryId = repositoryId;
        this._cookieManager = cookieManager;
        this._tableQueryURL = HTTPService.resolveURL(serverURL, TABLE_QUERY_SERVLET);
        this._graphQueryURL = HTTPService.resolveURL(serverURL, GRAPH_QUERY_SERVLET);
        this._dataUploadURL = HTTPService.resolveURL(serverURL, DATA_UPLOAD_SERVLET);
        this._dataMergeURL = HTTPService.resolveURL(serverURL, DATA_MERGE_SERVLET);
        this._urlUploadURL = HTTPService.resolveURL(serverURL, URL_UPLOAD_SERVLET);
        this._removeStatsURL = HTTPService.resolveURL(serverURL, REMOVE_STATS_SERVLET);
        this._clearURL = HTTPService.resolveURL(serverURL, CLEAR_SERVLET);
        this._extractURL = HTTPService.resolveURL(serverURL, EXTRACT_SERVLET);
        this._addGraphQueryURL = HTTPService.resolveURL(serverURL, GRAPH_QUERY_ADD_SERVLET);
        this._mergeGraphQueryURL = HTTPService.resolveURL(serverURL, GRAPH_QUERY_MERGE_SERVLET);
        this._removeGraphQueryURL = HTTPService.resolveURL(serverURL, GRAPH_QUERY_REMOVE_SERVLET);
    }

    public void setTableQueryResultFormat(QueryResultFormat format2) {
        this._tableQueryResultFormat = format2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTableQuery(QueryLanguage language2, String query2, TableQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        block7: {
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("repository", this._repositoryId);
            postParams.put("query", query2);
            postParams.put("queryLanguage", language2.toString());
            postParams.put("resultFormat", this._tableQueryResultFormat.toString());
            InputStream resultStream = this._sendPostRequest(this._tableQueryURL, postParams);
            try {
                if (this._tableQueryResultFormat == QueryResultFormat.XML) {
                    try {
                        XmlQueryResultReader xmlReader = new XmlQueryResultReader(XMLReaderFactory.createXMLReader());
                        xmlReader.read(resultStream, listener);
                    }
                    catch (SAXException e) {
                        Exception wrappedExc = e.getException();
                        String msg = wrappedExc != null ? wrappedExc.getMessage() : e.getMessage();
                        this._throwIOException("Unable to parse query results from Sesame: " + msg, e);
                    }
                    break block7;
                }
                if (this._tableQueryResultFormat == QueryResultFormat.BINARY) {
                    BinaryTableResultReader binReader = new BinaryTableResultReader();
                    binReader.read(resultStream, listener);
                    break block7;
                }
                throw new RuntimeException("Unsupported table query result format: " + this._tableQueryResultFormat.toString());
            }
            finally {
                resultStream.close();
            }
        }
    }

    public QueryResultsTable performTableQuery(QueryLanguage language2, String query2) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        QueryResultsTableBuilder tableBuilder = new QueryResultsTableBuilder();
        this.performTableQuery(language2, query2, tableBuilder);
        return tableBuilder.getQueryResultsTable();
    }

    public void setGraphQueryResultFormat(RDFFormat format2) {
        this._graphQueryResultFormat = format2;
    }

    public void performGraphQuery(QueryLanguage language2, String query2, GraphQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("query", query2);
        postParams.put("queryLanguage", language2.toString());
        postParams.put("serialization", this._graphQueryResultFormat.toString());
        RdfXmlParser parser = null;
        if (this._graphQueryResultFormat == RDFFormat.RDFXML) {
            parser = new RdfXmlParser();
        } else if (this._graphQueryResultFormat == RDFFormat.NTRIPLES) {
            parser = new NTriplesParser();
        } else if (this._graphQueryResultFormat == RDFFormat.TURTLE) {
            parser = new TurtleParser();
        } else {
            throw new RuntimeException("Unsupported graph query result format: " + this._graphQueryResultFormat.toString());
        }
        RDFParserListener rdfParserListener = new RDFParserListener(listener);
        parser.setStatementHandler((StatementHandler)rdfParserListener);
        parser.setParseErrorListener((ParseErrorListener)rdfParserListener);
        parser.setNamespaceListener((NamespaceListener)rdfParserListener);
        parser.setVerifyData(false);
        parser.setPreserveBNodeIds(true);
        InputStream resultStream = this._sendPostRequest(this._graphQueryURL, postParams);
        try {
            parser.parse(resultStream, "foo:bar");
            rdfParserListener.finishGraphQueryResult();
        }
        catch (StatementHandlerException e) {
            this._throwIOException((Exception)((Object)e));
        }
        catch (ParseException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            resultStream.close();
        }
    }

    public Graph performGraphQuery(QueryLanguage language2, String query2) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        QueryResultsGraphBuilder listener = new QueryResultsGraphBuilder();
        this.performGraphQuery(language2, query2, listener);
        return listener.getGraph();
    }

    public void addData(URL dataURL, String baseURI, RDFFormat dataFormat, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("url", dataURL.toExternalForm());
        if (baseURI != null) {
            postParams.put("baseURI", baseURI);
        }
        postParams.put("dataFormat", dataFormat.toString());
        if (verifyData) {
            postParams.put("verifyData", "on");
        }
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        this._adminPost(this._urlUploadURL, postParams, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(File dataFile, String baseURI, RDFFormat dataFormat, boolean verifyData, AdminListener listener) throws FileNotFoundException, IOException, AccessDeniedException {
        FileInputStream in = new FileInputStream(dataFile);
        try {
            this.addData(in, baseURI, dataFormat, verifyData, listener);
        }
        finally {
            in.close();
        }
    }

    public void addData(InputStream data2, String baseURI, RDFFormat dataFormat, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        this._addData(data2, baseURI, dataFormat, verifyData, listener);
    }

    public void addData(Reader data2, String baseURI, RDFFormat dataFormat, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        StringWriter stringWriter = new StringWriter(8192);
        IOUtil.transfer((Reader)data2, (Writer)stringWriter);
        this.addData(stringWriter.toString(), baseURI, dataFormat, verifyData, listener);
    }

    public void addData(String data2, String baseURI, RDFFormat dataFormat, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        this._addData(data2, baseURI, dataFormat, verifyData, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(SesameRepository repository, AdminListener listener) throws IOException, AccessDeniedException {
        if (this == repository) {
            return;
        }
        InputStream dataStream = repository.extractRDF(RDFFormat.TURTLE, true, true, true, false);
        try {
            this.addData(dataStream, null, RDFFormat.TURTLE, false, listener);
        }
        finally {
            dataStream.close();
        }
    }

    private void _addData(Object data2, String baseURI, RDFFormat dataFormat, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        HashMap<String, Object> postParams = new HashMap<String, Object>();
        postParams.put("repository", this._repositoryId);
        postParams.put("data", data2);
        postParams.put("dataFormat", dataFormat.toString());
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        if (baseURI != null) {
            postParams.put("baseURI", baseURI);
        }
        if (verifyData) {
            postParams.put("verifyData", "on");
        }
        this._adminPost(this._dataUploadURL, postParams, listener);
    }

    public void addGraph(Graph graph) throws IOException, AccessDeniedException {
        String turtleDoc = this._graph2TurtleDoc(graph);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("data", turtleDoc);
        postParams.put("dataFormat", RDFFormat.TURTLE.toString());
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        AdminMsgCollector listener = new AdminMsgCollector();
        this._adminPost(this._dataMergeURL, postParams, listener);
    }

    public void addGraph(QueryLanguage language2, String query2) throws IOException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("query", query2);
        postParams.put("queryLanguage", language2.toString());
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        AdminMsgCollector listener = new AdminMsgCollector();
        this._adminPost(this._mergeGraphQueryURL, postParams, listener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addGraph(Graph graph, boolean joinBlankNodes) throws IOException, AccessDeniedException {
        if (!joinBlankNodes) {
            String turtleDoc = this._graph2TurtleDoc(graph);
            AdminMsgCollector listener = new AdminMsgCollector();
            this.addData(turtleDoc, null, RDFFormat.TURTLE, false, (AdminListener)listener);
            if (!listener.hasErrors()) return;
        }
        this.addGraph(graph);
    }

    public void addGraph(QueryLanguage language2, String query2, boolean joinBlankNodes) throws IOException, AccessDeniedException {
        if (!joinBlankNodes) {
            HashMap<String, String> postParams = new HashMap<String, String>();
            postParams.put("repository", this._repositoryId);
            postParams.put("query", query2);
            postParams.put("queryLanguage", language2.toString());
            postParams.put("resultFormat", AdminResultFormat.XML.toString());
            AdminMsgCollector listener = new AdminMsgCollector();
            this._adminPost(this._addGraphQueryURL, postParams, listener);
        } else {
            this.addGraph(language2, query2);
        }
    }

    public InputStream extractRDF(RDFFormat serialization, boolean schema, boolean data2, boolean explicitOnly, boolean niceOutput) throws IOException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("serialization", serialization.toString());
        if (schema) {
            postParams.put("schema", "on");
        }
        if (data2) {
            postParams.put("data", "on");
        }
        if (explicitOnly) {
            postParams.put("explicitOnly", "on");
        }
        if (niceOutput) {
            postParams.put("niceOutput", "on");
        }
        try {
            return this._sendPostRequest(this._extractURL, postParams);
        }
        catch (MalformedQueryException e) {
            this._throwIOException(e);
        }
        catch (QueryEvaluationException e) {
            this._throwIOException(e);
        }
        return null;
    }

    public void removeStatements(Resource subject, URI predicate, Value object, AdminListener listener) throws IOException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        if (subject != null) {
            postParams.put("subject", NTriplesUtil.toNTriplesString((Resource)subject));
        }
        if (predicate != null) {
            postParams.put("predicate", NTriplesUtil.toNTriplesString((URI)predicate));
        }
        if (object != null) {
            postParams.put("object", NTriplesUtil.toNTriplesString((Value)object));
        }
        this._adminPost(this._removeStatsURL, postParams, listener);
    }

    public void removeGraph(Graph graph) throws IOException, AccessDeniedException {
        String turtleDoc = this._graph2TurtleDoc(graph);
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("dataFormat", RDFFormat.TURTLE.toString());
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        postParams.put("data", turtleDoc);
        AdminMsgCollector listener = new AdminMsgCollector();
        this._adminPost(this._removeStatsURL, postParams, listener);
        if (listener.hasErrors()) {
            // empty if block
        }
    }

    public void removeGraph(QueryLanguage language2, String query2) throws IOException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("query", query2);
        postParams.put("queryLanguage", language2.toString());
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        AdminMsgCollector listener = new AdminMsgCollector();
        this._adminPost(this._removeGraphQueryURL, postParams, listener);
    }

    public void clear(AdminListener listener) throws IOException, AccessDeniedException {
        HashMap<String, String> postParams = new HashMap<String, String>();
        postParams.put("repository", this._repositoryId);
        postParams.put("resultFormat", AdminResultFormat.XML.toString());
        this._adminPost(this._clearURL, postParams, listener);
    }

    public String getRepositoryId() {
        return this._repositoryId;
    }

    private String _graph2TurtleDoc(Graph graph) throws IOException {
        StringWriter stringWriter = new StringWriter(8192);
        TurtleWriter turtleWriter = new TurtleWriter((Writer)stringWriter);
        turtleWriter.startDocument();
        StatementIterator statIter = graph.getStatements();
        while (statIter.hasNext()) {
            Statement st = statIter.next();
            turtleWriter.writeStatement(st.getSubject(), st.getPredicate(), st.getObject());
        }
        statIter.close();
        turtleWriter.endDocument();
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _adminPost(URL url, Map postParams, AdminListener listener) throws IOException, AccessDeniedException {
        InputStream responseStream = null;
        try {
            responseStream = this._sendPostRequest(url, postParams);
        }
        catch (MalformedQueryException e) {
            this._throwIOException(e);
        }
        catch (QueryEvaluationException e) {
            this._throwIOException(e);
        }
        try {
            XmlAdminMsgReader reader2 = new XmlAdminMsgReader(XMLReaderFactory.createXMLReader());
            reader2.read(responseStream, listener);
        }
        catch (SAXException e) {
            Exception ne = e.getException();
            String msg = ne != null ? ne.getMessage() : e.getMessage();
            this._throwIOException("Unable to handle request: " + msg, e);
        }
        finally {
            responseStream.close();
        }
    }

    private InputStream _sendPostRequest(URL url, Map postParams) throws IOException, AccessDeniedException, MalformedQueryException, QueryEvaluationException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        this._cookieManager.setCookies((URLConnection)conn);
        HttpClientUtil.setAcceptGZIPEncoding((URLConnection)conn);
        try {
            HttpClientUtil.prepareMultipartPostRequestInputStreamAware((HttpURLConnection)conn, (Map)postParams, (String)"UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 character encoding not supported on this platform");
        }
        conn.connect();
        this._checkResponse(conn);
        return new BufferedInputStream(HttpClientUtil.getInputStream((URLConnection)conn), 2048);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _checkResponse(HttpURLConnection conn) throws IOException, AccessDeniedException, MalformedQueryException, QueryEvaluationException {
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return;
        }
        String responseMsg = conn.getResponseMessage();
        if (responseCode == 403) {
            throw new AccessDeniedException(responseMsg);
        }
        if (responseCode != 400 || responseMsg == null) throw new IOException(responseMsg);
        int colonIdx = responseMsg.indexOf(58);
        if (colonIdx <= 0) throw new IOException(responseMsg);
        HTTPErrorType errType = HTTPErrorType.forValue(responseMsg.substring(0, colonIdx));
        if (errType == HTTPErrorType.UNKNOWN_REPOSITORY) {
            throw new IOException(responseMsg.substring(colonIdx + 2));
        }
        if (errType == HTTPErrorType.MALFORMED_QUERY) {
            throw new MalformedQueryException(responseMsg.substring(colonIdx + 2));
        }
        if (errType != HTTPErrorType.QUERY_EVALUATION_ERROR) return;
        throw new QueryEvaluationException(responseMsg.substring(colonIdx + 2));
    }

    private void _throwIOException(Exception e) throws IOException {
        IOException ioe = new IOException(e.getMessage());
        ioe.initCause(e);
        throw ioe;
    }

    private void _throwIOException(String msg, Exception e) throws IOException {
        IOException ioe = new IOException(msg);
        ioe.initCause(e);
        throw ioe;
    }

    static class RDFParserListener
    implements StatementHandler,
    ParseErrorListener,
    NamespaceListener {
        private GraphQueryResultListener _listener;
        private boolean _queryResultStarted;

        public RDFParserListener(GraphQueryResultListener listener) {
            this._listener = listener;
            this._queryResultStarted = false;
        }

        private void _ensureQueryResultStarted() throws IOException {
            if (!this._queryResultStarted) {
                this._listener.startGraphQueryResult();
                this._queryResultStarted = true;
            }
        }

        public void handleStatement(Resource subject, URI predicate, Value object) throws StatementHandlerException {
            try {
                this._ensureQueryResultStarted();
                this._listener.triple(subject, predicate, object);
            }
            catch (IOException e) {
                throw new StatementHandlerException((Exception)e);
            }
        }

        public void warning(String msg, int lineNo, int colNo) {
        }

        public void error(String msg, int lineNo, int colNo) {
            try {
                this._ensureQueryResultStarted();
                this._listener.reportError(msg);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void fatalError(String msg, int lineNo, int colNo) {
            try {
                this._ensureQueryResultStarted();
                this._listener.reportError(msg);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void handleNamespace(String prefix, String uri2) {
            try {
                this._listener.namespace(prefix, uri2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void finishGraphQueryResult() {
            try {
                this._ensureQueryResultStarted();
                this._listener.endGraphQueryResult();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

