/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.repository.local;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.RepositoryConfig;
import org.openrdf.sesame.config.RepositoryListImpl;
import org.openrdf.sesame.config.SailConfig;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.config.UserInfo;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sail.StackedSail;
import org.openrdf.sesame.server.SesameServer;

public class LocalService
implements SesameService {
    private SystemConfig _systemConfig;
    private Map _repositoryMap = new HashMap();

    public LocalService() {
        this(new SystemConfig());
    }

    public LocalService(SystemConfig systemConfig) {
        this.setSystemConfig(systemConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemConfig(SystemConfig newConfig) {
        Map map2 = this._repositoryMap;
        synchronized (map2) {
            if (this._systemConfig == null) {
                this._systemConfig = new SystemConfig();
            }
            HashMap newRepositoryMap = new HashMap();
            HashMap oldRepositoryMap = new HashMap(this._repositoryMap);
            Iterator<Object> iter2 = newConfig.getRepositoryConfigList().iterator();
            while (iter2.hasNext()) {
                Object repository;
                RepositoryConfig newRepConfig = (RepositoryConfig)iter2.next();
                String id = newRepConfig.getRepositoryId();
                RepositoryConfig oldRepConfig = this._systemConfig.getRepositoryConfig(id);
                if (oldRepConfig == null || !newRepConfig.equals(oldRepConfig) || (repository = oldRepositoryMap.remove(id)) == null) continue;
                newRepositoryMap.put(id, repository);
            }
            this._systemConfig = newConfig;
            this._repositoryMap = newRepositoryMap;
            iter2 = oldRepositoryMap.values().iterator();
            while (iter2.hasNext()) {
                LocalRepository expiredRep = (LocalRepository)iter2.next();
                expiredRep.shutDown();
            }
        }
    }

    public SystemConfig getSystemConfig() {
        return this._systemConfig;
    }

    public void login(String user, String password) throws AccessDeniedException {
        SessionContext sc = LocalService._getSessionContext();
        UserInfo ui = this._systemConfig.getUserInfo(user);
        if (ui == null) {
            throw new AccessDeniedException("User '" + user + "' unknown");
        }
        if (ui.getPassword() != null && !ui.getPassword().equals(password)) {
            throw new AccessDeniedException("Password incorrect");
        }
        sc.fullname = ui.getFullName();
        sc.user = ui.getLogin();
        sc.pass = ui.getPassword();
        sc.userID = ui.getID();
    }

    public void logout() {
        SessionContext sc = LocalService._getSessionContext();
        sc.fullname = "";
        sc.user = "";
        sc.pass = "";
        sc.userID = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryList getRepositoryList() {
        SystemConfig systemConfig = this._systemConfig;
        synchronized (systemConfig) {
            RepositoryListImpl repositoryList = new RepositoryListImpl();
            String username = LocalService._getSessionContext().user;
            UserInfo userInfo = this._systemConfig.getUserInfo(username);
            List repConfigs = this._systemConfig.getRepositoryConfigList();
            for (int i = 0; i < repConfigs.size(); ++i) {
                RepositoryConfig repConfig = (RepositoryConfig)repConfigs.get(i);
                String repositoryId = repConfig.getRepositoryId();
                boolean readAccess = repConfig.isWorldReadable();
                boolean writeAccess = repConfig.isWorldWriteable();
                if (!readAccess && userInfo != null) {
                    readAccess = userInfo.hasReadAccess(repositoryId);
                }
                if (!writeAccess && userInfo != null) {
                    writeAccess = userInfo.hasWriteAccess(repositoryId);
                }
                repositoryList.addRepository(repositoryId, repConfig.getTitle(), readAccess, writeAccess);
            }
            return repositoryList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SesameRepository getRepository(String repositoryId) throws UnknownRepositoryException, ConfigurationException {
        Map map2 = this._repositoryMap;
        synchronized (map2) {
            LocalRepository repository = (LocalRepository)this._repositoryMap.get(repositoryId);
            if (repository == null) {
                SystemConfig systemConfig = this._systemConfig;
                synchronized (systemConfig) {
                    RepositoryConfig repConfig = this._systemConfig.getRepositoryConfig(repositoryId);
                    if (repConfig == null) {
                        throw new UnknownRepositoryException("Unknown repository: " + repositoryId);
                    }
                    repository = this._createRepository(repConfig);
                    this._repositoryMap.put(repositoryId, repository);
                }
            }
            return repository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(RepositoryConfig repConfig) throws ConfigurationException {
        String repositoryId = repConfig.getRepositoryId();
        SystemConfig systemConfig = this._systemConfig;
        synchronized (systemConfig) {
            if (this._systemConfig.hasRepository(repositoryId)) {
                throw new ConfigurationException("A repository with ID '" + repositoryId + "' is already defined");
            }
            this._systemConfig.addRepositoryConfig(repConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(String repositoryId) {
        Object object = this._systemConfig;
        synchronized (object) {
            this._systemConfig.removeRepository(repositoryId);
        }
        object = this._repositoryMap;
        synchronized (object) {
            this._repositoryMap.remove(repositoryId);
        }
    }

    public LocalRepository createRepository(RepositoryConfig repConfig) throws ConfigurationException {
        this.addRepository(repConfig);
        try {
            return (LocalRepository)this.getRepository(repConfig.getRepositoryId());
        }
        catch (UnknownRepositoryException e) {
            throw new RuntimeException("Program error", e);
        }
    }

    protected static SessionContext _getSessionContext() {
        SessionContext sc = SessionContext.getContext();
        if (sc == null) {
            sc = new SessionContext();
            sc.bLogged = false;
            sc.VersionState = -1;
            SessionContext.setContext(sc);
        }
        return sc;
    }

    public LocalRepository createRepository(String repositoryId, boolean inferencing) throws ConfigurationException {
        SailConfig memSail;
        SailConfig syncSail;
        RepositoryConfig config = new RepositoryConfig(repositoryId);
        if (inferencing) {
            syncSail = new SailConfig("org.openrdf.sesame.sailimpl.sync.SyncRdfSchemaRepository");
            memSail = new SailConfig("org.openrdf.sesame.sailimpl.memory.RdfSchemaRepository");
        } else {
            syncSail = new SailConfig("org.openrdf.sesame.sailimpl.sync.SyncRdfRepository");
            memSail = new SailConfig("org.openrdf.sesame.sailimpl.memory.RdfRepository");
        }
        config.addSail(syncSail);
        config.addSail(memSail);
        config.setWorldReadable(true);
        config.setWorldWriteable(true);
        return this.createRepository(config);
    }

    private LocalRepository _createRepository(RepositoryConfig repConfig) throws ConfigurationException {
        try {
            List sailList = repConfig.getSailList();
            ListIterator sailIter = sailList.listIterator(sailList.size());
            SailConfig sailConfig = (SailConfig)sailIter.previous();
            String className = sailConfig.getSailClass();
            Class<?> sailClass = Class.forName(className);
            Sail topSail = null;
            try {
                topSail = (Sail)sailClass.newInstance();
            }
            catch (ClassCastException e) {
                throw new ConfigurationException(sailClass + " does not implement Sail interface.");
            }
            topSail.initialize(sailConfig.getConfigParameters());
            while (sailIter.hasPrevious()) {
                sailConfig = (SailConfig)sailIter.previous();
                className = sailConfig.getSailClass();
                sailClass = Class.forName(className);
                StackedSail stackedSail = null;
                try {
                    stackedSail = (StackedSail)sailClass.newInstance();
                }
                catch (ClassCastException e) {
                    throw new ConfigurationException(className + " is not a StackedSail.");
                }
                stackedSail.setBaseSail(topSail);
                stackedSail.initialize(sailConfig.getConfigParameters());
                topSail = stackedSail;
            }
            if (topSail instanceof RdfSource) {
                return new LocalRepository(repConfig.getRepositoryId(), (RdfSource)topSail, this);
            }
            throw new ConfigurationException("top Sail class does not implement RdfSource");
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e);
        }
        catch (SailInitializationException e) {
            throw new ConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Map map2 = this._repositoryMap;
        synchronized (map2) {
            Iterator iter2 = this._repositoryMap.values().iterator();
            while (iter2.hasNext()) {
                LocalRepository rep2 = (LocalRepository)iter2.next();
                rep2.shutDown();
            }
            this._repositoryMap.clear();
        }
    }

    public boolean hasReadAccess(String repository) throws UnknownRepositoryException {
        RepositoryConfig repConfig = this._systemConfig.getRepositoryConfig(repository);
        if (repConfig == null) {
            throw new UnknownRepositoryException("Unknown repository: " + repository);
        }
        if (repConfig.isWorldReadable()) {
            return true;
        }
        String username = LocalService._getSessionContext().user;
        UserInfo userInfo = this._systemConfig.getUserInfo(username);
        if (userInfo != null) {
            return userInfo.hasReadAccess(repConfig.getRepositoryId());
        }
        return false;
    }

    public boolean hasWriteAccess(String repository) throws UnknownRepositoryException {
        RepositoryConfig repConfig = this._systemConfig.getRepositoryConfig(repository);
        if (repConfig == null) {
            throw new UnknownRepositoryException("Unknown repository: " + repository);
        }
        if (repConfig.isWorldWriteable()) {
            return true;
        }
        String username = LocalService._getSessionContext().user;
        UserInfo userInfo = this._systemConfig.getUserInfo(username);
        if (userInfo != null) {
            return userInfo.hasWriteAccess(repConfig.getRepositoryId());
        }
        return false;
    }

    public File getTmpDir() throws IOException {
        boolean tmpDirCreated;
        String tmpDirStr = this._systemConfig.getTmpDir();
        File tmpDir = null;
        if (tmpDirStr != null && !(tmpDir = new File(SesameServer.getBaseDir(), tmpDirStr)).exists() && !(tmpDirCreated = tmpDir.mkdirs())) {
            throw new IOException("Unable to create directory " + tmpDir.getAbsolutePath());
        }
        return tmpDir;
    }

    public File createTmpFile(String prefix, String suffix) throws IOException {
        File tmpDir = this.getTmpDir();
        File tmpFile = null;
        if (tmpDir != null) {
            tmpFile = File.createTempFile(prefix, suffix, tmpDir);
        }
        return tmpFile;
    }
}

