/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.repository.local;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.n3.N3Writer;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.RdfAdmin;
import org.openrdf.sesame.admin.UpdateException;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.export.RdfExport;
import org.openrdf.sesame.query.GraphQuery;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.QueryResultsGraphBuilder;
import org.openrdf.sesame.query.QueryResultsTable;
import org.openrdf.sesame.query.QueryResultsTableBuilder;
import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rdql.RdqlEngine;
import org.openrdf.sesame.query.rql.RqlEngine;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.serql.SerqlEngine;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalRepositoryChangedEvent;
import org.openrdf.sesame.repository.local.LocalRepositoryChangedEventImpl;
import org.openrdf.sesame.repository.local.LocalRepositoryChangedListener;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.Sail;
import org.openrdf.sesame.sail.SailChangedEvent;
import org.openrdf.sesame.sail.SailChangedListener;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;

public class LocalRepository
implements SesameRepository,
SailChangedListener {
    private static final boolean JOIN_BLANKNODES_DEFAULT = true;
    private RdfSource _rdfSource;
    private String _id;
    private SerqlEngine _serqlQueryEngine;
    private RqlEngine _rqlQueryEngine;
    private RdqlEngine _rdqlQueryEngine;
    private RdfAdmin _rdfAdmin;
    private RdfExport _rdfExport;
    private LocalService _service;
    private List _listeners;

    protected LocalRepository(String id, RdfSource rdfSource, LocalService service) {
        this._id = id;
        this._rdfSource = rdfSource;
        this._service = service;
        this._listeners = new ArrayList(0);
        if (this._rdfSource instanceof RdfRepository) {
            ((RdfRepository)this._rdfSource).addListener(this);
        }
    }

    public boolean hasReadAccess() {
        try {
            return this._service.hasReadAccess(this._id);
        }
        catch (UnknownRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasWriteAccess() {
        try {
            return this._service.hasWriteAccess(this._id);
        }
        catch (UnknownRepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void _ensureReadAccess() throws AccessDeniedException {
        if (!this.hasReadAccess()) {
            throw new AccessDeniedException("Need read access");
        }
    }

    protected void _ensureWriteAccess() throws AccessDeniedException {
        if (!this.hasWriteAccess()) {
            throw new AccessDeniedException("Need write access");
        }
    }

    public QueryResultsTable performTableQuery(QueryLanguage language2, String query2) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        QueryResultsTableBuilder builder = new QueryResultsTableBuilder();
        this.performTableQuery(language2, query2, builder);
        return builder.getQueryResultsTable();
    }

    public void performTableQuery(QueryLanguage language2, String query2, TableQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        this._ensureReadAccess();
        if (QueryLanguage.SERQL.equals((Object)language2)) {
            this._performSeRQLSelectQuery(query2, listener);
        } else if (QueryLanguage.RQL.equals((Object)language2)) {
            this._performRqlQuery(query2, listener);
        } else if (QueryLanguage.RDQL.equals((Object)language2)) {
            this._performRdqlQuery(query2, listener);
        } else {
            throw new IllegalArgumentException("Unknown query language: " + (Object)((Object)language2));
        }
    }

    public void performGraphQuery(QueryLanguage language2, String query2, GraphQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        this._ensureReadAccess();
        if (!QueryLanguage.SERQL.equals((Object)language2)) {
            throw new IllegalArgumentException("Query language " + language2.toString() + " does not support graph queries");
        }
        this._performSeRQLConstructQuery(query2, listener);
    }

    public Graph performGraphQuery(QueryLanguage language2, String query2) throws IOException, MalformedQueryException, QueryEvaluationException, AccessDeniedException {
        this._ensureReadAccess();
        QueryResultsGraphBuilder listener = new QueryResultsGraphBuilder();
        if (QueryLanguage.SERQL.equals((Object)language2)) {
            this._performSeRQLConstructQuery(query2, listener);
            return listener.getGraph();
        }
        throw new IllegalArgumentException("Query language " + language2.toString() + " does not support graph queries");
    }

    protected void _performRqlQuery(String query2, TableQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException {
        if (this._rqlQueryEngine == null) {
            try {
                RdfSchemaSource rss = (RdfSchemaSource)this._rdfSource;
                this._rqlQueryEngine = new RqlEngine(rss);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Repository is not an RdfSchemaSource");
            }
        }
        Query queryModel = this._rqlQueryEngine.parseQuery(query2);
        this._rqlQueryEngine.evaluateQuery(queryModel, listener);
    }

    protected void _performRdqlQuery(String query2, TableQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException {
        if (this._rdqlQueryEngine == null) {
            this._rdqlQueryEngine = new RdqlEngine(this._rdfSource);
        }
        TableQuery tableQuery = this._rdqlQueryEngine.parseQuery(query2);
        this._rdqlQueryEngine.evaluateQuery(tableQuery, listener);
    }

    protected void _performSeRQLSelectQuery(String query2, TableQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException {
        if (this._serqlQueryEngine == null) {
            this._serqlQueryEngine = new SerqlEngine(this._rdfSource);
        }
        TableQuery tableQuery = this._serqlQueryEngine.parseTableQuery(query2);
        this._serqlQueryEngine.evaluateSelectQuery(tableQuery, listener);
    }

    protected void _performSeRQLConstructQuery(String query2, GraphQueryResultListener listener) throws IOException, MalformedQueryException, QueryEvaluationException {
        if (this._serqlQueryEngine == null) {
            this._serqlQueryEngine = new SerqlEngine(this._rdfSource);
        }
        GraphQuery graphQuery = this._serqlQueryEngine.parseGraphQuery(query2);
        this._serqlQueryEngine.evaluateConstructQuery(graphQuery, listener);
    }

    protected void _ensureRdfAdminCreated() {
        if (this._rdfAdmin == null) {
            try {
                RdfRepository rdfRepository = (RdfRepository)this._rdfSource;
                this._rdfAdmin = new RdfAdmin(rdfRepository, this._service);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Repository is not an RdfRepository");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(URL dataURL, String baseURI, RDFFormat format2, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        if (baseURI == null) {
            baseURI = dataURL.toExternalForm();
        }
        InputStream inputStream2 = dataURL.openStream();
        try {
            this.addData(inputStream2, baseURI, format2, verifyData, listener);
        }
        finally {
            inputStream2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(File dataFile, String baseURI, RDFFormat format2, boolean verifyData, AdminListener listener) throws FileNotFoundException, IOException, AccessDeniedException {
        FileInputStream inputStream2 = new FileInputStream(dataFile);
        try {
            this.addData(inputStream2, baseURI, format2, verifyData, listener);
        }
        finally {
            ((InputStream)inputStream2).close();
        }
    }

    public void addData(String data2, String baseURI, RDFFormat format2, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        this.addData(new StringReader(data2), baseURI, format2, verifyData, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(SesameRepository repository, AdminListener listener) throws IOException, AccessDeniedException {
        if (this == repository) {
            return;
        }
        InputStream dataStream = repository.extractRDF(RDFFormat.RDFXML, true, true, true, false);
        try {
            this.addData(dataStream, "foo:bar", RDFFormat.RDFXML, false, listener);
        }
        finally {
            dataStream.close();
        }
    }

    public void addData(Reader reader2, String baseURI, RDFFormat format2, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        this._ensureRdfAdminCreated();
        try {
            this._rdfAdmin.addRdfModel(reader2, baseURI, listener, format2, verifyData);
        }
        catch (UpdateException e) {
            // empty catch block
        }
    }

    public void addData(InputStream dataStream, String baseURI, RDFFormat format2, boolean verifyData, AdminListener listener) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        this._ensureRdfAdminCreated();
        try {
            this._rdfAdmin.addRdfModel(dataStream, baseURI, listener, format2, verifyData);
        }
        catch (UpdateException e) {
            // empty catch block
        }
    }

    public InputStream extractRDF(RDFFormat format2, boolean ontology, boolean instances, boolean explicitOnly, boolean niceOutput) throws IOException, AccessDeniedException {
        this._ensureReadAccess();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8092);
        RdfXmlWriter rdfDocWriter = null;
        if (RDFFormat.RDFXML.equals((Object)format2)) {
            rdfDocWriter = new RdfXmlWriter((OutputStream)baos);
        } else if (RDFFormat.NTRIPLES.equals((Object)format2)) {
            rdfDocWriter = new NTriplesWriter((OutputStream)baos);
        } else if (RDFFormat.N3.equals((Object)format2)) {
            rdfDocWriter = new N3Writer((OutputStream)baos);
        } else if (RDFFormat.TURTLE.equals((Object)format2)) {
            rdfDocWriter = new TurtleWriter((OutputStream)baos);
        }
        this.extractRDF((RdfDocumentWriter)rdfDocWriter, ontology, instances, explicitOnly, niceOutput);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public void extractRDF(RdfDocumentWriter rdfDocWriter, boolean ontology, boolean instances, boolean explicitOnly, boolean niceOutput) throws IOException, AccessDeniedException {
        this._ensureReadAccess();
        if (this._rdfExport == null) {
            this._rdfExport = new RdfExport();
        }
        if (this._rdfSource instanceof RdfSchemaSource) {
            this._rdfExport.exportRdf((RdfSchemaSource)this._rdfSource, rdfDocWriter, ontology, instances, explicitOnly, niceOutput);
        } else {
            this._rdfExport.exportRdf(this._rdfSource, rdfDocWriter, niceOutput);
        }
    }

    public void removeStatements(Resource subject, URI predicate, Value object, AdminListener listener) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        this._ensureRdfAdminCreated();
        try {
            this._rdfAdmin.removeStatements(subject, predicate, object, listener);
        }
        catch (UpdateException e) {
            // empty catch block
        }
    }

    public void clear(AdminListener listener) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        this._ensureRdfAdminCreated();
        try {
            this._rdfAdmin.clearRepository(listener);
        }
        catch (UpdateException updateException) {
            // empty catch block
        }
    }

    public Sail getSail() {
        return this._rdfSource;
    }

    public synchronized void shutDown() {
        if (this._rdfSource != null) {
            this._rdfSource.shutDown();
            this._rdfSource = null;
            this._serqlQueryEngine = null;
            this._rqlQueryEngine = null;
            this._rdqlQueryEngine = null;
            this._rdfAdmin = null;
            this._rdfExport = null;
        }
    }

    public void mergeGraph(Graph graph) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        RdfRepository thisRep = (RdfRepository)this._rdfSource;
        StatementIterator iter2 = graph.getStatements();
        try {
            thisRep.startTransaction();
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                Resource subject = st.getSubject();
                URI predicate = st.getPredicate();
                Value object = st.getObject();
                thisRep.addStatement(subject, predicate, object);
            }
        }
        catch (SailUpdateException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            thisRep.commitTransaction();
            iter2.close();
        }
    }

    public void mergeGraph(QueryLanguage language2, String query2) throws IOException, AccessDeniedException {
        try {
            Graph graph = this.performGraphQuery(language2, query2);
            this.mergeGraph(graph);
        }
        catch (QueryEvaluationException e) {
            throw new IOException(e.getMessage());
        }
        catch (MalformedQueryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void addGraph(Graph graph) throws IOException, AccessDeniedException {
        this.addGraph(graph, true);
    }

    public void addGraph(Graph graph, boolean joinBlankNodes) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        RdfRepository thisRep = (RdfRepository)this._rdfSource;
        HashMap<String, Value> bNodesMap = null;
        ValueFactory factory = null;
        if (!joinBlankNodes) {
            bNodesMap = new HashMap<String, Value>();
            factory = thisRep.getValueFactory();
        }
        StatementIterator iter2 = graph.getStatements();
        try {
            thisRep.startTransaction();
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                Resource subject = st.getSubject();
                URI predicate = st.getPredicate();
                Value object = st.getObject();
                if (!joinBlankNodes) {
                    String bNodeId;
                    if (subject instanceof BNode) {
                        bNodeId = ((BNode)subject).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            subject = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            subject = factory.createBNode();
                            bNodesMap.put(bNodeId, subject);
                        }
                    }
                    if (object instanceof BNode) {
                        bNodeId = ((BNode)object).getID();
                        if (bNodesMap.containsKey(bNodeId)) {
                            object = (Resource)bNodesMap.get(bNodeId);
                        } else {
                            object = factory.createBNode();
                            bNodesMap.put(bNodeId, object);
                        }
                    }
                }
                thisRep.addStatement(subject, predicate, object);
            }
        }
        catch (SailUpdateException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            thisRep.commitTransaction();
            iter2.close();
        }
    }

    public void removeGraph(Graph graph) throws IOException, AccessDeniedException {
        this._ensureWriteAccess();
        RdfRepository thisRep = (RdfRepository)this._rdfSource;
        StatementIterator iter2 = graph.getStatements();
        try {
            thisRep.startTransaction();
            while (iter2.hasNext()) {
                Statement st = iter2.next();
                thisRep.removeStatements(st.getSubject(), st.getPredicate(), st.getObject());
            }
        }
        catch (SailUpdateException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            thisRep.commitTransaction();
            iter2.close();
        }
    }

    public Graph getGraph() throws AccessDeniedException {
        this._ensureReadAccess();
        this._ensureWriteAccess();
        return new GraphImpl(this);
    }

    public void addGraph(QueryLanguage language2, String query2) throws IOException, AccessDeniedException {
        this.addGraph(language2, query2, true);
    }

    public void addGraph(QueryLanguage language2, String query2, boolean joinBlankNodes) throws IOException, AccessDeniedException {
        try {
            Graph graph = this.performGraphQuery(language2, query2);
            this.addGraph(graph, joinBlankNodes);
        }
        catch (QueryEvaluationException e) {
            throw new IOException(e.getMessage());
        }
        catch (MalformedQueryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void removeGraph(QueryLanguage language2, String query2) throws IOException, AccessDeniedException {
        try {
            Graph graph = this.performGraphQuery(language2, query2);
            this.removeGraph(graph);
        }
        catch (QueryEvaluationException e) {
            throw new IOException(e.getMessage());
        }
        catch (MalformedQueryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getRepositoryId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LocalRepositoryChangedListener listener) {
        List list2 = this._listeners;
        synchronized (list2) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LocalRepositoryChangedListener listener) {
        List list2 = this._listeners;
        synchronized (list2) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _notifyRepositoryChange(LocalRepositoryChangedEvent event) {
        List list2 = this._listeners;
        synchronized (list2) {
            Iterator listeners = this._listeners.iterator();
            while (listeners.hasNext()) {
                LocalRepositoryChangedListener listener = (LocalRepositoryChangedListener)listeners.next();
                listener.repositoryChanged(event);
            }
        }
    }

    public void sailChanged(SailChangedEvent event) {
        LocalRepositoryChangedEventImpl lrcEvent = new LocalRepositoryChangedEventImpl(event.statementsAdded(), event.statementsRemoved());
        this._notifyRepositoryChange(lrcEvent);
    }
}

