/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.iterators.NestedResourceIterator;
import org.openrdf.sesame.query.rql.model.iterators.StatementObjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class SuperClassOf
implements ClassQuery {
    protected ClassQuery _classQ;
    protected boolean _recursive;

    public SuperClassOf(ClassQuery classQ, boolean recursive) {
        this._classQ = classQ;
        this._recursive = recursive;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ValueIterator iter2 = null;
        try {
            String[] columnHeaders = new String[]{this.getQuery()};
            listener.startTableQueryResult(columnHeaders);
            iter2 = this.getClasses(rss);
            while (iter2.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter2.next());
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            if (iter2 != null) {
                iter2.close();
            }
        }
    }

    public ClassQuery getArgument() {
        return this._classQ;
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return this.getClasses(rss);
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) throws QueryEvaluationException {
        ResourceIterator classIter = this._classQ.getClasses(rss);
        return new Iterator(rss, classIter);
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        if (this._recursive) {
            return "superClassOf(" + this._classQ.toString() + ")";
        }
        return "superClassOf^(" + this._classQ.toString() + ")";
    }

    class Iterator
    extends NestedResourceIterator {
        protected RdfSchemaSource _rss;

        public Iterator(RdfSchemaSource rss, ResourceIterator classIter) {
            super(classIter);
            this._rss = rss;
        }

        public ResourceIterator getInnerIterator(Value classRes) {
            StatementIterator statIter = SuperClassOf.this._recursive ? this._rss.getSubClassOf((Resource)classRes, null) : this._rss.getDirectSubClassOf((Resource)classRes, null);
            return new StatementObjectIterator(statIter);
        }
    }
}

