/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class RdfProperty
implements PropertyQuery {
    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        try {
            String[] columnHeader = new String[]{"Properties"};
            listener.startTableQueryResult(columnHeader);
            ResourceIterator iter2 = this.getProperties(rss);
            while (iter2.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter2.next());
                listener.endTuple();
            }
            iter2.close();
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) {
        return this.getProperties(rss);
    }

    public ResourceIterator getProperties(RdfSchemaSource rss) {
        return new StatementSubjectIterator(rss.getProperties());
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return "Property";
    }

    public String toString() {
        return "Property";
    }
}

