/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.PropertyVar;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;

public class PropertySelector
implements Selector {
    protected PropertyVar _propVar;
    protected PropertyQuery _propQ;
    protected ResourceIterator _propQIter;
    protected boolean _propVarLocked;

    public PropertySelector(PropertyVar propVar, PropertyQuery propQ) {
        if (propQ instanceof PropertyVar) {
            throw new IllegalArgumentException("propQ must not be an instance of PropertyVar");
        }
        this._propVar = propVar;
        this._propQ = propQ;
    }

    public void initialize(RdfSchemaSource rss) throws QueryEvaluationException {
        this._propQIter = this._propQ.getProperties(rss);
        this._propVarLocked = this._propVar.hasValue();
    }

    public boolean selectNext(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._propVarLocked) {
            Resource propVarValue = (Resource)this._propVar.getValue();
            boolean result2 = false;
            while (this._propQIter.hasNext()) {
                URI propQValue = (URI)this._propQIter.next();
                if (!propVarValue.equals(propQValue)) continue;
                result2 = true;
            }
            return result2;
        }
        if (this._propQIter.hasNext()) {
            URI propQValue = (URI)this._propQIter.next();
            this._propVar.setValue(propQValue);
            return true;
        }
        this._propVar.setValue(null);
        return false;
    }

    public void clear() {
        if (this._propQIter != null) {
            this._propQIter.close();
            if (!this._propVarLocked) {
                this._propVar.setValue(null);
            }
        }
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append("(");
        result2.append(this._propQ.toString());
        result2.append("{");
        result2.append(this._propVar.toString());
        result2.append("})");
        return result2.toString();
    }
}

