/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sesame.query.rql.model.And;
import org.openrdf.sesame.query.rql.model.BooleanConstant;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.ClassSelector;
import org.openrdf.sesame.query.rql.model.CompareTo;
import org.openrdf.sesame.query.rql.model.DataPathSelector;
import org.openrdf.sesame.query.rql.model.DomainSelector;
import org.openrdf.sesame.query.rql.model.In;
import org.openrdf.sesame.query.rql.model.InstanceSelector;
import org.openrdf.sesame.query.rql.model.IntegerConstant;
import org.openrdf.sesame.query.rql.model.PropertySelector;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.rql.model.RangeSelector;
import org.openrdf.sesame.query.rql.model.RealConstant;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.query.rql.model.SetQuery;
import org.openrdf.sesame.query.rql.model.SfwQuery;
import org.openrdf.sesame.query.rql.model.StringConstant;
import org.openrdf.sesame.query.rql.model.URI;
import org.openrdf.sesame.query.rql.model.UnknownSelector;
import org.openrdf.sesame.query.rql.model.Var;
import org.openrdf.util.log.ThreadLog;

public class RqlOptimizer {
    private RqlOptimizer() {
    }

    public static Query optimize(Query query2) {
        if (query2 instanceof SfwQuery) {
            RqlOptimizer._optimizeSfwQuery((SfwQuery)query2);
        } else if (query2 instanceof SetQuery) {
            SetQuery setQuery = (SetQuery)query2;
            RqlOptimizer._optimizeSfwQuery(setQuery.getArg1());
            RqlOptimizer._optimizeSfwQuery(setQuery.getArg2());
        }
        return query2;
    }

    private static void _optimizeSfwQuery(SfwQuery sfwQuery) {
        BooleanQuery where = sfwQuery.getWherePart();
        if (where != null) {
            where = RqlOptimizer._handleExplicitJoins(where);
            where = RqlOptimizer._findAndRemoveExplicitAssigns(where);
            where = RqlOptimizer._optimizeNestedSfwQueries(where);
            sfwQuery.setWherePart(where);
        }
        RqlOptimizer._reorderSelectors(sfwQuery);
    }

    private static BooleanQuery _handleExplicitJoins(BooleanQuery where) {
        HashMap varMap = new HashMap();
        BooleanQuery newWhere = RqlOptimizer._findAndRemoveExplicitJoins(where, varMap);
        HashSet varSet = new HashSet(varMap.values());
        Iterator listIter = varSet.iterator();
        while (listIter.hasNext()) {
            List varList = (List)listIter.next();
            Iterator varIter = varList.iterator();
            Var leader = (Var)varIter.next();
            while (varIter.hasNext()) {
                Var v = (Var)varIter.next();
                v.setLeader(leader);
            }
        }
        return newWhere;
    }

    private static BooleanQuery _findAndRemoveExplicitJoins(BooleanQuery bQuery, Map varMap) {
        CompareTo ct;
        if (bQuery instanceof And) {
            And and2 = (And)bQuery;
            BooleanQuery newArg1 = RqlOptimizer._findAndRemoveExplicitJoins(and2.getArg1(), varMap);
            BooleanQuery newArg2 = RqlOptimizer._findAndRemoveExplicitJoins(and2.getArg2(), varMap);
            if (newArg1 == null && newArg2 == null) {
                return null;
            }
            if (newArg2 == null) {
                return newArg1;
            }
            if (newArg1 == null) {
                return newArg2;
            }
            return and2;
        }
        if (bQuery instanceof CompareTo && (ct = (CompareTo)bQuery).getOperator() == 2) {
            ResourceQuery arg1 = ct.getArg1();
            ResourceQuery arg2 = ct.getArg2();
            if (arg1 instanceof Var && arg2 instanceof Var) {
                List varList1 = (List)varMap.get(arg1);
                List varList2 = (List)varMap.get(arg2);
                if (varList1 == null && varList2 == null) {
                    ArrayList<ResourceQuery> varList = new ArrayList<ResourceQuery>();
                    varList.add(arg1);
                    varList.add(arg2);
                    varMap.put(arg1, varList);
                    varMap.put(arg2, varList);
                } else if (varList2 == null) {
                    varList1.add(arg2);
                    varMap.put(arg2, varList1);
                } else if (varList1 == null) {
                    varList2.add(arg1);
                    varMap.put(arg1, varList2);
                } else if (varList1 != varList2) {
                    varList1.addAll(varList2);
                    Iterator iter2 = varList2.iterator();
                    while (iter2.hasNext()) {
                        Object o = iter2.next();
                        varMap.put(o, varList1);
                    }
                }
                return null;
            }
        }
        return bQuery;
    }

    private static BooleanQuery _findAndRemoveExplicitAssigns(BooleanQuery bQuery) {
        CompareTo ct;
        if (bQuery instanceof And) {
            And and2 = (And)bQuery;
            BooleanQuery newArg1 = RqlOptimizer._findAndRemoveExplicitAssigns(and2.getArg1());
            BooleanQuery newArg2 = RqlOptimizer._findAndRemoveExplicitAssigns(and2.getArg2());
            if (newArg1 == null && newArg2 == null) {
                return null;
            }
            if (newArg2 == null) {
                return newArg1;
            }
            if (newArg1 == null) {
                return newArg2;
            }
            return and2;
        }
        if (bQuery instanceof CompareTo && (ct = (CompareTo)bQuery).getOperator() == 2) {
            ResourceQuery arg1 = ct.getArg1();
            ResourceQuery arg2 = ct.getArg2();
            if (arg1 instanceof Var || arg2 instanceof Var) {
                Var varArg = null;
                ResourceQuery valueArg = null;
                Value value2 = null;
                if (arg1 instanceof Var) {
                    varArg = (Var)arg1;
                    valueArg = arg2;
                } else {
                    varArg = (Var)arg2;
                    valueArg = arg1;
                }
                if (valueArg instanceof URI) {
                    value2 = ((URI)valueArg).getValue();
                } else if (valueArg instanceof StringConstant) {
                    value2 = new LiteralImpl(((StringConstant)valueArg).getValue());
                } else if (valueArg instanceof IntegerConstant) {
                    int i = ((IntegerConstant)valueArg).getValue();
                    value2 = new LiteralImpl(String.valueOf(i));
                } else if (valueArg instanceof RealConstant) {
                    float f = ((RealConstant)valueArg).getValue();
                    value2 = new LiteralImpl(String.valueOf(f));
                }
                if (value2 != null) {
                    Value otherVal = varArg.getValue();
                    if (otherVal != null) {
                        if (value2.equals(otherVal)) {
                            return null;
                        }
                        return new BooleanConstant(false);
                    }
                    varArg.setValue(value2);
                    return null;
                }
            }
        }
        return bQuery;
    }

    private static BooleanQuery _optimizeNestedSfwQueries(BooleanQuery bQuery) {
        In in;
        if (bQuery instanceof And) {
            And and2 = (And)bQuery;
            BooleanQuery newArg1 = RqlOptimizer._optimizeNestedSfwQueries(and2.getArg1());
            BooleanQuery newArg2 = RqlOptimizer._optimizeNestedSfwQueries(and2.getArg2());
            if (newArg1 == null && newArg2 == null) {
                return null;
            }
            if (newArg2 == null) {
                return newArg1;
            }
            if (newArg1 == null) {
                return newArg2;
            }
            return and2;
        }
        if (bQuery instanceof In && (in = (In)bQuery).getArg2() instanceof SfwQuery) {
            RqlOptimizer._optimizeSfwQuery((SfwQuery)in.getArg2());
        }
        return bQuery;
    }

    private static void _reorderSelectors(SfwQuery sfwQuery) {
        List selectorList = sfwQuery.getFromPart();
        ArrayList<Selector> propertySelList = new ArrayList<Selector>();
        ArrayList<Selector> domainSelList = new ArrayList<Selector>();
        ArrayList<Selector> rangeSelList = new ArrayList<Selector>();
        List<Selector> dataPathSelList = new ArrayList();
        ArrayList<Selector> unknownSelList = new ArrayList<Selector>();
        ArrayList<Selector> instanceSelList = new ArrayList<Selector>();
        ArrayList<Selector> classSelList = new ArrayList<Selector>();
        ArrayList<Selector> restSelList = new ArrayList<Selector>();
        int selectorCount = selectorList.size();
        for (int i = 0; i < selectorCount; ++i) {
            Selector selector = (Selector)selectorList.get(i);
            if (selector instanceof PropertySelector) {
                propertySelList.add(selector);
                continue;
            }
            if (selector instanceof DomainSelector) {
                domainSelList.add(selector);
                continue;
            }
            if (selector instanceof RangeSelector) {
                rangeSelList.add(selector);
                continue;
            }
            if (selector instanceof DataPathSelector) {
                dataPathSelList.add(selector);
                continue;
            }
            if (selector instanceof UnknownSelector) {
                unknownSelList.add(selector);
                continue;
            }
            if (selector instanceof InstanceSelector) {
                instanceSelList.add(selector);
                continue;
            }
            if (selector instanceof ClassSelector) {
                classSelList.add(selector);
                continue;
            }
            restSelList.add(selector);
            ThreadLog.warning((String)("Found an unknown selector: " + selector.getClass().getName()));
        }
        dataPathSelList = RqlOptimizer._reorderDataPathSelectors(dataPathSelList);
        ArrayList<Selector> newSelectorList = new ArrayList<Selector>();
        newSelectorList.addAll(propertySelList);
        newSelectorList.addAll(domainSelList);
        newSelectorList.addAll(rangeSelList);
        newSelectorList.addAll(dataPathSelList);
        newSelectorList.addAll(unknownSelList);
        newSelectorList.addAll(instanceSelList);
        newSelectorList.addAll(classSelList);
        newSelectorList.addAll(restSelList);
        sfwQuery.setFromPart(newSelectorList);
    }

    private static List _reorderDataPathSelectors(List dataPathSelList) {
        ArrayList<DataPathSelector> zeroVarsList = new ArrayList<DataPathSelector>();
        ArrayList<DataPathSelector> oneVarList = new ArrayList<DataPathSelector>();
        ArrayList<DataPathSelector> twoVarsList = new ArrayList<DataPathSelector>();
        int selectorCount = dataPathSelList.size();
        block5: for (int i = 0; i < selectorCount; ++i) {
            DataPathSelector dps = (DataPathSelector)dataPathSelList.get(i);
            int varCount = 0;
            if (!dps.getSourceVar().hasValue()) {
                ++varCount;
            }
            if (!dps.getTargetVar().hasValue()) {
                ++varCount;
            }
            switch (varCount) {
                case 0: {
                    zeroVarsList.add(dps);
                    continue block5;
                }
                case 1: {
                    oneVarList.add(dps);
                    continue block5;
                }
                case 2: {
                    twoVarsList.add(dps);
                }
            }
        }
        ArrayList<DataPathSelector> result2 = new ArrayList<DataPathSelector>();
        result2.addAll(zeroVarsList);
        result2.addAll(oneVarList);
        result2.addAll(twoVarsList);
        return result2;
    }
}

