/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql;

import java.io.IOException;
import java.io.StringReader;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.RqlOptimizer;
import org.openrdf.sesame.query.rql.model.BooleanQuery;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.parser.ParseException;
import org.openrdf.sesame.query.rql.parser.RqlParser;
import org.openrdf.sesame.query.rql.parser.TokenMgrError;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.util.StringUtil;

public class RqlEngine {
    protected RdfSchemaSource _rss;

    public RqlEngine(RdfSchemaSource rss) {
        if (rss == null) {
            throw new IllegalArgumentException("rss must not be nul");
        }
        this._rss = rss;
    }

    public void evaluateQuery(Query query2, TableQueryResultListener resList) throws IOException, QueryEvaluationException {
        if ((query2 = RqlOptimizer.optimize(query2)) instanceof ResourceQuery) {
            ResourceQuery resourceQuery = (ResourceQuery)query2;
            resourceQuery.evaluate(this._rss, resList);
        } else if (query2 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query2;
            boolean result2 = booleanQuery.isTrue(this._rss);
            resList.startTableQueryResult();
            resList.startTuple();
            resList.tupleValue(new LiteralImpl(String.valueOf(result2)));
            resList.endTuple();
            resList.endTableQueryResult();
        }
    }

    public Query parseQuery(String rqlQuery) throws MalformedQueryException {
        rqlQuery = this._swapUsingNamespace(rqlQuery);
        RqlParser rqlParser = new RqlParser(new StringReader(rqlQuery));
        try {
            return rqlParser.parse();
        }
        catch (TokenMgrError tme) {
            throw new MalformedQueryException(tme.getMessage());
        }
        catch (ParseException pe) {
            throw new MalformedQueryException(pe);
        }
    }

    private String _swapUsingNamespace(String query2) {
        String result2;
        String queryLC = query2.toLowerCase();
        int usingIdx = StringUtil.lastIndexOfWord((String)queryLC, (String)"using");
        if (usingIdx != -1) {
            String part1 = query2.substring(0, usingIdx);
            String part2 = query2.substring(usingIdx);
            result2 = part2 + "\n" + part1;
        } else {
            result2 = query2;
        }
        return result2;
    }
}

