/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rdql;

import java.io.IOException;
import java.io.StringReader;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQuery;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rdql.parser.ParseException;
import org.openrdf.sesame.query.rdql.parser.RdqlParser;
import org.openrdf.sesame.query.rdql.parser.TokenMgrError;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.util.StringUtil;

public class RdqlEngine {
    protected RdfSource _rdfSource;

    public RdqlEngine(RdfSource rdfSource) {
        if (rdfSource == null) {
            throw new IllegalArgumentException("rdfSource must not be nul");
        }
        this._rdfSource = rdfSource;
    }

    public void evaluateQuery(TableQuery tableQuery, TableQueryResultListener tableListener) throws IOException, QueryEvaluationException {
        tableQuery.optimize(this._rdfSource);
        tableQuery.evaluate(this._rdfSource, tableListener);
    }

    public TableQuery parseQuery(String rdqlQuery) throws MalformedQueryException {
        rdqlQuery = this._swapUsing(rdqlQuery);
        RdqlParser rdqlParser = new RdqlParser(new StringReader(rdqlQuery));
        try {
            return rdqlParser.parseQuery();
        }
        catch (TokenMgrError tme) {
            throw new MalformedQueryException(tme.getMessage());
        }
        catch (ParseException pe) {
            throw new MalformedQueryException(pe);
        }
    }

    private String _swapUsing(String query2) {
        String result2;
        String queryLC = query2.toLowerCase();
        int usingIdx = StringUtil.lastIndexOfWord((String)queryLC, (String)"using");
        if (usingIdx != -1) {
            String part1 = query2.substring(0, usingIdx);
            String part2 = query2.substring(usingIdx);
            result2 = part2 + "\n" + part1;
        } else {
            result2 = query2;
        }
        return result2;
    }
}

