/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.GraphQueryResultListener;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.NamespaceIterator;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.Query;
import org.openrdf.sesame.sail.query.QueryAnswer;
import org.openrdf.sesame.sail.query.QueryAnswerListener;
import org.openrdf.sesame.sail.query.SailQueryException;

public class GraphQuery {
    private Query _query;
    private Map _queryNamespaces;

    public GraphQuery(Query query2, Map namespaces) {
        this._query = query2;
        this._queryNamespaces = namespaces;
    }

    public Query getQuery() {
        return this._query;
    }

    public void optimize(RdfSource source) {
        this._query = source.optimizeQuery(this._query);
    }

    public void evaluate(RdfSource rdfSource, GraphQueryResultListener listener) throws QueryEvaluationException {
        try {
            this._reportNamespaces(rdfSource, listener);
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        try {
            listener.startGraphQueryResult();
            this._query.evaluate(rdfSource, new QAL2GQRL(listener));
            listener.endGraphQueryResult();
        }
        catch (SailQueryException e) {
            throw new QueryEvaluationException(e);
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    private void _reportNamespaces(RdfSource rdfSource, GraphQueryResultListener listener) throws IOException {
        String name2;
        String prefix;
        HashMap<String, String> nsMap = new HashMap<String, String>();
        NamespaceIterator nsIter = rdfSource.getNamespaces();
        while (nsIter.hasNext()) {
            nsIter.next();
            nsMap.put(nsIter.getPrefix(), nsIter.getName());
        }
        nsIter.close();
        Iterator prefixes = this._queryNamespaces.keySet().iterator();
        while (prefixes.hasNext()) {
            prefix = (String)prefixes.next();
            name2 = (String)this._queryNamespaces.get(prefix);
            nsMap.values().remove(name2);
            nsMap.put(prefix, name2);
        }
        prefixes = nsMap.keySet().iterator();
        while (prefixes.hasNext()) {
            prefix = (String)prefixes.next();
            name2 = (String)nsMap.get(prefix);
            listener.namespace(prefix, name2);
        }
    }

    public String toString() {
        return "GraphQuery [" + super.toString() + "]";
    }

    private static class QAL2GQRL
    implements QueryAnswerListener {
        private GraphQueryResultListener _listener;

        public QAL2GQRL(GraphQueryResultListener listener) {
            this._listener = listener;
        }

        public boolean queryAnswer(QueryAnswer qa) throws IOException {
            Resource subject = (Resource)qa.getValue(0);
            URI predicate = (URI)qa.getValue(1);
            Value object = qa.getValue(2);
            this._listener.triple(subject, predicate, object);
            return true;
        }

        public void clear() {
        }

        public void reportError(String msg) throws IOException, QueryEvaluationException {
            this._listener.reportError(msg);
        }
    }
}

